/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsAEADCipher
implements TlsCipher {
    public static final int AEAD_CCM = 1;
    public static final int AEAD_CHACHA20_POLY1305 = 2;
    public static final int AEAD_GCM = 3;
    private static final int NONCE_RFC5288 = 1;
    private static final int NONCE_RFC7905 = 2;
    protected final TlsCryptoParameters cryptoParams;
    protected final int keySize;
    protected final int macSize;
    protected final int fixed_iv_length;
    protected final int record_iv_length;
    protected final TlsAEADCipherImpl decryptCipher;
    protected final TlsAEADCipherImpl encryptCipher;
    protected final byte[] decryptNonce;
    protected final byte[] encryptNonce;
    protected final boolean isTLSv13;
    protected final int nonceMode;

    public TlsAEADCipher(TlsCryptoParameters tlsCryptoParameters, TlsAEADCipherImpl tlsAEADCipherImpl, TlsAEADCipherImpl tlsAEADCipherImpl2, int n, int n2, int n3) throws IOException {
        SecurityParameters securityParameters = tlsCryptoParameters.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (!TlsImplUtils.isTLSv12(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.isTLSv13 = TlsImplUtils.isTLSv13(protocolVersion);
        this.nonceMode = TlsAEADCipher.getNonceMode(this.isTLSv13, n3);
        switch (this.nonceMode) {
            case 1: {
                this.fixed_iv_length = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                this.fixed_iv_length = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.cryptoParams = tlsCryptoParameters;
        this.keySize = n;
        this.macSize = n2;
        this.decryptCipher = tlsAEADCipherImpl2;
        this.encryptCipher = tlsAEADCipherImpl;
        this.decryptNonce = new byte[this.fixed_iv_length];
        this.encryptNonce = new byte[this.fixed_iv_length];
        boolean bl = tlsCryptoParameters.isServer();
        if (this.isTLSv13) {
            this.rekeyCipher(securityParameters, tlsAEADCipherImpl2, this.decryptNonce, !bl);
            this.rekeyCipher(securityParameters, tlsAEADCipherImpl, this.encryptNonce, bl);
            return;
        }
        int n4 = 2 * n + 2 * this.fixed_iv_length;
        byte[] byArray = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n4);
        int n5 = 0;
        if (bl) {
            tlsAEADCipherImpl2.setKey(byArray, n5, n);
            tlsAEADCipherImpl.setKey(byArray, n5 += n, n);
            System.arraycopy(byArray, n5 += n, this.decryptNonce, 0, this.fixed_iv_length);
            System.arraycopy(byArray, n5 += this.fixed_iv_length, this.encryptNonce, 0, this.fixed_iv_length);
            n5 += this.fixed_iv_length;
        } else {
            tlsAEADCipherImpl.setKey(byArray, n5, n);
            tlsAEADCipherImpl2.setKey(byArray, n5 += n, n);
            System.arraycopy(byArray, n5 += n, this.encryptNonce, 0, this.fixed_iv_length);
            System.arraycopy(byArray, n5 += this.fixed_iv_length, this.decryptNonce, 0, this.fixed_iv_length);
            n5 += this.fixed_iv_length;
        }
        if (n4 != n5) {
            throw new TlsFatalAlert(80);
        }
        int n6 = this.fixed_iv_length + this.record_iv_length;
        byte[] byArray2 = new byte[n6];
        byArray2[0] = ~this.encryptNonce[0];
        byArray2[1] = ~this.decryptNonce[1];
        tlsAEADCipherImpl.init(byArray2, n2, null);
        tlsAEADCipherImpl2.init(byArray2, n2, null);
    }

    @Override
    public int getCiphertextDecodeLimit(int n) {
        return n + this.macSize + this.record_iv_length + (this.isTLSv13 ? 1 : 0);
    }

    @Override
    public int getCiphertextEncodeLimit(int n, int n2) {
        int n3 = n;
        if (this.isTLSv13) {
            int n4 = 0;
            n3 = 1 + Math.min(n2, n + n4);
        }
        return n3 + this.macSize + this.record_iv_length;
    }

    @Override
    public int getPlaintextLimit(int n) {
        return n - this.macSize - this.record_iv_length - (this.isTLSv13 ? 1 : 0);
    }

    @Override
    public TlsEncodeResult encodePlaintext(long l, short s, ProtocolVersion protocolVersion, int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray2 = new byte[this.encryptNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptNonce, 0, byArray2, 0, this.encryptNonce.length);
                TlsUtils.writeUint64(l, byArray2, this.encryptNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(l, byArray2, byArray2.length - 8);
                for (n4 = 0; n4 < this.encryptNonce.length; ++n4) {
                    int n5 = n4;
                    byArray2[n5] = (byte)(byArray2[n5] ^ this.encryptNonce[n4]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n4 = this.isTLSv13 ? 1 : 0;
        int n6 = this.encryptCipher.getOutputSize(n3 + n4);
        int n7 = this.record_iv_length + n6;
        byte[] byArray3 = new byte[n + n7];
        int n8 = n;
        if (this.record_iv_length != 0) {
            System.arraycopy(byArray2, byArray2.length - this.record_iv_length, byArray3, n8, this.record_iv_length);
            n8 += this.record_iv_length;
        }
        short s2 = this.isTLSv13 ? (short)23 : (short)s;
        byte[] byArray4 = this.getAdditionalData(l, s2, protocolVersion, n7, n3);
        try {
            this.encryptCipher.init(byArray2, this.macSize, byArray4);
            System.arraycopy(byArray, n2, byArray3, n8, n3);
            if (this.isTLSv13) {
                byArray3[n8 + n3] = (byte)s;
            }
            n8 += this.encryptCipher.doFinal(byArray3, n8, n3 + n4, byArray3, n8);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        if (n8 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return new TlsEncodeResult(byArray3, 0, byArray3.length, s2);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long l, short s, ProtocolVersion protocolVersion, byte[] byArray, int n, int n2) throws IOException {
        short s2;
        int n3;
        int n4;
        block10: {
            byte by;
            int n5;
            if (this.getPlaintextLimit(n2) < 0) {
                throw new TlsFatalAlert(50);
            }
            byte[] byArray2 = new byte[this.decryptNonce.length + this.record_iv_length];
            switch (this.nonceMode) {
                case 1: {
                    System.arraycopy(this.decryptNonce, 0, byArray2, 0, this.decryptNonce.length);
                    System.arraycopy(byArray, n, byArray2, byArray2.length - this.record_iv_length, this.record_iv_length);
                    break;
                }
                case 2: {
                    TlsUtils.writeUint64(l, byArray2, byArray2.length - 8);
                    for (n4 = 0; n4 < this.decryptNonce.length; ++n4) {
                        int n6 = n4;
                        byArray2[n6] = (byte)(byArray2[n6] ^ this.decryptNonce[n4]);
                    }
                    break;
                }
                default: {
                    throw new TlsFatalAlert(80);
                }
            }
            n4 = n + this.record_iv_length;
            int n7 = n2 - this.record_iv_length;
            n3 = this.decryptCipher.getOutputSize(n7);
            byte[] byArray3 = this.getAdditionalData(l, s, protocolVersion, n2, n3);
            try {
                this.decryptCipher.init(byArray2, this.macSize, byArray3);
                n5 = this.decryptCipher.doFinal(byArray, n4, n7, byArray, n4);
            }
            catch (RuntimeException runtimeException) {
                throw new TlsFatalAlert(20, (Throwable)runtimeException);
            }
            if (n5 != n3) {
                throw new TlsFatalAlert(80);
            }
            s2 = s;
            if (!this.isTLSv13) break block10;
            int n8 = n3;
            do {
                if (--n8 >= 0) continue;
                throw new TlsFatalAlert(10);
            } while (0 == (by = byArray[n4 + n8]));
            s2 = (short)(by & 0xFF);
            n3 = n8;
        }
        return new TlsDecodeResult(byArray, n4, n3, s2);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        this.rekeyCipher(this.cryptoParams.getSecurityParametersConnection(), this.decryptCipher, this.decryptNonce, !this.cryptoParams.isServer());
    }

    @Override
    public void rekeyEncoder() throws IOException {
        this.rekeyCipher(this.cryptoParams.getSecurityParametersConnection(), this.encryptCipher, this.encryptNonce, this.cryptoParams.isServer());
    }

    @Override
    public boolean usesOpaqueRecordType() {
        return this.isTLSv13;
    }

    protected byte[] getAdditionalData(long l, short s, ProtocolVersion protocolVersion, int n, int n2) throws IOException {
        if (this.isTLSv13) {
            byte[] byArray = new byte[5];
            TlsUtils.writeUint8(s, byArray, 0);
            TlsUtils.writeVersion(protocolVersion, byArray, 1);
            TlsUtils.writeUint16(n, byArray, 3);
            return byArray;
        }
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(l, byArray, 0);
        TlsUtils.writeUint8(s, byArray, 8);
        TlsUtils.writeVersion(protocolVersion, byArray, 9);
        TlsUtils.writeUint16(n2, byArray, 11);
        return byArray;
    }

    protected void rekeyCipher(SecurityParameters securityParameters, TlsAEADCipherImpl tlsAEADCipherImpl, byte[] byArray, boolean bl) throws IOException {
        TlsSecret tlsSecret;
        if (!this.isTLSv13) {
            throw new TlsFatalAlert(80);
        }
        TlsSecret tlsSecret2 = tlsSecret = bl ? securityParameters.getTrafficSecretServer() : securityParameters.getTrafficSecretClient();
        if (null == tlsSecret) {
            throw new TlsFatalAlert(80);
        }
        this.setup13Cipher(tlsAEADCipherImpl, byArray, tlsSecret, securityParameters.getPRFCryptoHashAlgorithm());
    }

    protected void setup13Cipher(TlsAEADCipherImpl tlsAEADCipherImpl, byte[] byArray, TlsSecret tlsSecret, int n) throws IOException {
        byte[] byArray2 = TlsCryptoUtils.hkdfExpandLabel(tlsSecret, n, "key", TlsUtils.EMPTY_BYTES, this.keySize).extract();
        byte[] byArray3 = TlsCryptoUtils.hkdfExpandLabel(tlsSecret, n, "iv", TlsUtils.EMPTY_BYTES, this.fixed_iv_length).extract();
        tlsAEADCipherImpl.setKey(byArray2, 0, this.keySize);
        System.arraycopy(byArray3, 0, byArray, 0, this.fixed_iv_length);
        byArray3[0] = (byte)(byArray3[0] ^ 0x80);
        tlsAEADCipherImpl.init(byArray3, this.macSize, null);
    }

    private static int getNonceMode(boolean bl, int n) throws IOException {
        switch (n) {
            case 1: 
            case 3: {
                return bl ? 2 : 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new TlsFatalAlert(80);
    }
}

