/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.steps.ErrorReplacingProcessReader;
import io.quarkus.deployment.pkg.steps.GraalVM;
import io.quarkus.deployment.util.ProcessUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public abstract class NativeImageBuildRunner {
    private static final Logger log = Logger.getLogger(NativeImageBuildRunner.class);

    public GraalVM.Version getGraalVMVersion() {
        GraalVM.Version graalVMVersion;
        try {
            CharSequence[] versionCommand = this.getGraalVMVersionCommand(Collections.singletonList("--version"));
            log.debugf(String.join((CharSequence)" ", versionCommand).replace("$", "\\$"), new Object[0]);
            Process versionProcess = new ProcessBuilder((String[])versionCommand).redirectErrorStream(true).start();
            versionProcess.waitFor();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(versionProcess.getInputStream(), StandardCharsets.UTF_8));){
                graalVMVersion = GraalVM.Version.of(reader.lines());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get GraalVM version", e);
        }
        return graalVMVersion;
    }

    public void setup(boolean processInheritIODisabled) {
    }

    public void addShutdownHook(Process buildNativeProcess) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result build(List<String> args, String nativeImageName, String resultingExecutableName, Path outputDir, boolean debugSymbolsEnabled, boolean processInheritIODisabled) throws InterruptedException, IOException {
        this.preBuild(args);
        try {
            CountDownLatch errorReportLatch = new CountDownLatch(1);
            CharSequence[] buildCommand = this.getBuildCommand(args);
            ProcessBuilder processBuilder = new ProcessBuilder((String[])buildCommand).directory(outputDir.toFile());
            log.info((Object)String.join((CharSequence)" ", buildCommand).replace("$", "\\$"));
            Process process = ProcessUtil.launchProcessStreamStdOut(processBuilder, processInheritIODisabled);
            this.addShutdownHook(process);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(new ErrorReplacingProcessReader(process.getErrorStream(), outputDir.resolve("reports").toFile(), errorReportLatch));
            executor.shutdown();
            errorReportLatch.await();
            int exitCode = process.waitFor();
            boolean objcopyExists = this.objcopyExists();
            if (exitCode != 0) {
                Result result = new Result(exitCode, objcopyExists);
                return result;
            }
            if (objcopyExists) {
                if (debugSymbolsEnabled) {
                    this.splitDebugSymbols(nativeImageName, resultingExecutableName);
                }
                this.objcopy("--strip-debug", resultingExecutableName);
            } else if (SystemUtils.IS_OS_LINUX) {
                log.warn((Object)"objcopy executable not found in PATH. Debug symbols will therefore not be separated from the executable.");
                log.warn((Object)"That also means that resulting native executable is larger as it embeds the debug symbols.");
            }
            Result result = new Result(0, objcopyExists);
            return result;
        }
        finally {
            this.postBuild();
        }
    }

    private void splitDebugSymbols(String nativeImageName, String resultingExecutableName) {
        String symbols = String.format("%s.debug", nativeImageName);
        this.objcopy("--only-keep-debug", resultingExecutableName, symbols);
        this.objcopy(String.format("--add-gnu-debuglink=%s", symbols), resultingExecutableName);
    }

    protected abstract String[] getGraalVMVersionCommand(List<String> var1);

    protected abstract String[] getBuildCommand(List<String> var1);

    protected boolean objcopyExists() {
        return true;
    }

    protected abstract void objcopy(String ... var1);

    protected void preBuild(List<String> buildArgs) throws IOException, InterruptedException {
    }

    protected void postBuild() throws InterruptedException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runCommand(String[] command, String errorMsg, File workingDirectory) {
        log.info((Object)String.join((CharSequence)" ", command).replace("$", "\\$"));
        Process process = null;
        try {
            int exitCode;
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            if (workingDirectory != null) {
                processBuilder.directory(workingDirectory);
            }
            if ((exitCode = (process = processBuilder.start()).waitFor()) != 0) {
                if (errorMsg != null) {
                    log.error((Object)errorMsg);
                } else {
                    log.debugf("Command: " + String.join((CharSequence)" ", command) + " failed with exit code " + exitCode, new Object[0]);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            if (errorMsg != null) {
                log.error((Object)errorMsg);
            } else {
                log.debugf((Throwable)e, "Command: " + String.join((CharSequence)" ", command) + " failed.", new Object[0]);
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    static class Result {
        private final int exitCode;
        private final boolean objcopyExists;

        public Result(int exitCode, boolean objcopyExists) {
            this.exitCode = exitCode;
            this.objcopyExists = objcopyExists;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public boolean isObjcopyExists() {
            return this.objcopyExists;
        }
    }
}

