/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule;

import java.io.StringReader;
import java.io.StringWriter;
import org.jboss.byteman.java_cup.runtime.Symbol;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.RuleElement;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.ParseException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.ExpressionHelper;
import org.jboss.byteman.rule.grammar.ECAGrammarParser;
import org.jboss.byteman.rule.grammar.ECATokenLexer;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class Condition
extends RuleElement {
    private Expression condition;

    public static Condition create(Rule rule, ParseNode conditionTree) throws TypeException {
        Condition condition = new Condition(rule, conditionTree);
        return condition;
    }

    public static Condition create(Rule rule, String text) throws ParseException, TypeException {
        if ("".equals(text)) {
            return new Condition(rule);
        }
        String fulltext = "BIND NOTHING IF \n" + text + "\n DO NOTHING";
        try {
            ECATokenLexer lexer = new ECATokenLexer(new StringReader(text));
            ECAGrammarParser parser = new ECAGrammarParser(lexer);
            Symbol condition_parse = parser.parse();
            ParseNode conditionTree = (ParseNode)condition_parse.value;
            Condition condition = new Condition(rule, conditionTree);
            return condition;
        }
        catch (Exception e) {
            throw new ParseException("org.jboss.byteman.rule.Condition : error parsing condition\n" + text, e);
        }
    }

    protected Condition(Rule rule, ParseNode conditionTree) throws TypeException {
        super(rule);
        int tag = conditionTree.getTag();
        this.condition = ExpressionHelper.createExpression(rule, rule.getBindings(), conditionTree, Type.BOOLEAN);
        this.condition.bind();
    }

    protected Condition(Rule rule) {
        super(rule);
        this.condition = null;
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        if (this.condition != null) {
            this.condition.typeCheck(Type.Z);
        }
        return Type.Z;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        int currentStack = compileContext.getStackCount();
        this.condition.compile(mv, compileContext);
        if (this.condition.getType() == Type.BOOLEAN) {
            compileContext.compileUnbox(Type.BOOLEAN, Type.Z);
        }
        if (compileContext.getStackCount() != currentStack + 1) {
            throw new CompileException("Condition.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack);
        }
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Boolean result = (Boolean)this.condition.interpret(helper);
        return result;
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        if (this.condition == null) {
            stringWriter.write("IF   TRUE");
        } else {
            stringWriter.write("IF   ");
            this.condition.writeTo(stringWriter);
        }
        stringWriter.write("\n");
    }
}

