/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.capability.resources;

import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.model.IPod;
import java.io.InputStream;
import org.apache.commons.lang.ArrayUtils;

public interface IRSyncable
extends IBinaryCapability {
    public static final IBinaryCapability.OpenShiftBinaryOption EXCLUDE_GIT_FOLDER = new GitFolderExclude();
    public static final IBinaryCapability.OpenShiftBinaryOption NO_PERMS = new NoPerms();
    public static final IBinaryCapability.OpenShiftBinaryOption DELETE = new Delete();

    public static IBinaryCapability.OpenShiftBinaryOption exclude(String ... expressions) {
        return new Exclude(expressions);
    }

    public InputStream sync(Peer var1, Peer var2, IBinaryCapability.OpenShiftBinaryOption ... var3);

    public void stop();

    public boolean isDone();

    public int exitValue();

    public void await() throws InterruptedException;

    public static abstract class Peer
    implements IBinaryCapability.OpenShiftBinaryOption {
        private String location;

        private Peer(String path) {
            this.location = path;
        }

        protected String getLocation() {
            return this.location;
        }

        protected abstract String getParameter();

        public abstract boolean isPod();

        public abstract IPod getPod();

        @Override
        public void append(StringBuilder commandLine) {
            commandLine.append(" ").append(this.getParameter());
        }

        public String toString() {
            return this.getParameter();
        }
    }

    public static class LocalPeer
    extends Peer {
        public LocalPeer(String location) {
            super(location);
        }

        @Override
        public boolean isPod() {
            return false;
        }

        @Override
        public IPod getPod() {
            return null;
        }

        @Override
        protected String getParameter() {
            return '\"' + this.getLocation() + '\"';
        }
    }

    public static class PodPeer
    extends Peer {
        private static final char POD_PATH_SEPARATOR = ':';
        private IPod pod;

        public PodPeer(String location, IPod pod) {
            super(location);
            this.pod = pod;
        }

        @Override
        public boolean isPod() {
            return true;
        }

        @Override
        public IPod getPod() {
            return this.pod;
        }

        @Override
        protected String getParameter() {
            return '\"' + this.pod.getName() + ':' + this.getLocation() + '\"';
        }
    }

    public static class Delete
    implements IBinaryCapability.OpenShiftBinaryOption {
        @Override
        public void append(StringBuilder arguments) {
            arguments.append(" --delete");
        }
    }

    public static class NoPerms
    implements IBinaryCapability.OpenShiftBinaryOption {
        @Override
        public void append(StringBuilder arguments) {
            arguments.append(" --no-perms=true");
        }
    }

    public static class GitFolderExclude
    extends Exclude {
        public GitFolderExclude() {
            super(".git");
        }
    }

    public static class Exclude
    implements IBinaryCapability.OpenShiftBinaryOption {
        private String[] expressions;

        public Exclude(String ... expressions) {
            this.expressions = expressions;
        }

        @Override
        public void append(StringBuilder arguments) {
            if (ArrayUtils.isEmpty((Object[])this.expressions)) {
                return;
            }
            for (String expression : this.expressions) {
                arguments.append(" --exclude=").append(expression);
            }
        }
    }
}

