/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.legacy.infinispan;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.metrics.config.MicrometerMeterRegisterConfigurationBuilder;
import org.jboss.logging.Logger;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class CacheManagerFactory {
    private String config;
    private boolean metricsEnabled;
    private DefaultCacheManager cacheManager;
    private Future<DefaultCacheManager> cacheManagerFuture;
    private ExecutorService executor;
    private boolean initialized;

    public CacheManagerFactory(String config, boolean metricsEnabled) {
        this.config = config;
        this.metricsEnabled = metricsEnabled;
        this.executor = this.createThreadPool();
        this.cacheManagerFuture = this.executor.submit(this::startCacheManager);
    }

    public DefaultCacheManager getOrCreate() {
        if (this.cacheManager == null) {
            if (this.initialized) {
                return null;
            }
            try {
                DefaultCacheManager defaultCacheManager = this.cacheManager = this.cacheManagerFuture.get(this.getStartTimeout().intValue(), TimeUnit.SECONDS);
                return defaultCacheManager;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to start caches", e);
            }
            finally {
                this.shutdownThreadPool();
            }
        }
        return this.cacheManager;
    }

    private ExecutorService createThreadPool() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "keycloak-cache-init");
            }
        });
    }

    private DefaultCacheManager startCacheManager() {
        ConfigurationBuilderHolder builder = new ParserRegistry().parse(this.config);
        if (((ConfigurationBuilder)builder.getNamedConfigurationBuilders().get("sessions")).clustering().cacheMode().isClustered()) {
            this.configureTransportStack(builder);
        }
        if (this.metricsEnabled) {
            builder.getGlobalConfigurationBuilder().addModule(MicrometerMeterRegisterConfigurationBuilder.class);
            ((MicrometerMeterRegisterConfigurationBuilder)builder.getGlobalConfigurationBuilder().module(MicrometerMeterRegisterConfigurationBuilder.class)).meterRegistry((MeterRegistry)Metrics.globalRegistry);
        }
        builder.getGlobalConfigurationBuilder().serialization().marshaller((Marshaller)new JBossUserMarshaller());
        return new DefaultCacheManager(builder, this.isStartEagerly());
    }

    private boolean isStartEagerly() {
        return Boolean.parseBoolean(System.getProperty("kc.cache-ispn-start-eagerly", Boolean.TRUE.toString()));
    }

    private Integer getStartTimeout() {
        return Integer.getInteger("kc.cache-ispn-start-timeout", 120);
    }

    private void shutdownThreadPool() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                        Logger.getLogger(CacheManagerFactory.class).warn((Object)"Cache init thread pool not terminated");
                    }
                }
            }
            catch (Exception cause) {
                this.executor.shutdownNow();
            }
            finally {
                this.executor = null;
                this.cacheManagerFuture = null;
                this.config = null;
                this.initialized = true;
            }
        }
    }

    private void configureTransportStack(ConfigurationBuilderHolder builder) {
        String transportStack = Configuration.getRawValue("kc.cache-stack");
        if (transportStack != null) {
            builder.getGlobalConfigurationBuilder().transport().defaultTransport().addProperty("configurationFile", (Object)("default-configs/default-jgroups-" + transportStack + ".xml"));
        }
    }
}

