/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import org.infinispan.client.hotrod.RemoteCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.hotRod.HotRodMapStorageProviderFactory;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;
import org.keycloak.models.map.storage.hotRod.connections.HotRodConnectionProvider;
import org.keycloak.models.map.storage.hotRod.transaction.AllAreasHotRodTransactionsWrapper;
import org.keycloak.models.map.storage.hotRod.transaction.HotRodRemoteTransactionWrapper;

public class HotRodMapStorageProvider
implements MapStorageProvider {
    private final KeycloakSession session;
    private final HotRodMapStorageProviderFactory factory;
    private final String hotRodConfigurationIdentifier;
    private final boolean jtaEnabled;

    public HotRodMapStorageProvider(KeycloakSession session, HotRodMapStorageProviderFactory factory, String hotRodConfigurationIdentifier, boolean jtaEnabled) {
        this.session = session;
        this.factory = factory;
        this.hotRodConfigurationIdentifier = hotRodConfigurationIdentifier;
        this.jtaEnabled = jtaEnabled;
    }

    public <V extends AbstractEntity, M> MapStorage<V, M> getStorage(Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        AllAreasHotRodTransactionsWrapper txWrapper = (AllAreasHotRodTransactionsWrapper)((Object)this.session.getAttribute(this.hotRodConfigurationIdentifier, AllAreasHotRodTransactionsWrapper.class));
        if (txWrapper == null) {
            txWrapper = new AllAreasHotRodTransactionsWrapper();
            this.session.setAttribute(this.hotRodConfigurationIdentifier, (Object)txWrapper);
            this.session.getTransactionManager().enlistPrepare((KeycloakTransaction)txWrapper);
            if (!this.jtaEnabled) {
                HotRodConnectionProvider connectionProvider = (HotRodConnectionProvider)this.session.getProvider(HotRodConnectionProvider.class);
                HotRodEntityDescriptor<?, ?> entityDescriptor = this.factory.getEntityDescriptor(modelType);
                RemoteCache remoteCache = connectionProvider.getRemoteCache(entityDescriptor.getCacheName());
                this.session.getTransactionManager().enlist((KeycloakTransaction)new HotRodRemoteTransactionWrapper(remoteCache.getTransactionManager()));
            }
        }
        return this.factory.getHotRodStorage(this.session, modelType, txWrapper, flags);
    }

    public void close() {
    }
}

