/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.Map;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.multimap.impl.PersistenceContextInitializerImpl;
import org.infinispan.multimap.impl.function.ContainsFunction;
import org.infinispan.multimap.impl.function.GetFunction;
import org.infinispan.multimap.impl.function.PutFunction;
import org.infinispan.multimap.impl.function.RemoveFunction;
import org.infinispan.protostream.SerializationContextInitializer;

@InfinispanModule(name="multimap", requiredModules={"core"})
public class MultimapModuleLifecycle
implements ModuleLifecycle {
    private static void addAdvancedExternalizer(Map<Integer, AdvancedExternalizer<?>> map, AdvancedExternalizer<?> ext) {
        map.put(ext.getId(), ext);
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.GLOBAL, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        Map externalizerMap = globalConfiguration.serialization().advancedExternalizers();
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, PutFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, RemoveFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, ContainsFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, GetFunction.EXTERNALIZER);
    }
}

