/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.math.BigInteger;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.NodeList;

public class NokogiriXPathFunction
implements XPathFunction {
    private final IRubyObject handler;
    private final QName name;
    private final int arity;

    public static NokogiriXPathFunction create(IRubyObject iRubyObject, QName qName, int n) {
        return new NokogiriXPathFunction(iRubyObject, qName, n);
    }

    private NokogiriXPathFunction(IRubyObject iRubyObject, QName qName, int n) {
        this.handler = iRubyObject;
        this.name = qName;
        this.arity = n;
    }

    public Object evaluate(List list) throws XPathFunctionException {
        if (list.size() != this.arity) {
            throw new XPathFunctionException("arity does not match");
        }
        if (this.name.getNamespaceURI().equals("https://www.nokogiri.org/default_ns/ruby/builtins") && this.name.getLocalPart().equals("css-class")) {
            return NokogiriXPathFunction.builtinCssClass(list);
        }
        if (this.handler.isNil()) {
            throw new XPathFunctionException("no custom function handler declared for '" + this.name + "'");
        }
        Ruby ruby = this.handler.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        IRubyObject iRubyObject = Helpers.invoke((ThreadContext)threadContext, (IRubyObject)this.handler, (String)this.name.getLocalPart(), (IRubyObject[])NokogiriXPathFunction.fromObjectToRubyArgs(ruby, list));
        return NokogiriXPathFunction.fromRubyToObject(ruby, iRubyObject);
    }

    private static IRubyObject[] fromObjectToRubyArgs(Ruby ruby, List list) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            iRubyObjectArray[i] = NokogiriXPathFunction.fromObjectToRuby(ruby, list.get(i));
        }
        return iRubyObjectArray;
    }

    private static IRubyObject fromObjectToRuby(Ruby ruby, Object object) {
        if (object instanceof NodeList) {
            IRubyObject[] iRubyObjectArray = NokogiriHelpers.nodeListToRubyArray(ruby, (NodeList)object);
            return XmlNodeSet.newNodeSet(ruby, iRubyObjectArray);
        }
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)ruby, (Object)object);
    }

    private static Object fromRubyToObject(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return iRubyObject.asJavaString();
        }
        if (iRubyObject instanceof RubyBoolean) {
            return iRubyObject.toJava(Boolean.class);
        }
        if (iRubyObject instanceof RubyFloat) {
            return iRubyObject.toJava(Double.class);
        }
        if (iRubyObject instanceof RubyInteger) {
            if (iRubyObject instanceof RubyFixnum) {
                return RubyFixnum.fix2long((IRubyObject)iRubyObject);
            }
            return iRubyObject.toJava(BigInteger.class);
        }
        if (iRubyObject instanceof XmlNodeSet) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyArray) {
            return XmlNodeSet.newNodeSet(ruby, ((RubyArray)iRubyObject).toJavaArray());
        }
        return ((XmlNode)iRubyObject).getNode();
    }

    private static boolean builtinCssClass(List list) throws XPathFunctionException {
        if (list.size() != 2) {
            throw new XPathFunctionException("builtin function nokogiri:css-class takes two arguments");
        }
        String string = list.get(0).toString();
        String string2 = list.get(1).toString();
        if (string2.length() == 0) {
            return true;
        }
        int n = 0;
        int n2 = string.length() - string2.length();
        while (n <= n2) {
            int n3;
            for (n3 = 0; n3 < string2.length() && string2.charAt(n3) == string.charAt(n + n3); ++n3) {
            }
            if (n3 == string2.length() && (string.length() == n + n3 || NokogiriXPathFunction.isWhitespace(string.charAt(n + n3)))) {
                return true;
            }
            while (n <= n2 && !NokogiriXPathFunction.isWhitespace(string.charAt(n))) {
                ++n;
            }
            while (n <= n2 && NokogiriXPathFunction.isWhitespace(string.charAt(n))) {
                ++n;
            }
        }
        return false;
    }

    private static boolean isWhitespace(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c == ' ';
    }
}

