/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.io.Serializable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.Javafier;
import org.logstash.RubyUtil;
import org.logstash.Valuefier;

public final class ConvertedMap
extends IdentityHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final ConcurrentHashMap<String, String> KEY_CACHE = new ConcurrentHashMap(100, 0.2f, 16);
    private static final RubyHash.VisitorWithState<ConvertedMap> RUBY_HASH_VISITOR = new RubyHash.VisitorWithState<ConvertedMap>(){

        public void visit(ThreadContext context, RubyHash self, IRubyObject key, IRubyObject value, int index, ConvertedMap state) {
            if (key instanceof RubyString) {
                state.putInterned(ConvertedMap.convertKey((RubyString)key), Valuefier.convert(value));
            } else {
                state.put(key.toString(), Valuefier.convert(value));
            }
        }
    };

    static String internStringForUseAsKey(String candidate) {
        String cached = KEY_CACHE.get(candidate);
        if (cached != null) {
            return cached;
        }
        String interned = candidate.intern();
        if (KEY_CACHE.size() <= 10000) {
            KEY_CACHE.put(interned, interned);
        }
        return interned;
    }

    static void internStringsForUseAsKeys(String[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            candidates[i] = ConvertedMap.internStringForUseAsKey(candidates[i]);
        }
    }

    ConvertedMap() {
        super(10);
    }

    ConvertedMap(int size) {
        super(size);
    }

    public static ConvertedMap newFromMap(Map<? extends Serializable, Object> o) {
        ConvertedMap cm = new ConvertedMap(o.size());
        for (Map.Entry<? extends Serializable, Object> entry : o.entrySet()) {
            Serializable found = entry.getKey();
            if (found instanceof String) {
                cm.put((String)((Object)found), Valuefier.convert(entry.getValue()));
                continue;
            }
            cm.putInterned(ConvertedMap.convertKey((RubyString)found), entry.getValue());
        }
        return cm;
    }

    public static ConvertedMap newFromRubyHash(RubyHash o) {
        return ConvertedMap.newFromRubyHash(RubyUtil.RUBY.getCurrentContext(), o);
    }

    public static ConvertedMap newFromRubyHash(ThreadContext context, RubyHash o) {
        ConvertedMap result = new ConvertedMap(o.size());
        o.visitAll(context, RUBY_HASH_VISITOR, (Object)result);
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(ConvertedMap.internStringForUseAsKey(key), value);
    }

    public void putInterned(String key, Object value) {
        super.put(key, value);
    }

    public Object unconvert() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            result.put((String)entry.getKey(), Javafier.deep(entry.getValue()));
        }
        return result;
    }

    private static String convertKey(RubyString key) {
        return ConvertedMap.internStringForUseAsKey(key.asJavaString());
    }
}

