/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.logstash.common.SourceWithMetadata;
import org.logstash.common.Util;
import org.logstash.config.ir.Hashable;
import org.logstash.config.ir.HashableWithSource;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.graph.BooleanEdge;
import org.logstash.config.ir.graph.Edge;
import org.logstash.config.ir.graph.PlainEdge;
import org.logstash.config.ir.graph.QueueVertex;
import org.logstash.config.ir.graph.SeparatorVertex;
import org.logstash.config.ir.graph.Vertex;
import org.logstash.config.ir.graph.algorithms.BreadthFirst;
import org.logstash.config.ir.graph.algorithms.GraphDiff;
import org.logstash.config.ir.graph.algorithms.TopologicalSort;

public final class Graph
implements SourceComponent,
Hashable {
    private final Set<Vertex> vertices = new LinkedHashSet<Vertex>();
    private final Set<Edge> edges = new LinkedHashSet<Edge>();
    private Map<Vertex, Integer> vertexRanks = new LinkedHashMap<Vertex, Integer>();
    private final Map<Vertex, Set<Edge>> outgoingEdgeLookup = new LinkedHashMap<Vertex, Set<Edge>>();
    private final Map<Vertex, Set<Edge>> incomingEdgeLookup = new LinkedHashMap<Vertex, Set<Edge>>();
    private List<Vertex> sortedVertices;

    public Graph(Collection<Vertex> vertices, Collection<Edge> edges) throws InvalidIRException {
        for (Vertex vertex : vertices) {
            this.addVertex(vertex, false);
        }
        for (Edge edge : edges) {
            this.addEdge(edge, false);
        }
        this.refresh();
    }

    public Graph() {
    }

    public static Graph empty() {
        return new Graph();
    }

    public void addVertex(Vertex v) throws InvalidIRException {
        this.addVertex(v, true);
    }

    private void addVertex(Vertex v, boolean doRefresh) throws InvalidIRException {
        if (v.getGraph() != null && v.getGraph() != this) {
            throw new InvalidIRException("Attempted to add vertex already belonging to a graph!");
        }
        v.setGraph(this);
        this.vertices.add(v);
        if (doRefresh) {
            this.refresh();
        }
    }

    public Vertex importVertex(Vertex v) throws InvalidIRException {
        if (v.getGraph() != this) {
            if (v.getGraph() == null) {
                this.addVertex(v);
                return v;
            }
            Vertex copy = v.copy();
            this.addVertex(copy);
            return copy;
        }
        return v;
    }

    public Vertex getVertexById(String id) {
        return this.vertices().filter(v -> v.getId().equals(id)).findAny().get();
    }

    private Graph addEdge(Edge e, boolean doRefresh) throws InvalidIRException {
        if (!this.vertices.contains(e.getFrom()) || !this.vertices.contains(e.getTo())) {
            throw new InvalidIRException("Attempted to add edge referencing vertices not in this graph!");
        }
        this.edges.add(e);
        BiFunction<Vertex, Set, Set> lookupComputeFunction = (vertex, edgeSet) -> {
            if (edgeSet == null) {
                edgeSet = new LinkedHashSet<Edge>();
            }
            edgeSet.add(e);
            return edgeSet;
        };
        this.outgoingEdgeLookup.compute(e.getFrom(), lookupComputeFunction);
        this.incomingEdgeLookup.compute(e.getTo(), lookupComputeFunction);
        e.setGraph(this);
        if (doRefresh) {
            this.refresh();
        }
        return this;
    }

    protected Collection<Edge> getOutgoingEdges(Vertex v) {
        return this.outgoingEdgeLookup.getOrDefault(v, Collections.emptySet());
    }

    protected Collection<Edge> getIncomingEdges(Vertex v) {
        return this.incomingEdgeLookup.getOrDefault(v, Collections.emptySet());
    }

    public Graph copy() throws InvalidIRException {
        return Graph.combine((Graph[])new Graph[]{this}).graph;
    }

    public static GraphCombinationResult combine(Graph ... graphs) throws InvalidIRException {
        LinkedHashMap<Vertex, Vertex> oldToNewVertices = new LinkedHashMap<Vertex, Vertex>();
        LinkedHashMap<Edge, Edge> oldToNewEdges = new LinkedHashMap<Edge, Edge>();
        for (Graph graph : graphs) {
            graph.vertices().forEachOrdered(v -> oldToNewVertices.put((Vertex)v, v.copy()));
            for (Edge e : graph.getEdges()) {
                Edge copy = e.copy((Vertex)oldToNewVertices.get(e.getFrom()), (Vertex)oldToNewVertices.get(e.getTo()));
                oldToNewEdges.put(e, copy);
            }
        }
        Graph newGraph = new Graph(oldToNewVertices.values(), oldToNewEdges.values());
        return new GraphCombinationResult(newGraph, oldToNewVertices, oldToNewEdges);
    }

    public Graph chain(Graph otherGraph) throws InvalidIRException {
        if (otherGraph.vertices.isEmpty()) {
            return this.copy();
        }
        if (this.isEmpty()) {
            return otherGraph.copy();
        }
        GraphCombinationResult combineResult = Graph.combine(this, otherGraph);
        Collection fromLeaves = this.allLeaves().map(combineResult.oldToNewVertices::get).collect(Collectors.toList());
        Collection toRoots = otherGraph.roots().map(combineResult.oldToNewVertices::get).collect(Collectors.toList());
        return combineResult.graph.chain(fromLeaves, toRoots);
    }

    public Graph chain(Vertex ... otherVertex) throws InvalidIRException {
        this.chain(this.getAllLeaves(), Arrays.asList(otherVertex));
        return this;
    }

    private Graph chain(Collection<Vertex> fromLeaves, Collection<Vertex> toVertices) throws InvalidIRException {
        for (Vertex leaf : fromLeaves) {
            for (Edge.EdgeFactory unusedEf : leaf.getUnusedOutgoingEdgeFactories()) {
                for (Vertex toVertex : toVertices) {
                    this.chainVertices(unusedEf, leaf, toVertex);
                }
            }
        }
        return this;
    }

    public Collection<Edge> chainVerticesById(String ... vertexIds) throws InvalidIRException {
        return this.chainVerticesById(PlainEdge.factory, vertexIds);
    }

    public Collection<Edge> chainVerticesById(Edge.EdgeFactory edgeFactory, String ... vertexIds) throws InvalidIRException {
        Vertex[] argVertices = new Vertex[vertexIds.length];
        for (int i = 0; i < vertexIds.length; ++i) {
            String id = vertexIds[i];
            Vertex v = this.getVertexById(id);
            if (v == null) {
                throw new InvalidIRException("Could not chain vertex, id not found in graph: !" + id + "\n" + this);
            }
            argVertices[i] = v;
        }
        return this.chainVertices(edgeFactory, argVertices);
    }

    public Collection<Edge> chainVerticesUnsafe(Edge.EdgeFactory edgeFactory, Vertex ... argVertices) throws InvalidIRException {
        ArrayList<Vertex> importedVertices = new ArrayList<Vertex>(argVertices.length);
        for (Vertex va : argVertices) {
            importedVertices.add(this.importVertex(va));
        }
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        for (int i = 0; i < importedVertices.size() - 1; ++i) {
            Vertex from = (Vertex)importedVertices.get(i);
            Vertex to = (Vertex)importedVertices.get(i + 1);
            this.addVertex(from, false);
            this.addVertex(to, false);
            Edge edge = edgeFactory.make(from, to);
            newEdges.add(edge);
            this.addEdge(edge, false);
        }
        this.refresh();
        return newEdges;
    }

    public Collection<Edge> chainVertices(Edge.EdgeFactory edgeFactory, Vertex ... argVertices) throws InvalidIRException {
        Collection<Edge> edges = this.chainVerticesUnsafe(edgeFactory, argVertices);
        return edges;
    }

    public Edge chainVertices(Vertex a, Vertex b) throws InvalidIRException {
        return this.chainVertices(PlainEdge.factory, a, b).stream().findFirst().get();
    }

    public Collection<Edge> chainVertices(Vertex ... vertices) throws InvalidIRException {
        return this.chainVertices(PlainEdge.factory, vertices);
    }

    public Collection<Edge> chainVertices(boolean bool, Vertex ... vertices) throws InvalidIRException {
        BooleanEdge.BooleanEdgeFactory factory = bool ? BooleanEdge.trueFactory : BooleanEdge.falseFactory;
        return this.chainVertices(factory, vertices);
    }

    public void refresh() throws InvalidIRException {
        this.calculateRanks();
        this.vertices.forEach(Vertex::clearCache);
        this.calculateTopologicalSort();
    }

    private void calculateTopologicalSort() throws InvalidIRException {
        try {
            this.sortedVertices = TopologicalSort.sortVertices(this);
        }
        catch (TopologicalSort.UnexpectedGraphCycleError unexpectedGraphCycleError) {
            throw new InvalidIRException("Graph is not a dag!", unexpectedGraphCycleError);
        }
    }

    private void calculateRanks() {
        this.vertexRanks = BreadthFirst.breadthFirst(this.getRoots()).vertexDistances;
    }

    public Integer rank(Vertex vertex) {
        Integer rank = this.vertexRanks.get(vertex);
        if (rank == null) {
            throw new RuntimeException("Attempted to get rank from vertex where it is not yet calculated: " + this);
        }
        return rank;
    }

    public void validate() throws InvalidIRException {
        if (this.isEmpty()) {
            return;
        }
        if (this.getVertices().stream().noneMatch(Vertex::isLeaf)) {
            throw new InvalidIRException("Graph has no leaf vertices!\n" + this.toString());
        }
        List duplicateIdErrorMessages = this.vertices().collect(Collectors.groupingBy(Vertex::getId)).values().stream().filter(group -> group.size() > 1).map(group -> "ID: " + ((Vertex)group.stream().findAny().get()).getId() + " " + group.stream().map(Object::toString).collect(Collectors.joining("\n"))).collect(Collectors.toList());
        if (!duplicateIdErrorMessages.isEmpty()) {
            String dupeErrors = duplicateIdErrorMessages.stream().collect(Collectors.joining("\n"));
            throw new InvalidIRException("Config has duplicate Ids: \n" + dupeErrors);
        }
    }

    public Stream<Vertex> roots() {
        return this.vertices.stream().filter(Vertex::isRoot);
    }

    public Collection<Vertex> getRoots() {
        return this.roots().collect(Collectors.toList());
    }

    public Stream<Vertex> allLeaves() {
        return this.vertices().filter(Vertex::isPartialLeaf);
    }

    public Collection<Vertex> getAllLeaves() {
        return this.allLeaves().collect(Collectors.toList());
    }

    public Stream<Vertex> leaves() {
        return this.vertices().filter(Vertex::isLeaf);
    }

    public Collection<Vertex> getLeaves() {
        return this.leaves().collect(Collectors.toList());
    }

    public Set<Vertex> getVertices() {
        return this.vertices;
    }

    public Collection<Edge> getEdges() {
        return this.edges;
    }

    public String toString() {
        Stream<Edge> edgesToFormat = this.sortedEdges();
        Object edgelessVerticesStr = this.isolatedVertices().count() > 0L ? "\n== Vertices Without Edges ==\n" + this.isolatedVertices().map(Object::toString).collect(Collectors.joining("\n")) : "";
        return "**GRAPH**\nVertices: " + this.vertices.size() + " Edges: " + this.edges().count() + "\n----------------------" + edgesToFormat.map(Edge::toString).collect(Collectors.joining("\n")) + (String)edgelessVerticesStr + "\n**GRAPH**";
    }

    public Stream<Vertex> isolatedVertices() {
        return this.vertices().filter(v -> v.getOutgoingEdges().isEmpty() && v.getIncomingEdges().isEmpty());
    }

    public List<Vertex> getSortedVertices() {
        return this.sortedVertices;
    }

    public Stream<Edge> sortedEdges() {
        return this.getSortedVertices().stream().flatMap(Vertex::outgoingEdges);
    }

    public List<Vertex> getSortedVerticesBefore(Vertex end) {
        return this.getSortedVerticesBetween(null, end);
    }

    public List<Vertex> getSortedVerticesAfter(Vertex start) {
        return this.getSortedVerticesBetween(start, null);
    }

    public List<Vertex> getSortedVerticesBetween(Vertex start, Vertex end) {
        int startIndex = start == null ? 0 : this.sortedVertices.indexOf(start);
        int endIndex = end == null ? this.sortedVertices.size() : this.sortedVertices.indexOf(end);
        return this.sortedVertices.subList(startIndex + 1, endIndex);
    }

    @Override
    public boolean sourceComponentEquals(SourceComponent sourceComponent) {
        if (sourceComponent == this) {
            return true;
        }
        if (sourceComponent instanceof Graph) {
            Graph otherGraph = (Graph)sourceComponent;
            GraphDiff.DiffResult diff = GraphDiff.diff(this, otherGraph);
            return diff.isIdentical();
        }
        return false;
    }

    public boolean hasEquivalentEdge(Edge otherE) {
        return this.edges().anyMatch(e -> e.sourceComponentEquals(otherE));
    }

    public boolean hasEquivalentVertex(Vertex otherV) {
        return this.vertices().anyMatch(v -> v.sourceComponentEquals(otherV));
    }

    @Override
    public SourceWithMetadata getSourceWithMetadata() {
        return null;
    }

    public boolean isEmpty() {
        return this.vertices.isEmpty();
    }

    public Stream<Vertex> vertices() {
        return this.vertices.stream();
    }

    public Stream<Edge> edges() {
        return this.edges.stream();
    }

    @Override
    public String uniqueHash() {
        return Util.digest(this.vertices().filter(v -> !(v instanceof QueueVertex) && !(v instanceof SeparatorVertex)).map(Vertex::getSourceWithMetadata).map(HashableWithSource::uniqueHash).sorted().collect(Collectors.joining()));
    }

    public static final class GraphCombinationResult {
        public final Graph graph;
        public final Map<Vertex, Vertex> oldToNewVertices;
        public final Map<Edge, Edge> oldToNewEdges;

        GraphCombinationResult(Graph graph, Map<Vertex, Vertex> oldToNewVertices, Map<Edge, Edge> oldToNewEdges) {
            this.graph = graph;
            this.oldToNewVertices = oldToNewVertices;
            this.oldToNewEdges = oldToNewEdges;
        }
    }
}

