/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ext.psych.PsychEmitter;
import org.jruby.ext.psych.PsychParser;
import org.jruby.ext.psych.PsychToRuby;
import org.jruby.ext.psych.PsychYamlTree;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.yaml.snakeyaml.error.Mark;

public class PsychLibrary
implements Library {
    private static final String DUMMY_VERSION = "0.0";

    public void load(Ruby ruby, boolean bl) {
        RubyString rubyString;
        Object object;
        RubyModule rubyModule = ruby.defineModule("Psych");
        Properties properties = new Properties();
        try {
            object = ruby.getJRubyClassLoader().getResourceAsStream("META-INF/maven/org.yaml/snakeyaml/pom.properties");
            rubyString = null;
            try {
                properties.load((InputStream)object);
            }
            catch (Throwable object2) {
                rubyString = object2;
                throw object2;
            }
            finally {
                if (object != null) {
                    if (rubyString != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            rubyString.addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = properties.getProperty("version", DUMMY_VERSION);
        if (((String)object).endsWith("-SNAPSHOT")) {
            object = ((String)object).substring(0, ((String)object).length() - "-SNAPSHOT".length());
        }
        if (((String)object).equals(DUMMY_VERSION)) {
            try {
                Mark.class.getConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw ruby.newLoadError("bad SnakeYAML version, required 1.21 or higher; check your CLASSPATH for a conflicting jar");
            }
        } else {
            rubyString = ((String)object).split("\\.");
            if (((String[])rubyString).length < 2 || Integer.parseInt(rubyString[0]) < 1 || Integer.parseInt(rubyString[1]) < 21) {
                throw ruby.newLoadError("bad SnakeYAML version " + (String)object + ", required 1.21 or higher; check your CLASSPATH for a conflicting jar");
            }
        }
        rubyString = ruby.newString((String)object + ".0");
        rubyString.setFrozen(true);
        rubyModule.setConstant("SNAKEYAML_VERSION", (IRubyObject)rubyString);
        String[] stringArray = rubyString.toString().split("\\.");
        final RubyArray rubyArray = ruby.newArray(new IRubyObject[]{ruby.newFixnum(Integer.parseInt(stringArray[0])), ruby.newFixnum(Integer.parseInt(stringArray[1])), ruby.newFixnum(Integer.parseInt(stringArray[2]))});
        rubyArray.setFrozen(true);
        rubyModule.getSingletonClass().addMethod("libyaml_version", (DynamicMethod)new JavaMethod.JavaMethodZero(rubyModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                return rubyArray;
            }
        });
        PsychParser.initPsychParser(ruby, rubyModule);
        PsychEmitter.initPsychEmitter(ruby, rubyModule);
        PsychToRuby.initPsychToRuby(ruby, rubyModule);
        PsychYamlTree.initPsychYamlTree(ruby, rubyModule);
    }

    public static enum YAMLEncoding {
        YAML_ANY_ENCODING((Encoding)UTF8Encoding.INSTANCE),
        YAML_UTF8_ENCODING((Encoding)UTF8Encoding.INSTANCE),
        YAML_UTF16LE_ENCODING((Encoding)UTF16LEEncoding.INSTANCE),
        YAML_UTF16BE_ENCODING((Encoding)UTF16BEEncoding.INSTANCE);

        public final Encoding encoding;

        private YAMLEncoding(Encoding encoding) {
            this.encoding = encoding;
        }
    }
}

