/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.geoip;

import com.maxmind.db.CHMCache;
import com.maxmind.db.InvalidDatabaseException;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.IspResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.Event;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.filters.geoip.Fields;

public class GeoIPFilter {
    private static Logger logger = LogManager.getLogger();
    private static final String CITY_LITE_DB_TYPE = "GeoLite2-City";
    private static final String COUNTRY_LITE_DB_TYPE = "GeoLite2-Country";
    private static final String ASN_LITE_DB_TYPE = "GeoLite2-ASN";
    private static final String CITY_DB_TYPE = "GeoIP2-City";
    private static final String CITY_AFRICA_DB_TYPE = "GeoIP2-City-Africa";
    private static final String CITY_ASIA_PACIFIC_DB_TYPE = "GeoIP2-City-Asia-Pacific";
    private static final String CITY_EUROPE_DB_TYPE = "GeoIP2-City-Europe";
    private static final String CITY_NORTH_AMERICA_DB_TYPE = "GeoIP2-City-North-America";
    private static final String CITY_SOUTH_AMERICA_DB_TYPE = "GeoIP2-City-South-America";
    private static final String COUNTRY_DB_TYPE = "GeoIP2-Country";
    private static final String ISP_DB_TYPE = "GeoIP2-ISP";
    private static final String DOMAIN_DB_TYPE = "GeoIP2-Domain";
    private final String sourceField;
    private final String targetField;
    private final Set<Fields> desiredFields;
    private final DatabaseReader databaseReader;
    private final Function<Fields, String> fieldReferenceExtractor;

    public GeoIPFilter(String sourceField, String targetField, List<String> fields, String databasePath, int cacheSize, String ecsCompatibility) {
        this.sourceField = sourceField;
        this.targetField = targetField;
        switch (ecsCompatibility) {
            case "disabled": {
                this.fieldReferenceExtractor = Fields::getFieldReferenceLegacy;
                break;
            }
            case "v1": 
            case "v8": {
                this.fieldReferenceExtractor = Fields::getFieldReferenceECSv1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown ECS version " + ecsCompatibility);
            }
        }
        File database = new File(databasePath);
        try {
            this.databaseReader = new DatabaseReader.Builder(database).withCache((NodeCache)new CHMCache(cacheSize)).build();
        }
        catch (InvalidDatabaseException e) {
            throw new IllegalArgumentException("The database provided is invalid or corrupted.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The database provided was not found in the path", e);
        }
        this.desiredFields = this.createDesiredFields(fields, !ecsCompatibility.equals("disabled"));
    }

    public static boolean isDatabaseValid(String databasePath) {
        File database = new File(databasePath);
        try {
            new DatabaseReader.Builder(database).build();
            return true;
        }
        catch (InvalidDatabaseException e) {
            logger.debug("The database provided is invalid or corrupted");
        }
        catch (IOException e) {
            logger.debug("The database provided was not found in the path");
        }
        return false;
    }

    private Set<Fields> createDesiredFields(List<String> fields, boolean ecsCompatibilityEnabled) {
        EnumSet<Fields> desiredFields = EnumSet.noneOf(Fields.class);
        if (fields == null || fields.isEmpty()) {
            switch (this.databaseReader.getMetadata().getDatabaseType()) {
                case "GeoLite2-City": 
                case "GeoIP2-City": 
                case "GeoIP2-City-Africa": 
                case "GeoIP2-City-Asia-Pacific": 
                case "GeoIP2-City-Europe": 
                case "GeoIP2-City-North-America": 
                case "GeoIP2-City-South-America": {
                    desiredFields = ecsCompatibilityEnabled ? Fields.DEFAULT_ECS_CITY_FIELDS : Fields.DEFAULT_CITY_FIELDS;
                    break;
                }
                case "GeoLite2-Country": 
                case "GeoIP2-Country": {
                    desiredFields = Fields.DEFAULT_COUNTRY_FIELDS;
                    break;
                }
                case "GeoIP2-ISP": {
                    desiredFields = Fields.DEFAULT_ISP_FIELDS;
                    break;
                }
                case "GeoLite2-ASN": {
                    desiredFields = Fields.DEFAULT_ASN_LITE_FIELDS;
                    break;
                }
                case "GeoIP2-Domain": {
                    desiredFields = Fields.DEFAULT_DOMAIN_FIELDS;
                }
            }
        } else {
            for (String fieldName : fields) {
                desiredFields.add(Fields.parseField(fieldName));
            }
        }
        return desiredFields;
    }

    public boolean handleEvent(JrubyEventExtLibrary.RubyEvent rubyEvent) {
        String ip;
        Event event = rubyEvent.getEvent();
        Object input = event.getField(this.sourceField);
        if (input == null) {
            return false;
        }
        if (input instanceof List) {
            ip = (String)((List)input).get(0);
        } else if (input instanceof String) {
            ip = (String)input;
        } else {
            throw new IllegalArgumentException("Expected input field value to be String or List type");
        }
        if (ip.trim().isEmpty()) {
            return false;
        }
        Map<Fields, Object> geoData = new HashMap<Fields, Object>();
        try {
            InetAddress ipAddress = InetAddress.getByName(ip);
            switch (this.databaseReader.getMetadata().getDatabaseType()) {
                case "GeoLite2-City": 
                case "GeoIP2-City": 
                case "GeoIP2-City-Africa": 
                case "GeoIP2-City-Asia-Pacific": 
                case "GeoIP2-City-Europe": 
                case "GeoIP2-City-North-America": 
                case "GeoIP2-City-South-America": {
                    geoData = this.retrieveCityGeoData(ipAddress);
                    break;
                }
                case "GeoLite2-Country": 
                case "GeoIP2-Country": {
                    geoData = this.retrieveCountryGeoData(ipAddress);
                    break;
                }
                case "GeoLite2-ASN": {
                    geoData = this.retrieveAsnGeoData(ipAddress);
                    break;
                }
                case "GeoIP2-ISP": {
                    geoData = this.retrieveIspGeoData(ipAddress);
                    break;
                }
                case "GeoIP2-Domain": {
                    geoData = this.retrieveDomainGeoData(ipAddress);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported database type " + this.databaseReader.getMetadata().getDatabaseType() + "");
                }
            }
        }
        catch (UnknownHostException e) {
            logger.debug("IP Field contained invalid IP address or hostname. exception={}, field={}, event={}", (Object)e, (Object)this.sourceField, (Object)event);
        }
        catch (AddressNotFoundException e) {
            logger.debug("IP not found! exception={}, field={}, event={}", (Object)e, (Object)this.sourceField, (Object)event);
        }
        catch (GeoIp2Exception | IOException e) {
            logger.debug("GeoIP2 Exception. exception={}, field={}, event={}", (Object)e, (Object)this.sourceField, (Object)event);
        }
        return this.applyGeoData(geoData, event);
    }

    private boolean applyGeoData(Map<Fields, Object> geoData, Event event) {
        if (geoData == null) {
            return false;
        }
        if (event.getField(this.targetField) == null) {
            event.setField(this.targetField, Collections.emptyMap());
        }
        if (geoData.isEmpty()) {
            return false;
        }
        String targetFieldReference = "[" + this.targetField + "]";
        for (Map.Entry<Fields, Object> it : geoData.entrySet()) {
            Fields field = it.getKey();
            String subFieldReference = this.fieldReferenceExtractor.apply(field);
            if (subFieldReference.equals("[]")) continue;
            event.setField(targetFieldReference + subFieldReference, it.getValue());
        }
        return true;
    }

    private Map<Fields, Object> retrieveCityGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        CityResponse response = this.databaseReader.city(ipAddress);
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Postal postal = response.getPostal();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        HashMap<Fields, Object> geoData = new HashMap<Fields, Object>();
        if (location.getLatitude() == null && location.getLongitude() == null) {
            return geoData;
        }
        for (Fields desiredField : this.desiredFields) {
            switch (desiredField) {
                case CITY_NAME: {
                    String cityName = city.getName();
                    if (cityName == null) break;
                    geoData.put(Fields.CITY_NAME, cityName);
                    break;
                }
                case CONTINENT_CODE: {
                    String continentCode = continent.getCode();
                    if (continentCode == null) break;
                    geoData.put(Fields.CONTINENT_CODE, continentCode);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put(Fields.CONTINENT_NAME, continentName);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) break;
                    geoData.put(Fields.COUNTRY_NAME, countryName);
                    break;
                }
                case COUNTRY_CODE2: {
                    String countryCode2 = country.getIsoCode();
                    if (countryCode2 == null) break;
                    geoData.put(Fields.COUNTRY_CODE2, countryCode2);
                    break;
                }
                case COUNTRY_CODE3: {
                    String countryCode3 = country.getIsoCode();
                    if (countryCode3 == null) break;
                    geoData.put(Fields.COUNTRY_CODE3, countryCode3);
                    break;
                }
                case IP: {
                    geoData.put(Fields.IP, ipAddress.getHostAddress());
                    break;
                }
                case POSTAL_CODE: {
                    String postalCode = postal.getCode();
                    if (postalCode == null) break;
                    geoData.put(Fields.POSTAL_CODE, postalCode);
                    break;
                }
                case DMA_CODE: {
                    Integer dmaCode = location.getMetroCode();
                    if (dmaCode == null) break;
                    geoData.put(Fields.DMA_CODE, dmaCode);
                    break;
                }
                case REGION_NAME: {
                    String subdivisionName = subdivision.getName();
                    if (subdivisionName == null) break;
                    geoData.put(Fields.REGION_NAME, subdivisionName);
                    break;
                }
                case REGION_CODE: {
                    String subdivisionCode = subdivision.getIsoCode();
                    if (subdivisionCode == null) break;
                    geoData.put(Fields.REGION_CODE, subdivisionCode);
                    break;
                }
                case REGION_ISO_CODE: {
                    String countryCodeForRegion = country.getIsoCode();
                    String regionCode2 = subdivision.getIsoCode();
                    if (countryCodeForRegion == null || regionCode2 == null) break;
                    geoData.put(Fields.REGION_ISO_CODE, String.format("%s-%s", countryCodeForRegion, regionCode2));
                    break;
                }
                case TIMEZONE: {
                    String locationTimeZone = location.getTimeZone();
                    if (locationTimeZone == null) break;
                    geoData.put(Fields.TIMEZONE, locationTimeZone);
                    break;
                }
                case LOCATION: {
                    Double latitude = location.getLatitude();
                    Double longitude = location.getLongitude();
                    if (latitude == null || longitude == null) break;
                    HashMap<String, Double> locationObject = new HashMap<String, Double>();
                    locationObject.put("lat", latitude);
                    locationObject.put("lon", longitude);
                    geoData.put(Fields.LOCATION, locationObject);
                    break;
                }
                case LATITUDE: {
                    Double lat = location.getLatitude();
                    if (lat == null) break;
                    geoData.put(Fields.LATITUDE, lat);
                    break;
                }
                case LONGITUDE: {
                    Double lon = location.getLongitude();
                    if (lon == null) break;
                    geoData.put(Fields.LONGITUDE, lon);
                }
            }
        }
        return geoData;
    }

    private Map<Fields, Object> retrieveCountryGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        CountryResponse response = this.databaseReader.country(ipAddress);
        Country country = response.getCountry();
        Continent continent = response.getContinent();
        HashMap<Fields, Object> geoData = new HashMap<Fields, Object>();
        for (Fields desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Fields.IP, ipAddress.getHostAddress());
                    break;
                }
                case COUNTRY_CODE2: {
                    String countryCode2 = country.getIsoCode();
                    if (countryCode2 == null) break;
                    geoData.put(Fields.COUNTRY_CODE2, countryCode2);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) break;
                    geoData.put(Fields.COUNTRY_NAME, countryName);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put(Fields.CONTINENT_NAME, continentName);
                }
            }
        }
        return geoData;
    }

    private Map<Fields, Object> retrieveIspGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        IspResponse response = this.databaseReader.isp(ipAddress);
        HashMap<Fields, Object> geoData = new HashMap<Fields, Object>();
        for (Fields desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Fields.IP, ipAddress.getHostAddress());
                    break;
                }
                case AUTONOMOUS_SYSTEM_NUMBER: {
                    Integer asn = response.getAutonomousSystemNumber();
                    if (asn == null) break;
                    geoData.put(Fields.AUTONOMOUS_SYSTEM_NUMBER, asn);
                    break;
                }
                case AUTONOMOUS_SYSTEM_ORGANIZATION: {
                    String aso = response.getAutonomousSystemOrganization();
                    if (aso == null) break;
                    geoData.put(Fields.AUTONOMOUS_SYSTEM_ORGANIZATION, aso);
                    break;
                }
                case ISP: {
                    String isp = response.getIsp();
                    if (isp == null) break;
                    geoData.put(Fields.ISP, isp);
                    break;
                }
                case ORGANIZATION: {
                    String org = response.getOrganization();
                    if (org == null) break;
                    geoData.put(Fields.ORGANIZATION, org);
                }
            }
        }
        return geoData;
    }

    private Map<Fields, Object> retrieveAsnGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        AsnResponse response = this.databaseReader.asn(ipAddress);
        HashMap<Fields, Object> geoData = new HashMap<Fields, Object>();
        for (Fields desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Fields.IP, ipAddress.getHostAddress());
                    break;
                }
                case AUTONOMOUS_SYSTEM_NUMBER: {
                    Integer asn = response.getAutonomousSystemNumber();
                    if (asn == null) break;
                    geoData.put(Fields.AUTONOMOUS_SYSTEM_NUMBER, asn);
                    break;
                }
                case AUTONOMOUS_SYSTEM_ORGANIZATION: {
                    String aso = response.getAutonomousSystemOrganization();
                    if (aso == null) break;
                    geoData.put(Fields.AUTONOMOUS_SYSTEM_ORGANIZATION, aso);
                }
            }
        }
        return geoData;
    }

    private Map<Fields, Object> retrieveDomainGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        DomainResponse response = this.databaseReader.domain(ipAddress);
        HashMap<Fields, Object> geoData = new HashMap<Fields, Object>();
        for (Fields desiredField : this.desiredFields) {
            switch (desiredField) {
                case DOMAIN: {
                    String domain = response.getDomain();
                    geoData.put(Fields.DOMAIN, domain);
                }
            }
        }
        return geoData;
    }
}

