/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXComment
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASTNODE;
    public static final int TRANSLATIONUNIT;

    public CXComment(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXComment.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public long ASTNode() {
        return CXComment.nASTNode(this.address());
    }

    @NativeType(value="CXTranslationUnit")
    public long TranslationUnit() {
        return CXComment.nTranslationUnit(this.address());
    }

    public static CXComment malloc() {
        return (CXComment)CXComment.wrap(CXComment.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXComment calloc() {
        return (CXComment)CXComment.wrap(CXComment.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXComment create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXComment)CXComment.wrap(CXComment.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXComment create(long address) {
        return (CXComment)CXComment.wrap(CXComment.class, (long)address);
    }

    @Nullable
    public static CXComment createSafe(long address) {
        return address == 0L ? null : (CXComment)CXComment.wrap(CXComment.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXComment.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXComment.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXComment.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXComment.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXComment.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXComment.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXComment.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXComment mallocStack() {
        return CXComment.mallocStack(MemoryStack.stackGet());
    }

    public static CXComment callocStack() {
        return CXComment.callocStack(MemoryStack.stackGet());
    }

    public static CXComment mallocStack(MemoryStack stack) {
        return (CXComment)CXComment.wrap(CXComment.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXComment callocStack(MemoryStack stack) {
        return (CXComment)CXComment.wrap(CXComment.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXComment.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXComment.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXComment.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXComment.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nASTNode(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ASTNODE));
    }

    public static long nTranslationUnit(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TRANSLATIONUNIT));
    }

    static {
        Struct.Layout layout = CXComment.__struct((Struct.Member[])new Struct.Member[]{CXComment.__member((int)POINTER_SIZE), CXComment.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASTNODE = layout.offsetof(0);
        TRANSLATIONUNIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXComment, Buffer>
    implements NativeResource {
        private static final CXComment ELEMENT_FACTORY = CXComment.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXComment getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *")
        public long ASTNode() {
            return CXComment.nASTNode(this.address());
        }

        @NativeType(value="CXTranslationUnit")
        public long TranslationUnit() {
            return CXComment.nTranslationUnit(this.address());
        }
    }
}

