/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct MDB_val")
public class MDBVal
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MV_SIZE;
    public static final int MV_DATA;

    public MDBVal(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MDBVal.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long mv_size() {
        return MDBVal.nmv_size(this.address());
    }

    @Nullable
    @NativeType(value="void *")
    public ByteBuffer mv_data() {
        return MDBVal.nmv_data(this.address());
    }

    public MDBVal mv_size(@NativeType(value="size_t") long value) {
        MDBVal.nmv_size(this.address(), value);
        return this;
    }

    public MDBVal mv_data(@Nullable @NativeType(value="void *") ByteBuffer value) {
        MDBVal.nmv_data(this.address(), value);
        return this;
    }

    public MDBVal set(long mv_size, @Nullable ByteBuffer mv_data) {
        this.mv_size(mv_size);
        this.mv_data(mv_data);
        return this;
    }

    public MDBVal set(MDBVal src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static MDBVal malloc() {
        return (MDBVal)MDBVal.wrap(MDBVal.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static MDBVal calloc() {
        return (MDBVal)MDBVal.wrap(MDBVal.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static MDBVal create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (MDBVal)MDBVal.wrap(MDBVal.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static MDBVal create(long address) {
        return (MDBVal)MDBVal.wrap(MDBVal.class, (long)address);
    }

    @Nullable
    public static MDBVal createSafe(long address) {
        return address == 0L ? null : (MDBVal)MDBVal.wrap(MDBVal.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)MDBVal.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)MDBVal.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)MDBVal.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MDBVal.__create((int)capacity, (int)SIZEOF);
        return (Buffer)MDBVal.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)MDBVal.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)MDBVal.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static MDBVal mallocStack() {
        return MDBVal.mallocStack(MemoryStack.stackGet());
    }

    public static MDBVal callocStack() {
        return MDBVal.callocStack(MemoryStack.stackGet());
    }

    public static MDBVal mallocStack(MemoryStack stack) {
        return (MDBVal)MDBVal.wrap(MDBVal.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MDBVal callocStack(MemoryStack stack) {
        return (MDBVal)MDBVal.wrap(MDBVal.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MDBVal.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MDBVal.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)MDBVal.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)MDBVal.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nmv_size(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MV_SIZE));
    }

    @Nullable
    public static ByteBuffer nmv_data(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)MV_DATA)), (int)((int)MDBVal.nmv_size(struct)));
    }

    public static void nmv_size(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MV_SIZE), (long)value);
    }

    public static void nmv_data(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MV_DATA), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        if (value != null) {
            MDBVal.nmv_size(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = MDBVal.__struct((Struct.Member[])new Struct.Member[]{MDBVal.__member((int)POINTER_SIZE), MDBVal.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MV_SIZE = layout.offsetof(0);
        MV_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<MDBVal, Buffer>
    implements NativeResource {
        private static final MDBVal ELEMENT_FACTORY = MDBVal.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MDBVal getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long mv_size() {
            return MDBVal.nmv_size(this.address());
        }

        @Nullable
        @NativeType(value="void *")
        public ByteBuffer mv_data() {
            return MDBVal.nmv_data(this.address());
        }

        public Buffer mv_size(@NativeType(value="size_t") long value) {
            MDBVal.nmv_size(this.address(), value);
            return this;
        }

        public Buffer mv_data(@Nullable @NativeType(value="void *") ByteBuffer value) {
            MDBVal.nmv_data(this.address(), value);
            return this;
        }
    }
}

