"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiLoadingChart", {
  enumerable: true,
  get: function get() {
    return _loading_chart.EuiLoadingChart;
  }
});
exports.OuiLoadingChart = exports.SIZES = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _loading_chart = require("../../eui_components/loading/loading_chart");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var sizeToClassNameMap = {
  m: 'ouiLoadingChart--medium',
  l: 'ouiLoadingChart--large',
  xl: 'ouiLoadingChart--xLarge'
};
var SIZES = (0, _common.keysOf)(sizeToClassNameMap);
exports.SIZES = SIZES;

var OuiLoadingChart = function OuiLoadingChart(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$mono = _ref.mono,
      mono = _ref$mono === void 0 ? false : _ref$mono,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["size", "mono", "className"]);

  var classes = (0, _classnames.default)('ouiLoadingChart', {
    'ouiLoadingChart--mono': mono
  }, className, sizeToClassNameMap[size]);
  return /*#__PURE__*/_react.default.createElement("span", _extends({
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiLoadingChart__bar"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiLoadingChart__bar"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiLoadingChart__bar"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiLoadingChart__bar"
  }));
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiLoadingChart = OuiLoadingChart;
OuiLoadingChart.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  size: _propTypes.default.oneOf(["m", "l", "xl"]),
  mono: _propTypes.default.bool
};