'use strict';

var GetIntrinsic = require('get-intrinsic');
var callBound = require('call-bind/callBound');

var $TypeError = GetIntrinsic('%TypeError%');
var $deref = callBound('WeakRef.prototype.deref', true);

var isWeakRef = require('is-weakref');

var AddToKeptObjects = require('./AddToKeptObjects');

// https://ecma-international.org/ecma-262/12.0/#sec-weakrefderef

module.exports = function WeakRefDeref(weakRef) {
	if (!isWeakRef(weakRef)) {
		throw new $TypeError('Assertion failed: `weakRef` must be a WeakRef');
	}
	var target = $deref(weakRef);
	if (target) {
		AddToKeptObjects(target);
	}
	return target;
};
