"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;

var _ppl = require("./ppl");

var _ppl_facet = _interopRequireDefault(require("../services/facets/ppl_facet"));

var _dsl = require("./dsl");

var _dsl_facet = _interopRequireDefault(require("../services/facets/dsl_facet"));

var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));

var _panels_router = require("./custom_panels/panels_router");

var _visualizations_router = require("./custom_panels/visualizations_router");

var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");

var _paraRouter = require("./notebooks/paraRouter");

var _noteRouter = require("./notebooks/noteRouter");

var _vizRouter = require("./notebooks/vizRouter");

var _queryService = _interopRequireDefault(require("../services/queryService"));

var _sqlRouter = require("./notebooks/sqlRouter");

var _event_analytics_router = require("./event_analytics/event_analytics_router");

var _app_analytics_router = require("./application_analytics/app_analytics_router");

var _metrics_rounter = require("./metrics/metrics_rounter");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupRoutes({
  router,
  client
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.default(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.default(client)
  });
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router); // TODO remove trace analytics route when DSL route for autocomplete is added

  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router); // notebooks routes

  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router);
  const queryService = new _queryService.default(client);
  (0, _sqlRouter.registerSqlRoute)(router, queryService);
  (0, _metrics_rounter.registerMetricsRoute)(router);
}

;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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