/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.designer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.ConfigOverlay;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.designer.SchemaDesignerAPI;
import org.apache.solr.handler.designer.SchemaDesignerConstants;
import org.apache.solr.handler.designer.SchemaDesignerSettings;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaDesignerSettingsDAO
implements SchemaDesignerConstants {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer cc;

    SchemaDesignerSettingsDAO(CoreContainer cc) {
        this.cc = cc;
    }

    SchemaDesignerSettings getSettings(String configSet) {
        SolrConfig solrConfig = SolrConfig.readFromResourceLoader(this.zkLoaderForConfigSet(configSet), "solrconfig.xml", true, null);
        return this.getSettings(solrConfig);
    }

    SchemaDesignerSettings getSettings(SolrConfig solrConfig) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isFieldGuessingEnabled = true;
        if (solrConfig != null) {
            Map<String, Object> userProps;
            ConfigOverlay overlay = solrConfig.getOverlay();
            Map<String, Object> map2 = userProps = overlay != null ? overlay.getUserProps() : null;
            if (userProps != null) {
                map.putAll(userProps);
            }
            isFieldGuessingEnabled = this.isFieldGuessingEnabled(solrConfig);
        }
        map.putIfAbsent("update.autoCreateFields", isFieldGuessingEnabled);
        map.putIfAbsent("_designer.languages", Collections.emptyList());
        map.putIfAbsent("_designer.enableDynamicFields", true);
        map.putIfAbsent("_designer.enableNestedDocs", false);
        return new SchemaDesignerSettings(map);
    }

    boolean persistIfChanged(String configSet, SchemaDesignerSettings settings) throws IOException {
        boolean changed = false;
        ConfigOverlay overlay = this.getConfigOverlay(configSet);
        Map<Object, Object> storedUserProps = overlay != null ? overlay.getUserProps() : Collections.emptyMap();
        for (Map.Entry<String, Object> e : settings.toMap().entrySet()) {
            String key = e.getKey();
            Object propValue = e.getValue();
            if (propValue == null || propValue.equals(storedUserProps.get(key))) continue;
            if (overlay == null) {
                overlay = new ConfigOverlay(null, -1);
            }
            overlay = overlay.setUserProperty(key, propValue);
            changed = true;
        }
        if (changed) {
            ZkController.persistConfigResourceToZooKeeper(this.zkLoaderForConfigSet(configSet), overlay.getZnodeVersion(), "configoverlay.json", overlay.toByteArray(), true);
        }
        return changed;
    }

    boolean isDesignerDisabled(String configSet) {
        ConfigOverlay overlay = null;
        try {
            overlay = this.getConfigOverlay(configSet);
        }
        catch (IOException exc) {
            log.error("Failed to get config overlay for {}", (Object)configSet, (Object)exc);
        }
        Map<String, Object> userProps = overlay != null ? overlay.getUserProps() : Collections.emptyMap();
        return SchemaDesignerSettings.getSettingAsBool(userProps, "_designer.disabled", false);
    }

    private ConfigOverlay getConfigOverlay(String config) throws IOException {
        ConfigOverlay overlay = null;
        String path = SchemaDesignerAPI.getConfigSetZkPath(config, "configoverlay.json");
        byte[] data = null;
        Stat stat = new Stat();
        try {
            data = this.cc.getZkController().getZkStateReader().getZkClient().getData(path, null, stat, true);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading path: " + path, SolrZkClient.checkInterrupted((Throwable)e));
        }
        if (data != null && data.length > 0) {
            Map json = (Map)ObjectBuilder.getVal((JSONParser)new JSONParser(new String(data, StandardCharsets.UTF_8)));
            overlay = new ConfigOverlay(json, stat.getVersion());
        }
        return overlay;
    }

    private boolean isFieldGuessingEnabled(SolrConfig solrConfig) {
        if (!this.hasFieldGuessingURPChain(solrConfig)) {
            return false;
        }
        ConfigOverlay overlay = solrConfig.getOverlay();
        return overlay == null || SchemaDesignerSettings.getSettingAsBool(overlay.getUserProps(), "update.autoCreateFields", true);
    }

    private boolean hasFieldGuessingURPChain(SolrConfig solrConfig) {
        boolean hasPlugin = false;
        List<PluginInfo> plugins = solrConfig.getPluginInfos(UpdateRequestProcessorChain.class.getName());
        if (plugins != null) {
            for (PluginInfo next : plugins) {
                if (!"add-unknown-fields-to-the-schema".equals(next.name)) continue;
                hasPlugin = true;
                break;
            }
        }
        return hasPlugin;
    }

    private ZkSolrResourceLoader zkLoaderForConfigSet(String configSet) {
        SolrResourceLoader loader = this.cc.getResourceLoader();
        return new ZkSolrResourceLoader(loader.getInstancePath(), configSet, loader.getClassLoader(), this.cc.getZkController());
    }
}

