/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class IgnoreLargeDocumentProcessorFactory
extends UpdateRequestProcessorFactory {
    public static final String LIMIT_SIZE_PARAM = "limit";
    private long maxDocumentSize = 0x100000L;

    @Override
    public void init(NamedList<?> args) {
        this.maxDocumentSize = args.toSolrParams().required().getLong(LIMIT_SIZE_PARAM);
        args.remove(LIMIT_SIZE_PARAM);
        if (args.size() > 0) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected init param(s): '" + args.getName(0) + "'");
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new UpdateRequestProcessor(next){

            @Override
            public void processAdd(AddUpdateCommand cmd) throws IOException {
                long docSize = ObjectSizeEstimator.estimate(cmd.getSolrInputDocument());
                if (docSize / 1024L > IgnoreLargeDocumentProcessorFactory.this.maxDocumentSize) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Size of the document " + cmd.getPrintableId() + " is too large, around:" + docSize);
                }
                super.processAdd(cmd);
            }
        };
    }

    static class ObjectSizeEstimator {
        private static final Map<Class<?>, Integer> primitiveSizes = new IdentityHashMap();

        ObjectSizeEstimator() {
        }

        static long estimate(SolrInputDocument doc) {
            if (doc == null) {
                return 0L;
            }
            long size = 0L;
            for (SolrInputField inputField : doc.values()) {
                size += ObjectSizeEstimator.primitiveEstimate(inputField.getName(), 0L);
                size += ObjectSizeEstimator.estimate(inputField.getValue());
            }
            if (doc.hasChildDocuments()) {
                for (SolrInputDocument childDoc : doc.getChildDocuments()) {
                    size += ObjectSizeEstimator.estimate(childDoc);
                }
            }
            return size;
        }

        static long estimate(Object obj) {
            if (obj instanceof SolrInputDocument) {
                return ObjectSizeEstimator.estimate((SolrInputDocument)obj);
            }
            if (obj instanceof Map) {
                return ObjectSizeEstimator.estimate((Map)obj);
            }
            if (obj instanceof Collection) {
                return ObjectSizeEstimator.estimate((Collection)obj);
            }
            return ObjectSizeEstimator.primitiveEstimate(obj, 0L);
        }

        private static long primitiveEstimate(Object obj, long def) {
            Class<?> clazz = obj.getClass();
            if (clazz.isPrimitive()) {
                return primitiveSizes.get(clazz).intValue();
            }
            if (obj instanceof String) {
                return (long)((String)obj).length() * 2L;
            }
            return def;
        }

        private static long estimate(Map<?, ?> map) {
            if (map.isEmpty()) {
                return 0L;
            }
            long size = 0L;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                size += ObjectSizeEstimator.primitiveEstimate(entry.getKey(), 0L);
                size += ObjectSizeEstimator.estimate(entry.getValue());
            }
            return size;
        }

        private static long estimate(Collection<?> collection) {
            if (collection.isEmpty()) {
                return 0L;
            }
            long size = 0L;
            for (Object obj : collection) {
                size += ObjectSizeEstimator.estimate(obj);
            }
            return size;
        }

        static {
            primitiveSizes.put(Boolean.TYPE, 1);
            primitiveSizes.put(Boolean.class, 1);
            primitiveSizes.put(Byte.TYPE, 1);
            primitiveSizes.put(Byte.class, 1);
            primitiveSizes.put(Character.TYPE, 2);
            primitiveSizes.put(Character.class, 2);
            primitiveSizes.put(Short.TYPE, 2);
            primitiveSizes.put(Short.class, 2);
            primitiveSizes.put(Integer.TYPE, 4);
            primitiveSizes.put(Integer.class, 4);
            primitiveSizes.put(Float.TYPE, 4);
            primitiveSizes.put(Float.class, 4);
            primitiveSizes.put(Double.TYPE, 8);
            primitiveSizes.put(Double.class, 8);
            primitiveSizes.put(Long.TYPE, 8);
            primitiveSizes.put(Long.class, 8);
        }
    }
}

