/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.AbstractAnalysisFactory;
import org.apache.lucene.analysis.AnalysisSPILoader;
import org.apache.lucene.analysis.TokenStream;

public abstract class TokenFilterFactory
extends AbstractAnalysisFactory {
    private static final AnalysisSPILoader<TokenFilterFactory> loader = new AnalysisSPILoader<TokenFilterFactory>(TokenFilterFactory.class);

    public static TokenFilterFactory forName(String name, Map<String, String> args) {
        return loader.newInstance(name, args);
    }

    public static Class<? extends TokenFilterFactory> lookupClass(String name) {
        return loader.lookupClass(name);
    }

    public static Set<String> availableTokenFilters() {
        return loader.availableServices();
    }

    public static String findSPIName(Class<? extends TokenFilterFactory> serviceClass) {
        try {
            return AnalysisSPILoader.lookupSPIName(serviceClass);
        }
        catch (IllegalAccessException | IllegalStateException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void reloadTokenFilters(ClassLoader classloader) {
        loader.reload(classloader);
    }

    protected TokenFilterFactory() {
    }

    protected TokenFilterFactory(Map<String, String> args) {
        super(args);
    }

    public abstract TokenStream create(TokenStream var1);

    public TokenStream normalize(TokenStream input) {
        return input;
    }
}

