/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetricsQueryTemplate {
    private static final Pattern matchJqTemplate = Pattern.compile("^\\$jq:(?<TEMPLATE>.*?)\\(\\s?(?<UNIQUE>[^,]*),\\s?(?<KEYSELECTOR>[^,]*)(,\\s?(?<METRIC>[^,]*)\\s?)?(,\\s?(?<TYPE>[^,]*)\\s?)?\\)$");
    private final String name;
    private final String defaultType;
    private final String template;

    public static Optional<Matcher> matches(String jsonQuery) {
        String toMatch;
        Matcher m;
        Optional<Matcher> maybe = Optional.empty();
        if (jsonQuery != null && (m = matchJqTemplate.matcher(toMatch = jsonQuery.replaceAll("\\s+", " ").trim())).matches()) {
            maybe = Optional.of(m);
        }
        return maybe;
    }

    public MetricsQueryTemplate(String name, String template, String defaultType) {
        Objects.requireNonNull(name, "jq template must have a name");
        Objects.requireNonNull(template, "jq template is required");
        this.name = name;
        this.template = template.replaceAll("\\s+", " ").trim();
        if (this.template.isEmpty()) {
            throw new IllegalArgumentException("jq template must not be empty");
        }
        this.defaultType = defaultType != null ? defaultType : "GAUGE";
    }

    public String getName() {
        return this.name;
    }

    public String applyTemplate(Matcher matched) {
        Object metric;
        String unique;
        String keySelector = matched.group("KEYSELECTOR");
        if (keySelector == null) {
            keySelector = "";
        }
        unique = (unique = matched.group("UNIQUE")) != null ? unique.trim() : "";
        String type = matched.group("TYPE");
        if (type == null) {
            type = this.defaultType;
        }
        if ((metric = matched.group("METRIC")) == null) {
            metric = unique;
        }
        if (!((String)metric).contains("$")) {
            if ("object.value".equals(metric)) {
                metric = "$object.value";
            } else if (!((String)metric).contains("$object")) {
                metric = Character.isDigit(((String)metric).charAt(0)) ? "$object.value[\"" + (String)metric + "\"]" : "$object.value." + (String)metric;
            }
        }
        return this.template.replace("{UNIQUE}", unique).replace("{KEYSELECTOR}", keySelector.trim()).replace("{METRIC}", ((String)metric).trim()).replace("{TYPE}", type.trim());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsQueryTemplate that = (MetricsQueryTemplate)o;
        return this.name.equals(that.name) && Objects.equals(this.defaultType, that.defaultType) && this.template.equals(that.template);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.defaultType, this.template);
    }
}

