/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRetryRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelloRetryRequestPreparator
extends HandshakeMessagePreparator<HelloRetryRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HelloRetryRequestMessage msg;

    public HelloRetryRequestPreparator(Chooser chooser, HelloRetryRequestMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing HelloRetryRequestMessage");
        this.prepareProtocolVersion();
        this.prepareCipherSuite();
        this.prepareExtensions();
        this.prepareExtensionLength();
    }

    private void prepareProtocolVersion() {
        ProtocolVersion ourVersion = this.chooser.getConfig().getHighestProtocolVersion();
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            this.msg.setProtocolVersion(ourVersion.getValue());
        } else {
            this.msg.setProtocolVersion(ProtocolVersion.TLS13.getValue());
        }
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getProtocolVersion().getValue())));
    }

    private void prepareCipherSuite() {
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            this.msg.setSelectedCipherSuite(this.chooser.getConfig().getDefaultSelectedCipherSuite().getByteValue());
        } else {
            CipherSuite selectedSuite = null;
            for (CipherSuite suite : this.chooser.getConfig().getDefaultServerSupportedCiphersuites()) {
                if (!this.chooser.getClientSupportedCiphersuites().contains((Object)suite)) continue;
                selectedSuite = suite;
                break;
            }
            if (selectedSuite == null) {
                selectedSuite = this.chooser.getConfig().getDefaultSelectedCipherSuite();
                LOGGER.warn("No CipherSuites in common, falling back to defaultSelectedCipherSuite");
            }
            this.msg.setSelectedCipherSuite(selectedSuite.getByteValue());
        }
        LOGGER.debug("SelectedCipherSuite: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getSelectedCipherSuite().getValue())));
    }
}

