/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.traccar.api.BaseResource;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.model.UserRestrictions;
import org.traccar.reports.CsvExportProvider;
import org.traccar.reports.GpxExportProvider;
import org.traccar.reports.KmlExportProvider;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="positions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PositionResource
extends BaseResource {
    @Inject
    private KmlExportProvider kmlExportProvider;
    @Inject
    private CsvExportProvider csvExportProvider;
    @Inject
    private GpxExportProvider gpxExportProvider;

    @GET
    public Collection<Position> getJson(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="id") List<Long> positionIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        if (!positionIds.isEmpty()) {
            ArrayList<Position> positions = new ArrayList<Position>();
            for (long positionId : positionIds) {
                Position position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", positionId)));
                this.permissionsService.checkPermission(Device.class, this.getUserId(), position.getDeviceId());
                positions.add(position);
            }
            return positions;
        }
        if (deviceId > 0L) {
            this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
            if (from != null && to != null) {
                this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
                return PositionUtil.getPositions(this.storage, deviceId, from, to);
            }
            return this.storage.getObjects(Position.class, new Request((Columns)new Columns.All(), new Condition.LatestPositions(deviceId)));
        }
        return PositionUtil.getLatestPositions(this.storage, this.getUserId());
    }

    @Path(value="kml")
    @GET
    @Produces(value={"application/vnd.google-earth.kml+xml"})
    public Response getKml(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        StreamingOutput stream = output -> {
            try {
                this.kmlExportProvider.generate(output, deviceId, from, to);
            }
            catch (StorageException e) {
                throw new WebApplicationException((Throwable)e);
            }
        };
        return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=positions.kml").build();
    }

    @Path(value="csv")
    @GET
    @Produces(value={"text/csv"})
    public Response getCsv(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        StreamingOutput stream = output -> {
            try {
                this.csvExportProvider.generate(output, deviceId, from, to);
            }
            catch (StorageException e) {
                throw new WebApplicationException((Throwable)e);
            }
        };
        return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=positions.csv").build();
    }

    @Path(value="gpx")
    @GET
    @Produces(value={"application/gpx+xml"})
    public Response getGpx(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        StreamingOutput stream = output -> {
            try {
                this.gpxExportProvider.generate(output, deviceId, from, to);
            }
            catch (StorageException e) {
                throw new WebApplicationException((Throwable)e);
            }
        };
        return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=positions.gpx").build();
    }
}

