/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.AndroidNotification;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.MulticastMessage;
import com.google.firebase.messaging.Notification;
import com.google.firebase.messaging.SendResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.MessageException;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;

@Singleton
public class NotificatorFirebase
implements Notificator {
    private final NotificationFormatter notificationFormatter;

    @Inject
    public NotificatorFirebase(Config config, NotificationFormatter notificationFormatter) throws IOException {
        this.notificationFormatter = notificationFormatter;
        ByteArrayInputStream serviceAccount = new ByteArrayInputStream(config.getString(Keys.NOTIFICATOR_FIREBASE_SERVICE_ACCOUNT).getBytes());
        FirebaseOptions options = FirebaseOptions.builder().setCredentials(GoogleCredentials.fromStream((InputStream)serviceAccount)).build();
        FirebaseApp.initializeApp((FirebaseOptions)options);
    }

    @Override
    public void send(User user, Event event, Position position) throws MessageException {
        if (user.hasAttribute("notificationTokens")) {
            NotificationMessage shortMessage = this.notificationFormatter.formatMessage(user, event, position, "short");
            List<String> registrationTokens = Arrays.asList(user.getString("notificationTokens").split("[, ]"));
            MulticastMessage message = MulticastMessage.builder().setNotification(Notification.builder().setTitle(shortMessage.getSubject()).setBody(shortMessage.getBody()).build()).setAndroidConfig(AndroidConfig.builder().setNotification(AndroidNotification.builder().setSound("default").build()).build()).setApnsConfig(ApnsConfig.builder().setAps(Aps.builder().setSound("default").build()).build()).addAllTokens(registrationTokens).putData("eventId", String.valueOf(event.getId())).build();
            try {
                BatchResponse result = FirebaseMessaging.getInstance().sendMulticast(message);
                for (SendResponse response : result.getResponses()) {
                    if (response.isSuccessful()) continue;
                    throw new MessageException(response.getException());
                }
            }
            catch (FirebaseMessagingException e) {
                throw new MessageException(e);
            }
        }
    }
}

