/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.protocol.Jt600ProtocolDecoder;
import org.traccar.session.DeviceSession;

public class HuabaoProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_GENERAL_RESPONSE = 32769;
    public static final int MSG_GENERAL_RESPONSE_2 = 17409;
    public static final int MSG_HEARTBEAT = 2;
    public static final int MSG_HEARTBEAT_2 = 1286;
    public static final int MSG_TERMINAL_REGISTER = 256;
    public static final int MSG_TERMINAL_REGISTER_RESPONSE = 33024;
    public static final int MSG_TERMINAL_CONTROL = 33029;
    public static final int MSG_TERMINAL_AUTH = 258;
    public static final int MSG_LOCATION_REPORT = 512;
    public static final int MSG_LOCATION_BATCH_2 = 528;
    public static final int MSG_ACCELERATION = 8304;
    public static final int MSG_LOCATION_REPORT_2 = 21761;
    public static final int MSG_LOCATION_REPORT_BLIND = 21762;
    public static final int MSG_LOCATION_BATCH = 1796;
    public static final int MSG_OIL_CONTROL = 40966;
    public static final int MSG_TIME_SYNC_REQUEST = 265;
    public static final int MSG_TIME_SYNC_RESPONSE = 33033;
    public static final int MSG_PHOTO = 34952;
    public static final int MSG_TRANSPARENT = 2304;
    public static final int RESULT_SUCCESS = 0;

    public HuabaoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public static ByteBuf formatMessage(int type, ByteBuf id, boolean shortIndex, ByteBuf data) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(126);
        buf.writeShort(type);
        buf.writeShort(data.readableBytes());
        buf.writeBytes(id);
        if (shortIndex) {
            buf.writeByte(1);
        } else {
            buf.writeShort(0);
        }
        buf.writeBytes(data);
        data.release();
        buf.writeByte(Checksum.xor(buf.nioBuffer(1, buf.readableBytes() - 1)));
        buf.writeByte(126);
        return buf;
    }

    private void sendGeneralResponse(Channel channel, SocketAddress remoteAddress, ByteBuf id, int type, int index) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(index);
            response.writeShort(type);
            response.writeByte(0);
            channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(32769, id, false, response), remoteAddress));
        }
    }

    private void sendGeneralResponse2(Channel channel, SocketAddress remoteAddress, ByteBuf id, int type) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(type);
            response.writeByte(0);
            channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(17409, id, true, response), remoteAddress));
        }
    }

    private String decodeAlarm(long value) {
        if (BitUtil.check(value, 0)) {
            return "sos";
        }
        if (BitUtil.check(value, 1)) {
            return "overspeed";
        }
        if (BitUtil.check(value, 5)) {
            return "gpsAntennaCut";
        }
        if (BitUtil.check(value, 4) || BitUtil.check(value, 9) || BitUtil.check(value, 10) || BitUtil.check(value, 11)) {
            return "fault";
        }
        if (BitUtil.check(value, 7) || BitUtil.check(value, 18)) {
            return "lowBattery";
        }
        if (BitUtil.check(value, 8)) {
            return "powerOff";
        }
        if (BitUtil.check(value, 17)) {
            return "tampering";
        }
        if (BitUtil.check(value, 20)) {
            return "geofence";
        }
        if (BitUtil.check(value, 28)) {
            return "movement";
        }
        if (BitUtil.check(value, 29)) {
            return "accident";
        }
        return null;
    }

    private int readSignedWord(ByteBuf buf) {
        int value = buf.readUnsignedShort();
        return BitUtil.check(value, 15) ? -BitUtil.to(value, 15) : BitUtil.to(value, 15);
    }

    private Date readDate(ByteBuf buf, TimeZone timeZone) {
        DateBuilder dateBuilder = new DateBuilder(timeZone).setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
        return dateBuilder.getDate();
    }

    private String decodeId(ByteBuf id) {
        String serial = ByteBufUtil.hexDump((ByteBuf)id);
        if (serial.matches("[0-9]+")) {
            return serial;
        }
        long imei = id.getUnsignedShort(0);
        imei = (imei << 32) + id.getUnsignedInt(2);
        return String.valueOf(imei);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex()) == 40) {
            String sentence = buf.toString(StandardCharsets.US_ASCII);
            if (sentence.contains("BASE,2")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                String response = sentence.replace("TIME", dateFormat.format(new Date()));
                if (channel != null) {
                    channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)response, (Charset)StandardCharsets.US_ASCII), remoteAddress));
                }
                return null;
            }
            return this.decodeResult(channel, remoteAddress, sentence);
        }
        buf.readUnsignedByte();
        int type = buf.readUnsignedShort();
        int attribute = buf.readUnsignedShort();
        ByteBuf id = buf.readSlice(6);
        int index = type == 21761 || type == 21762 ? buf.readUnsignedByte() : buf.readUnsignedShort();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.decodeId(id));
        if (deviceSession == null) {
            return null;
        }
        if (!deviceSession.contains("timezone")) {
            deviceSession.set("timezone", this.getTimeZone(deviceSession.getDeviceId(), "GMT+8"));
        }
        if (type == 256) {
            if (channel != null) {
                ByteBuf response = Unpooled.buffer();
                response.writeShort(index);
                response.writeByte(0);
                response.writeBytes(this.decodeId(id).getBytes(StandardCharsets.US_ASCII));
                channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(33024, id, false, response), remoteAddress));
            }
        } else if (type == 258 || type == 2 || type == 1286 || type == 34952) {
            this.sendGeneralResponse(channel, remoteAddress, id, type, index);
        } else {
            if (type == 512) {
                this.sendGeneralResponse(channel, remoteAddress, id, type, index);
                return this.decodeLocation(deviceSession, buf);
            }
            if (type == 21761 || type == 21762) {
                if (BitUtil.check(attribute, 15)) {
                    this.sendGeneralResponse2(channel, remoteAddress, id, type);
                }
                return this.decodeLocation2(deviceSession, buf, type);
            }
            if (type == 1796 || type == 528) {
                this.sendGeneralResponse(channel, remoteAddress, id, type, index);
                return this.decodeLocationBatch(deviceSession, buf, type);
            }
            if (type == 265) {
                if (channel != null) {
                    Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    ByteBuf response = Unpooled.buffer();
                    response.writeShort(calendar.get(1));
                    response.writeByte(calendar.get(2) + 1);
                    response.writeByte(calendar.get(5));
                    response.writeByte(calendar.get(11));
                    response.writeByte(calendar.get(12));
                    response.writeByte(calendar.get(13));
                    channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(33024, id, false, response), remoteAddress));
                }
            } else {
                if (type == 8304) {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    this.getLastLocation(position, null);
                    StringBuilder data = new StringBuilder("[");
                    while (buf.readableBytes() > 2) {
                        buf.skipBytes(6);
                        if (data.length() > 1) {
                            data.append(",");
                        }
                        data.append("[");
                        data.append(this.readSignedWord(buf));
                        data.append(",");
                        data.append(this.readSignedWord(buf));
                        data.append(",");
                        data.append(this.readSignedWord(buf));
                        data.append("]");
                    }
                    data.append("]");
                    position.set("gSensor", data.toString());
                    return position;
                }
                if (type == 2304) {
                    return this.decodeTransparent(deviceSession, buf);
                }
            }
        }
        return null;
    }

    private Position decodeResult(Channel channel, SocketAddress remoteAddress, String sentence) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession != null) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            position.set("result", sentence);
            return position;
        }
        return null;
    }

    private void decodeExtension(Position position, ByteBuf buf, int endIndex) {
        block21: while (buf.readerIndex() < endIndex) {
            short type = buf.readUnsignedByte();
            short length = buf.readUnsignedByte();
            switch (type) {
                case 1: {
                    position.set("odometer", buf.readUnsignedInt() * 100L);
                    continue block21;
                }
                case 2: {
                    position.set("fuel", (double)buf.readUnsignedShort() * 0.1);
                    continue block21;
                }
                case 3: {
                    position.set("obdSpeed", (double)buf.readUnsignedShort() * 0.1);
                    continue block21;
                }
                case 128: {
                    position.set("obdSpeed", buf.readUnsignedByte());
                    continue block21;
                }
                case 129: {
                    position.set("rpm", buf.readUnsignedShort());
                    continue block21;
                }
                case 130: {
                    position.set("power", (double)buf.readUnsignedShort() * 0.1);
                    continue block21;
                }
                case 131: {
                    position.set("engineLoad", buf.readUnsignedByte());
                    continue block21;
                }
                case 132: {
                    position.set("coolantTemp", buf.readUnsignedByte() - 40);
                    continue block21;
                }
                case 133: {
                    position.set("fuelConsumption", buf.readUnsignedShort());
                    continue block21;
                }
                case 134: {
                    position.set("intakeTemp", buf.readUnsignedByte() - 40);
                    continue block21;
                }
                case 135: {
                    position.set("intakeFlow", buf.readUnsignedShort());
                    continue block21;
                }
                case 136: {
                    position.set("intakePressure", buf.readUnsignedByte());
                    continue block21;
                }
                case 137: {
                    position.set("throttle", buf.readUnsignedByte());
                    continue block21;
                }
                case 139: {
                    position.set("vin", buf.readCharSequence(17, StandardCharsets.US_ASCII).toString());
                    continue block21;
                }
                case 140: {
                    position.set("obdOdometer", buf.readUnsignedInt() * 100L);
                    continue block21;
                }
                case 141: {
                    position.set("tripOdometer", (long)buf.readUnsignedShort() * 1000L);
                    continue block21;
                }
                case 142: {
                    position.set("fuel", buf.readUnsignedByte());
                    continue block21;
                }
                case 160: {
                    String codes = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString();
                    position.set("dtcs", codes.replace(',', ' '));
                    continue block21;
                }
                case 204: {
                    position.set("iccid", buf.readCharSequence(20, StandardCharsets.US_ASCII).toString());
                    continue block21;
                }
            }
            buf.skipBytes((int)length);
        }
    }

    private void decodeCoordinates(Position position, ByteBuf buf) {
        int status = buf.readInt();
        position.set("ignition", BitUtil.check(status, 0));
        position.set("blocked", BitUtil.check(status, 10));
        position.set("charge", BitUtil.check(status, 26));
        position.setValid(BitUtil.check(status, 1));
        double lat = (double)buf.readUnsignedInt() * 1.0E-6;
        double lon = (double)buf.readUnsignedInt() * 1.0E-6;
        if (BitUtil.check(status, 2)) {
            position.setLatitude(-lat);
        } else {
            position.setLatitude(lat);
        }
        if (BitUtil.check(status, 3)) {
            position.setLongitude(-lon);
        } else {
            position.setLongitude(lon);
        }
    }

    private double decodeCustomDouble(ByteBuf buf) {
        byte b1 = buf.readByte();
        short b2 = buf.readUnsignedByte();
        int sign = b1 != 0 ? b1 / Math.abs(b1) : 1;
        return (double)sign * ((double)Math.abs(b1) + (double)b2 / 255.0);
    }

    private Position decodeLocation(DeviceSession deviceSession, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("alarm", this.decodeAlarm(buf.readUnsignedInt()));
        this.decodeCoordinates(position, buf);
        position.setAltitude(buf.readShort());
        position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() * 0.1));
        position.setCourse(buf.readUnsignedShort());
        position.setTime(this.readDate(buf, (TimeZone)deviceSession.get("timezone")));
        if (buf.readableBytes() == 20) {
            buf.skipBytes(4);
            position.set("odometer", buf.readUnsignedInt() * 1000L);
            position.set("battery", (double)buf.readUnsignedShort() * 0.1);
            buf.readUnsignedInt();
            position.set("rssi", buf.readUnsignedByte());
            buf.skipBytes(3);
            return position;
        }
        while (buf.readableBytes() > 2) {
            short subtype = buf.readUnsignedByte();
            short length = buf.readUnsignedByte();
            int endIndex = buf.readerIndex() + length;
            switch (subtype) {
                case 1: {
                    position.set("odometer", buf.readUnsignedInt() * 100L);
                    break;
                }
                case 2: {
                    position.set("fuel", (double)buf.readUnsignedShort() * 0.1);
                    break;
                }
                case 43: {
                    position.set("fuelConsumption", buf.readUnsignedInt());
                    break;
                }
                case 48: {
                    position.set("rssi", buf.readUnsignedByte());
                    break;
                }
                case 49: {
                    position.set("sat", buf.readUnsignedByte());
                    break;
                }
                case 51: {
                    String sentence = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString();
                    if (!sentence.startsWith("*M00")) break;
                    String lockStatus = sentence.substring(8, 15);
                    position.set("battery", (double)Integer.parseInt(lockStatus.substring(2, 5)) * 0.01);
                    break;
                }
                case 128: {
                    buf.readUnsignedByte();
                    endIndex = buf.writerIndex() - 2;
                    this.decodeExtension(position, buf, endIndex);
                    break;
                }
                case 145: {
                    position.set("battery", (double)buf.readUnsignedShort() * 0.1);
                    position.set("rpm", buf.readUnsignedShort());
                    position.set("obdSpeed", buf.readUnsignedByte());
                    position.set("throttle", buf.readUnsignedByte() * 100 / 255);
                    position.set("engineLoad", buf.readUnsignedByte() * 100 / 255);
                    position.set("coolantTemp", buf.readUnsignedByte() - 40);
                    buf.readUnsignedShort();
                    position.set("fuelConsumption", (double)buf.readUnsignedShort() * 0.01);
                    buf.readUnsignedShort();
                    buf.readUnsignedInt();
                    buf.readUnsignedShort();
                    position.set("fuelUsed", (double)buf.readUnsignedShort() * 0.01);
                    break;
                }
                case 148: {
                    if (length <= 0) break;
                    position.set("vin", buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString());
                    break;
                }
                case 167: {
                    position.set("adc1", buf.readUnsignedShort());
                    position.set("adc2", buf.readUnsignedShort());
                    break;
                }
                case 172: {
                    position.set("odometer", buf.readUnsignedInt());
                    break;
                }
                case 208: {
                    long userStatus = buf.readUnsignedInt();
                    if (!BitUtil.check(userStatus, 3)) break;
                    position.set("alarm", "vibration");
                    break;
                }
                case 211: {
                    position.set("power", (double)buf.readUnsignedShort() * 0.1);
                    break;
                }
                case 212: {
                    position.set("batteryLevel", buf.readUnsignedByte());
                    break;
                }
                case 213: {
                    if (length == 2) {
                        position.set("battery", (double)buf.readUnsignedShort() * 0.01);
                        break;
                    }
                    int count = buf.readUnsignedByte();
                    for (int i = 1; i <= count; ++i) {
                        position.set("lock" + i + "Id", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(5)));
                        position.set("lock" + i + "Card", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(5)));
                        position.set("lock" + i + "Battery", buf.readUnsignedByte());
                        int status = buf.readUnsignedShort();
                        position.set("lock" + i + "Locked", !BitUtil.check(status, 5));
                    }
                    break;
                }
                case 218: {
                    buf.readUnsignedShort();
                    short deviceStatus = buf.readUnsignedByte();
                    position.set("string", BitUtil.check(deviceStatus, 0));
                    position.set("motion", BitUtil.check(deviceStatus, 2));
                    position.set("cover", BitUtil.check(deviceStatus, 3));
                    break;
                }
                case 230: {
                    while (buf.readerIndex() < endIndex) {
                        short sensorIndex = buf.readUnsignedByte();
                        buf.skipBytes(6);
                        position.set("temp" + sensorIndex, this.decodeCustomDouble(buf));
                        position.set("humidity" + sensorIndex, this.decodeCustomDouble(buf));
                    }
                    break;
                }
                case 235: {
                    int extendedType;
                    if (buf.getUnsignedShort(buf.readerIndex()) > 200) {
                        Network network = new Network();
                        int mcc = buf.readUnsignedShort();
                        short mnc = buf.readUnsignedByte();
                        while (buf.readerIndex() < endIndex) {
                            network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedByte()));
                        }
                        position.setNetwork(network);
                        break;
                    }
                    block57: while (buf.readerIndex() < endIndex) {
                        int extendedLength = buf.readUnsignedShort();
                        extendedType = buf.readUnsignedShort();
                        switch (extendedType) {
                            case 1: {
                                position.set("fuel1", (double)buf.readUnsignedShort() * 0.1);
                                buf.readUnsignedByte();
                                continue block57;
                            }
                            case 35: {
                                position.set("fuel2", Double.parseDouble(buf.readCharSequence(6, StandardCharsets.US_ASCII).toString()));
                                continue block57;
                            }
                            case 206: {
                                position.set("power", (double)buf.readUnsignedShort() * 0.01);
                                continue block57;
                            }
                            case 216: {
                                Network network = new Network();
                                network.addCellTower(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedByte(), buf.readUnsignedShort(), buf.readUnsignedInt()));
                                position.setNetwork(network);
                                continue block57;
                            }
                            case 225: {
                                position.set("batteryLevel", buf.readUnsignedByte());
                                continue block57;
                            }
                        }
                        buf.skipBytes(extendedLength - 2);
                    }
                    break;
                }
                case 237: {
                    String license = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString().trim();
                    position.set("driverLicense", license);
                    break;
                }
                case 238: {
                    position.set("rssi", buf.readUnsignedByte());
                    position.set("power", (double)buf.readUnsignedShort() * 0.001);
                    position.set("battery", (double)buf.readUnsignedShort() * 0.001);
                    position.set("sat", buf.readUnsignedByte());
                    break;
                }
                case 243: {
                    int extendedType;
                    block58: while (buf.readerIndex() < endIndex) {
                        extendedType = buf.readUnsignedShort();
                        short extendedLength = buf.readUnsignedByte();
                        switch (extendedType) {
                            case 2: {
                                position.set("obdSpeed", (double)buf.readUnsignedShort() * 0.1);
                                continue block58;
                            }
                            case 3: {
                                position.set("rpm", buf.readUnsignedShort());
                                continue block58;
                            }
                            case 4: {
                                position.set("power", (double)buf.readUnsignedShort() * 0.001);
                                continue block58;
                            }
                            case 5: {
                                position.set("obdOdometer", buf.readUnsignedInt() * 100L);
                                continue block58;
                            }
                            case 7: {
                                position.set("fuelConsumption", (double)buf.readUnsignedShort() * 0.1);
                                continue block58;
                            }
                            case 8: {
                                position.set("engineLoad", (double)buf.readUnsignedShort() * 0.1);
                                continue block58;
                            }
                            case 9: {
                                position.set("coolantTemp", buf.readUnsignedShort() - 40);
                                continue block58;
                            }
                            case 11: {
                                position.set("intakePressure", buf.readUnsignedShort());
                                continue block58;
                            }
                            case 12: {
                                position.set("intakeTemp", buf.readUnsignedShort() - 40);
                                continue block58;
                            }
                            case 13: {
                                position.set("intakeFlow", buf.readUnsignedShort());
                                continue block58;
                            }
                            case 14: {
                                position.set("throttle", buf.readUnsignedShort() * 100 / 255);
                                continue block58;
                            }
                            case 80: {
                                position.set("vin", buf.readSlice(17).toString(StandardCharsets.US_ASCII));
                                continue block58;
                            }
                            case 256: {
                                position.set("tripOdometer", (double)buf.readUnsignedShort() * 0.1);
                                continue block58;
                            }
                            case 258: {
                                position.set("tripFuel", (double)buf.readUnsignedShort() * 0.1);
                                continue block58;
                            }
                            case 274: {
                                position.set("hardAccelerationCount", buf.readUnsignedShort());
                                continue block58;
                            }
                            case 275: {
                                position.set("hardDecelerationCount", buf.readUnsignedShort());
                                continue block58;
                            }
                            case 276: {
                                position.set("hardCorneringCount", buf.readUnsignedShort());
                                continue block58;
                            }
                        }
                        buf.skipBytes((int)extendedLength);
                    }
                    break;
                }
                case 254: {
                    if (length == 1) {
                        position.set("batteryLevel", buf.readUnsignedByte());
                        break;
                    }
                    short mark = buf.readUnsignedByte();
                    if (mark == 124) {
                        block59: while (buf.readerIndex() < endIndex) {
                            short extendedType = buf.readUnsignedByte();
                            short extendedLength = buf.readUnsignedByte();
                            switch (extendedType) {
                                case 1: {
                                    long alarms = buf.readUnsignedInt();
                                    if (BitUtil.check(alarms, 0)) {
                                        position.set("alarm", "hardAcceleration");
                                    }
                                    if (BitUtil.check(alarms, 1)) {
                                        position.set("alarm", "hardBraking");
                                    }
                                    if (BitUtil.check(alarms, 2)) {
                                        position.set("alarm", "hardCornering");
                                    }
                                    if (BitUtil.check(alarms, 3)) {
                                        position.set("alarm", "accident");
                                    }
                                    if (!BitUtil.check(alarms, 4)) continue block59;
                                    position.set("alarm", "tampering");
                                    continue block59;
                                }
                            }
                            buf.skipBytes((int)extendedLength);
                        }
                    }
                    position.set("batteryLevel", buf.readUnsignedByte());
                    break;
                }
            }
            buf.readerIndex(endIndex);
        }
        return position;
    }

    private Position decodeLocation2(DeviceSession deviceSession, ByteBuf buf, int type) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        Jt600ProtocolDecoder.decodeBinaryLocation(buf, position);
        position.setValid(type != 21762);
        position.set("rssi", buf.readUnsignedByte());
        position.set("sat", buf.readUnsignedByte());
        position.set("odometer", buf.readUnsignedInt() * 1000L);
        short battery = buf.readUnsignedByte();
        if (battery <= 100) {
            position.set("batteryLevel", Integer.valueOf(battery));
        } else if (battery == 170) {
            position.set("charge", true);
        }
        position.setNetwork(new Network(CellTower.fromCidLac(this.getConfig(), buf.readUnsignedInt(), buf.readUnsignedShort())));
        short product = buf.readUnsignedByte();
        int status = buf.readUnsignedShort();
        int alarm = buf.readUnsignedShort();
        if (product == 1 || product == 2) {
            if (BitUtil.check(alarm, 0)) {
                position.set("alarm", "lowPower");
            }
        } else if (product == 3) {
            position.set("blocked", BitUtil.check(status, 5));
            if (BitUtil.check(alarm, 1)) {
                position.set("alarm", "lowPower");
            }
            if (BitUtil.check(alarm, 2)) {
                position.set("alarm", "vibration");
            }
            if (BitUtil.check(alarm, 3)) {
                position.set("alarm", "lowBattery");
            }
        }
        position.set("status", status);
        return position;
    }

    private List<Position> decodeLocationBatch(DeviceSession deviceSession, ByteBuf buf, int type) {
        LinkedList<Position> positions = new LinkedList<Position>();
        short locationType = 0;
        if (type == 1796) {
            buf.readUnsignedShort();
            locationType = buf.readUnsignedByte();
        }
        while (buf.readableBytes() > 2) {
            int length = type == 528 ? buf.readUnsignedByte() : buf.readUnsignedShort();
            ByteBuf fragment = buf.readSlice(length);
            Position position = this.decodeLocation(deviceSession, fragment);
            if (locationType > 0) {
                position.set("archive", true);
            }
            positions.add(position);
        }
        return positions;
    }

    private Position decodeTransparent(DeviceSession deviceSession, ByteBuf buf) {
        short type = buf.readUnsignedByte();
        if (type == 240) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            Date time = this.readDate(buf, (TimeZone)deviceSession.get("timezone"));
            if (buf.readUnsignedByte() > 0) {
                position.set("archive", true);
            }
            buf.readUnsignedByte();
            short subtype = buf.readUnsignedByte();
            switch (subtype) {
                case 1: {
                    int count = buf.readUnsignedByte();
                    block24: for (int i = 0; i < count; ++i) {
                        int id = buf.readUnsignedShort();
                        short length = buf.readUnsignedByte();
                        switch (id) {
                            case 258: 
                            case 1320: 
                            case 1350: {
                                position.set("odometer", buf.readUnsignedInt() * 100L);
                                continue block24;
                            }
                            case 259: {
                                position.set("fuel", (double)buf.readUnsignedInt() * 0.01);
                                continue block24;
                            }
                            case 1322: {
                                position.set("fuel", (double)buf.readUnsignedShort() * 0.01);
                                continue block24;
                            }
                            case 261: 
                            case 1324: {
                                position.set("fuelUsed", (double)buf.readUnsignedInt() * 0.01);
                                continue block24;
                            }
                            case 330: 
                            case 1335: 
                            case 1336: 
                            case 1337: {
                                position.set("fuelConsumption", (double)buf.readUnsignedShort() * 0.01);
                                continue block24;
                            }
                            default: {
                                switch (length) {
                                    case 1: {
                                        position.set("io" + id, buf.readUnsignedByte());
                                        continue block24;
                                    }
                                    case 2: {
                                        position.set("io" + id, buf.readUnsignedShort());
                                        continue block24;
                                    }
                                    case 4: {
                                        position.set("io" + id, buf.readUnsignedInt());
                                        continue block24;
                                    }
                                }
                                buf.skipBytes((int)length);
                            }
                        }
                    }
                    this.decodeCoordinates(position, buf);
                    position.setTime(time);
                    break;
                }
                case 3: {
                    int count = buf.readUnsignedByte();
                    for (int i = 0; i < count; ++i) {
                        int id = buf.readUnsignedShort();
                        short length = buf.readUnsignedByte();
                        switch (id) {
                            case 26: {
                                position.set("alarm", "hardAcceleration");
                                break;
                            }
                            case 27: {
                                position.set("alarm", "hardBraking");
                                break;
                            }
                            case 28: {
                                position.set("alarm", "hardCornering");
                                break;
                            }
                            case 29: 
                            case 30: 
                            case 31: {
                                position.set("alarm", "laneChange");
                                break;
                            }
                            case 35: {
                                position.set("alarm", "fatigueDriving");
                                break;
                            }
                        }
                        buf.skipBytes((int)length);
                    }
                    this.decodeCoordinates(position, buf);
                    position.setTime(time);
                    break;
                }
                case 11: {
                    if (buf.readUnsignedByte() > 0) {
                        position.set("vin", buf.readCharSequence(17, StandardCharsets.US_ASCII).toString());
                    }
                    this.getLastLocation(position, time);
                    break;
                }
                default: {
                    return null;
                }
            }
            return position;
        }
        return null;
    }
}

