/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import liquibase.Beta;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandResultDefinition;
import liquibase.command.CommonArgumentNames;
import liquibase.command.core.DbUrlConnectionCommandStep;
import liquibase.database.Database;

public class CommandBuilder {
    private final String[][] commandNames;

    public CommandBuilder(String[] ... commandNames) {
        this.commandNames = commandNames;
    }

    public <DataType> CommandArgumentDefinition.Building<DataType> argument(String name, Class<DataType> type) {
        return new CommandArgumentDefinition.Building<DataType>(this.commandNames, new CommandArgumentDefinition<DataType>(name, type));
    }

    public <DataType> CommandArgumentDefinition.Building<DataType> argument(CommonArgumentNames argument, Class<DataType> type) {
        return new CommandArgumentDefinition.Building<DataType>(this.commandNames, new CommandArgumentDefinition<DataType>(argument.getArgumentName(), type));
    }

    @Beta
    public CommandArgumentDefinition.Building<Database> databaseArgument() {
        DbUrlConnectionCommandStep.addApplicableCommand(this.commandNames);
        return new CommandArgumentDefinition.Building<Database>(this.commandNames, new CommandArgumentDefinition<Database>("database", Database.class)).description("Database connection");
    }

    public <DataType> CommandResultDefinition.Building<DataType> result(String name, Class<DataType> type) {
        return new CommandResultDefinition.Building<DataType>(new CommandResultDefinition<DataType>(name, type));
    }
}

