/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.gradle.api.Describable;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.util.GFileUtils;

public class PatternSetSnapshottingFilter
implements SnapshottingFilter {
    private final PatternSet patternSet;
    private final Stat stat;

    public PatternSetSnapshottingFilter(PatternSet patternSet, Stat stat) {
        this.stat = stat;
        this.patternSet = patternSet;
    }

    public boolean isEmpty() {
        return this.patternSet.isEmpty();
    }

    public SnapshottingFilter.FileSystemSnapshotPredicate getAsSnapshotPredicate() {
        Spec spec = this.patternSet.getAsSpec();
        return (snapshot, relativePath) -> spec.isSatisfiedBy((Object)new LogicalFileTreeElement(snapshot, relativePath, this.stat));
    }

    public SnapshottingFilter.DirectoryWalkerPredicate getAsDirectoryWalkerPredicate() {
        Spec spec = this.patternSet.getAsSpec();
        return (path, name, isDirectory, relativePath) -> spec.isSatisfiedBy((Object)new PathBackedFileTreeElement(path, name, isDirectory, relativePath, this.stat));
    }

    private static class PathBackedFileTreeElement
    implements FileTreeElement {
        private final Path path;
        private final String name;
        private final boolean isDirectory;
        private final Iterable<String> relativePath;
        private final Stat stat;

        public PathBackedFileTreeElement(Path path, String name, boolean isDirectory, Iterable<String> relativePath, Stat stat) {
            this.path = path;
            this.name = name;
            this.isDirectory = isDirectory;
            this.relativePath = relativePath;
            this.stat = stat;
        }

        public File getFile() {
            return this.path.toFile();
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public long getLastModified() {
            return this.getFile().lastModified();
        }

        public long getSize() {
            return this.getFile().length();
        }

        public InputStream open() {
            try {
                return Files.newInputStream(this.path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        public void copyTo(OutputStream output) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        public boolean copyTo(File target) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.getRelativePath().getPathString();
        }

        public RelativePath getRelativePath() {
            String[] segments = new String[Iterables.size(this.relativePath) + 1];
            int i = 0;
            Iterator<String> iterator = this.relativePath.iterator();
            while (iterator.hasNext()) {
                String segment;
                segments[i] = segment = iterator.next();
                ++i;
            }
            segments[i] = this.name;
            return new RelativePath(!this.isDirectory, segments);
        }

        public int getMode() {
            return this.stat.getUnixMode(this.path.toFile());
        }
    }

    private static class LogicalFileTreeElement
    implements FileTreeElement,
    Describable {
        private final Iterable<String> relativePathIterable;
        private final Stat stat;
        private final CompleteFileSystemLocationSnapshot snapshot;
        private RelativePath relativePath;
        private File file;

        public LogicalFileTreeElement(CompleteFileSystemLocationSnapshot snapshot, Iterable<String> relativePathIterable, Stat stat) {
            this.snapshot = snapshot;
            this.relativePathIterable = relativePathIterable;
            this.stat = stat;
        }

        public String getDisplayName() {
            return "file '" + this.getFile() + "'";
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.snapshot.getAbsolutePath());
            }
            return this.file;
        }

        public boolean isDirectory() {
            return this.snapshot.getType() == FileType.Directory;
        }

        public long getLastModified() {
            return this.getFile().lastModified();
        }

        public long getSize() {
            return this.getFile().length();
        }

        public InputStream open() {
            return GFileUtils.openInputStream((File)this.getFile());
        }

        public void copyTo(OutputStream output) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        public boolean copyTo(File target) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        public String getName() {
            return this.getRelativePath().getLastName();
        }

        public String getPath() {
            return this.getRelativePath().getPathString();
        }

        public RelativePath getRelativePath() {
            if (this.relativePath == null) {
                this.relativePath = new RelativePath(!this.isDirectory(), (String[])Iterables.toArray(this.relativePathIterable, String.class));
            }
            return this.relativePath;
        }

        public int getMode() {
            return this.stat.getUnixMode(this.getFile());
        }
    }
}

