/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc;

import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.JavadocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class ValueDocTagInfo
implements JavadocTagInfo {
    @Override
    public String getName() {
        return "value";
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        return true;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value2) {
        PsiElement target;
        PsiReference reference;
        boolean hasReference;
        boolean bl = hasReference = value2 != null && value2.getFirstChild() != null;
        if (hasReference && !PsiUtil.isLanguageLevel5OrHigher(value2)) {
            return JavaErrorMessages.message("javadoc.value.tag.jdk15.required", new Object[0]);
        }
        if (value2 != null && (reference = value2.getReference()) != null && (target = reference.resolve()) != null) {
            if (!(target instanceof PsiField)) {
                return JavaErrorMessages.message("javadoc.value.field.required", new Object[0]);
            }
            PsiField field = (PsiField)target;
            if (!field.hasModifierProperty("static")) {
                return JavaErrorMessages.message("javadoc.value.static.field.required", new Object[0]);
            }
            if (field.getInitializer() == null || JavaConstantExpressionEvaluator.computeConstantExpression(field.getInitializer(), false) == null) {
                return JavaErrorMessages.message("javadoc.value.field.with.initializer.required", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public PsiReference getReference(PsiDocTagValue value2) {
        return null;
    }
}

