/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.crypto.EncType;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.networkdb.kademlia.SearchJob;

class ExploreJob
extends SearchJob {
    private final FloodfillPeerSelector _peerSelector;
    private final boolean _isRealExplore;
    private static final long MAX_EXPLORE_TIME = 30000L;
    private static final int EXPLORE_BREDTH = 1;
    static final int MAX_CLOSEST = 20;
    static final int PER_FLOODFILL_PEER_TIMEOUT = 5000;

    public ExploreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, boolean isRealExplore) {
        super(context, facade, key, null, null, 30000L, false, false);
        this._peerSelector = (FloodfillPeerSelector)this._facade.getPeerSelector();
        this._isRealExplore = isRealExplore;
    }

    @Override
    protected I2NPMessage buildMessage(TunnelId replyTunnelId, Hash replyGateway, long expiration, RouterInfo peer) {
        FastI2NPMessageImpl outMsg;
        RouterContext ctx = this.getContext();
        DatabaseLookupMessage msg = new DatabaseLookupMessage(ctx, true);
        msg.setSearchKey(this.getState().getTarget());
        msg.setFrom(replyGateway);
        Set<Hash> dontIncludePeers = this.getState().getClosestAttempted(20);
        msg.setMessageExpiration(expiration);
        if (replyTunnelId != null) {
            msg.setReplyTunnel(replyTunnelId);
        }
        int available = 20 - dontIncludePeers.size();
        if (this._isRealExplore) {
            msg.setSearchType(DatabaseLookupMessage.Type.EXPL);
        } else {
            msg.setSearchType(DatabaseLookupMessage.Type.RI);
        }
        KBucketSet<Hash> ks = this._facade.getKBuckets();
        Hash rkey = ctx.routingKeyGenerator().getRoutingKey(this.getState().getTarget());
        if (available > 0) {
            HashSet<Hash> dontInclude = new HashSet<Hash>(dontIncludePeers);
            List<Hash> peers = this._peerSelector.selectNearestExplicit(rkey, available, dontInclude, ks);
            dontIncludePeers.addAll(peers);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Peers we don't want to hear about: " + dontIncludePeers);
        }
        msg.setDontIncludePeers(dontIncludePeers);
        RouterIdentity ident = peer.getIdentity();
        EncType type = ident.getPublicKey().getType();
        boolean encryptElG = ctx.getProperty("router.encryptRouterLookups", IterativeSearchJob.DEFAULT_ENCRYPT_RI);
        if (replyTunnelId != null && (encryptElG && type == EncType.ELGAMAL_2048 || type == EncType.ECIES_X25519)) {
            EncType ourType = ctx.keyManager().getPublicKey().getType();
            boolean ratchet1 = ourType.equals((Object)EncType.ECIES_X25519);
            boolean ratchet2 = DatabaseLookupMessage.supportsRatchetReplies(peer);
            if (DatabaseLookupMessage.supportsEncryptedReplies(peer) && (ratchet2 || !ratchet1)) {
                boolean supportsRatchet = ratchet1 && ratchet2;
                MessageWrapper.OneTimeSession sess = MessageWrapper.generateSession(ctx, ctx.sessionKeyManager(), 30000L, !supportsRatchet);
                if (sess != null) {
                    if (sess.tag != null) {
                        if (this._log.shouldInfo()) {
                            this._log.info(this.getJobId() + ": Requesting AES reply from " + ident.calculateHash() + " with: " + sess.key + ' ' + sess.tag);
                        }
                        msg.setReplySession(sess.key, sess.tag);
                    } else {
                        if (this._log.shouldInfo()) {
                            this._log.info(this.getJobId() + ": Requesting AEAD reply from " + ident.calculateHash() + " with: " + sess.key + ' ' + sess.rtag);
                        }
                        msg.setReplySession(sess.key, sess.rtag);
                    }
                } else if (this._log.shouldWarn()) {
                    this._log.warn(this.getJobId() + ": Failed encrypt to " + peer);
                }
            }
            outMsg = MessageWrapper.wrap(ctx, (I2NPMessage)msg, peer);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Encrypted exploratory DLM for " + this.getState().getTarget() + " to " + ident.calculateHash());
            }
        } else {
            outMsg = msg;
        }
        return outMsg;
    }

    @Override
    protected int getBredth() {
        return 1;
    }

    @Override
    protected void newPeersFound(int numNewPeers) {
        this._facade.setLastExploreNewDate(this.getContext().clock().now());
    }

    @Override
    public String getName() {
        return "Kademlia NetDb Explore";
    }
}

