/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.DescriptorUtils;
import java.lang.reflect.Field;
import java.util.Objects;
import org.jboss.jandex.FieldInfo;

public class FieldDescriptor {
    private final String declaringClass;
    private final String name;
    private final String type;

    private FieldDescriptor(String declaringClass, String name, String type) {
        this.declaringClass = declaringClass.replace('.', '/');
        this.name = name;
        this.type = type;
    }

    private FieldDescriptor(FieldInfo fieldInfo) {
        this.name = fieldInfo.name();
        this.type = DescriptorUtils.typeToString(fieldInfo.type());
        this.declaringClass = fieldInfo.declaringClass().toString().replace('.', '/');
    }

    public static FieldDescriptor of(String declaringClass, String name, String type) {
        return new FieldDescriptor(DescriptorUtils.objectToInternalClassName(declaringClass), name, DescriptorUtils.objectToDescriptor(type));
    }

    public static FieldDescriptor of(String declaringClass, String name, Class<?> type) {
        return new FieldDescriptor(DescriptorUtils.objectToInternalClassName(declaringClass), name, DescriptorUtils.objectToDescriptor(type));
    }

    public static FieldDescriptor of(Class<?> declaringClass, String name, String type) {
        return new FieldDescriptor(DescriptorUtils.objectToInternalClassName(declaringClass), name, DescriptorUtils.objectToDescriptor(type));
    }

    public static FieldDescriptor of(Class<?> declaringClass, String name, Class<?> type) {
        return new FieldDescriptor(DescriptorUtils.objectToInternalClassName(declaringClass), name, DescriptorUtils.objectToDescriptor(type));
    }

    public static FieldDescriptor of(FieldInfo fieldInfo) {
        return new FieldDescriptor(fieldInfo);
    }

    public static FieldDescriptor of(Field field) {
        return FieldDescriptor.of(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public String getName() {
        return this.name;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        return obj instanceof FieldDescriptor && this.equals((FieldDescriptor)obj);
    }

    public boolean equals(FieldDescriptor obj) {
        return obj == this || obj != null && this.declaringClass.equals(obj.declaringClass) && this.name.equals(obj.name) && this.type.equals(obj.type);
    }

    public int hashCode() {
        return Objects.hash(this.declaringClass, this.name, this.type);
    }
}

