/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jboss.byteman.agent.AccessEnabler;
import org.jboss.byteman.agent.DefaultAccessEnabler;
import org.jboss.byteman.agent.JigsawAccessEnablerGenerator;
import org.jboss.byteman.layer.LayerFactory;
import org.jboss.byteman.rule.helper.Helper;

public class JigsawAccessManager {
    public static AccessEnabler init(Instrumentation inst) {
        HashMap<String, Set<Module>> extraExports;
        Helper.verbose("AccessManager:init Initialising JDK9 AccessManager");
        if (inst == null) {
            Helper.verbose("AccessManager:init No instrumentation provided -- using default AccessEnabler");
            return new DefaultAccessEnabler();
        }
        Module module = LayerFactory.installModule("org.jboss.byteman.jigsaw", new String[]{"org.jboss.byteman.jigsaw"}, new String[]{"java.instrument"}, new Function<String, byte[]>(){

            @Override
            public byte[] apply(String s) {
                return JigsawAccessEnablerGenerator.getJigsawClassBytes(s);
            }
        });
        Helper.verbose("AccessManager:init created module");
        if (module == null) {
            return new DefaultAccessEnabler();
        }
        HashSet<Module> extraReads = new HashSet<Module>();
        extraReads.add(AccessEnabler.class.getModule());
        extraReads.add(ClassLoader.getPlatformClassLoader().getUnnamedModule());
        extraReads.add(ClassLoader.getSystemClassLoader().getUnnamedModule());
        HashMap<String, Set<Module>> extraExportsPrivate = extraExports = new HashMap<String, Set<Module>>();
        HashSet extraUses = new HashSet();
        HashMap extraProvides = new HashMap();
        inst.redefineModule(module, extraReads, extraExports, extraExportsPrivate, extraUses, extraProvides);
        Helper.verbose("AccessManager:init added extraReads");
        try {
            ClassLoader loader = module.getClassLoader();
            Class<?> enablerClazz = loader.loadClass("org.jboss.byteman.jigsaw.JigsawAccessEnabler");
            Constructor<?> constructor = enablerClazz.getConstructor(Instrumentation.class);
            AccessEnabler accessEnabler = (AccessEnabler)constructor.newInstance(inst);
            Helper.verbose("AccessManager:init returning JigsawAccessEnabler");
            return accessEnabler;
        }
        catch (Exception e) {
            Helper.err("AccessManager:init oops! returning DefaultAccessEnabler ");
            Helper.errTraceException(e);
            return new DefaultAccessEnabler();
        }
    }
}

