/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.tree.DefaultTreeNode;
import org.keycloak.models.map.storage.tree.TreeStorageNodeInstance;

public class TreeStorageNodePrescription
extends DefaultTreeNode<TreeStorageNodePrescription> {
    private static final Logger LOG = Logger.getLogger(TreeStorageNodePrescription.class);
    private final boolean isPrimarySourceForAnything;
    private final boolean isPrimarySourceForEverything;
    private final boolean isCacheForAnything;
    private final Map<Class<? extends AbstractEntity>, TreeStorageNodePrescription> restricted = new ConcurrentHashMap<Class<? extends AbstractEntity>, TreeStorageNodePrescription>();

    public TreeStorageNodePrescription(Map<String, Object> treeProperties) {
        this(treeProperties, null, null);
    }

    public TreeStorageNodePrescription(Map<String, Object> nodeProperties, Map<String, Object> edgeProperties, Map<String, Object> treeProperties) {
        super(nodeProperties, edgeProperties, treeProperties);
        Map psf = (Map)this.nodeProperties.get("___primary-source-for___");
        Map psfe = (Map)this.nodeProperties.get("___primary-source-for-excluded___");
        this.isPrimarySourceForAnything = psf != null && !psf.isEmpty() || psfe != null && !psfe.isEmpty();
        this.isPrimarySourceForEverything = psf == null && (psfe == null || psfe.isEmpty());
        Map cf = (Map)this.nodeProperties.get("___cache-for___");
        Map cfe = (Map)this.nodeProperties.get("___cache-for-excluded___");
        this.isCacheForAnything = cf != null && !cf.isEmpty() || cfe != null && !cfe.isEmpty();
    }

    public <V extends AbstractEntity> TreeStorageNodePrescription forEntityClass(Class<V> targetEntityClass) {
        return this.restricted.computeIfAbsent(targetEntityClass, c -> {
            HashMap<String, Object> treeProperties = new HashMap<String, Object>(TreeStorageNodePrescription.restrictConfigMap(targetEntityClass, this.getTreeProperties()));
            treeProperties.put("model-class", ModelEntityUtil.getModelType(targetEntityClass));
            return this.cloneTree(n -> n.forEntityClass(targetEntityClass, treeProperties));
        });
    }

    public <V extends AbstractEntity> TreeStorageNodeInstance<V> instantiate(KeycloakSession session) {
        return this.cloneTree(n -> new TreeStorageNodeInstance(session, (TreeStorageNodePrescription)n));
    }

    private <V extends AbstractEntity> TreeStorageNodePrescription forEntityClass(Class<V> targetEntityClass, Map<String, Object> treeProperties) {
        Map<String, Object> nodeProperties = TreeStorageNodePrescription.restrictConfigMap(targetEntityClass, this.getNodeProperties());
        Map<String, Object> edgeProperties = TreeStorageNodePrescription.restrictConfigMap(targetEntityClass, this.getEdgeProperties());
        if (nodeProperties == null || edgeProperties == null) {
            LOG.debugf("Cannot restrict storage for %s from node: %s", targetEntityClass, (Object)this);
            return null;
        }
        return new TreeStorageNodePrescription(nodeProperties, edgeProperties, treeProperties);
    }

    private static <V extends AbstractEntity> Map<String, Object> restrictConfigMap(Class<V> targetEntityClass, Map<String, Object> np) {
        Class modelType = ModelEntityUtil.getModelType(targetEntityClass, null);
        String name = Optional.ofNullable(modelType).map(ModelEntityUtil::getModelName).orElse(null);
        if (name == null) {
            return null;
        }
        Map res = np.entrySet().stream().filter(me -> ((String)me.getKey()).indexOf(91) == -1).filter(me -> me.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (s, a) -> s, HashMap::new));
        Pattern specificPropertyPattern = Pattern.compile("(.*?)\\[.*\\b" + Pattern.quote(name) + "\\b.*\\]");
        np.keySet().stream().map(specificPropertyPattern::matcher).filter(Matcher::matches).forEach(m -> res.put(m.group(1), np.get(m.group(0))));
        return res;
    }

    public boolean isReadOnly() {
        return this.getNodeProperty("read-only", Boolean.class).orElse(false);
    }

    public FieldContainedStatus isPrimarySourceFor(EntityField<?> field, Object parameter) {
        if (this.isPrimarySourceForEverything) {
            return FieldContainedStatus.FULLY;
        }
        if (!this.isPrimarySourceForAnything) {
            return FieldContainedStatus.NOT_CONTAINED;
        }
        FieldContainedStatus isPrimarySourceFor = this.getNodeProperty("___primary-source-for___", Map.class).map(m -> this.isFieldWithParameterIncludedInMap((Map<?, ?>)m, field, parameter)).orElse(FieldContainedStatus.FULLY);
        FieldContainedStatus isExcludedPrimarySourceFor = this.getNodeProperty("___primary-source-for-excluded___", Map.class).map(m -> this.isFieldWithParameterIncludedInMap((Map<?, ?>)m, field, parameter)).orElse(FieldContainedStatus.NOT_CONTAINED);
        return isPrimarySourceFor.minus(isExcludedPrimarySourceFor);
    }

    public FieldContainedStatus isCacheFor(EntityField<?> field, Object parameter) {
        if (!this.isCacheForAnything) {
            return FieldContainedStatus.NOT_CONTAINED;
        }
        Optional<Map> cacheForExcluded = this.getNodeProperty("___cache-for-excluded___", Map.class);
        FieldContainedStatus isCacheFor = this.getNodeProperty("___cache-for___", Map.class).map(m -> this.isFieldWithParameterIncludedInMap((Map<?, ?>)m, field, parameter)).orElse(cacheForExcluded.isPresent() ? FieldContainedStatus.FULLY : FieldContainedStatus.NOT_CONTAINED);
        FieldContainedStatus isExcludedCacheFor = cacheForExcluded.map(m -> this.isFieldWithParameterIncludedInMap((Map<?, ?>)m, field, parameter)).orElse(FieldContainedStatus.NOT_CONTAINED);
        return isCacheFor.minus(isExcludedCacheFor);
    }

    private FieldContainedStatus isFieldWithParameterIncludedInMap(Map<?, ?> field2possibleParameters, EntityField<?> field, Object parameter) {
        Collection specificCases = (Collection)field2possibleParameters.get(field);
        if (specificCases == null) {
            return field2possibleParameters.containsKey(field) ? FieldContainedStatus.FULLY : FieldContainedStatus.NOT_CONTAINED;
        }
        return parameter == null ? FieldContainedStatus.PARTIALLY : (specificCases.contains(parameter) ? FieldContainedStatus.FULLY : FieldContainedStatus.NOT_CONTAINED);
    }

    @Override
    protected String getLabel() {
        return this.getId() + this.getNodeProperty("___storage-provider___", String.class).map(s -> " [" + s + "]").orElse("");
    }

    public static enum FieldContainedStatus {
        FULLY{

            @Override
            public FieldContainedStatus minus(FieldContainedStatus s) {
                switch (s) {
                    case FULLY: {
                        return NOT_CONTAINED;
                    }
                    case PARTIALLY: {
                        return PARTIALLY;
                    }
                }
                return FULLY;
            }
        }
        ,
        PARTIALLY{

            @Override
            public FieldContainedStatus minus(FieldContainedStatus s) {
                switch (s) {
                    case FULLY: {
                        return NOT_CONTAINED;
                    }
                }
                return PARTIALLY;
            }
        }
        ,
        NOT_CONTAINED{

            @Override
            public FieldContainedStatus minus(FieldContainedStatus s) {
                return NOT_CONTAINED;
            }
        };


        public abstract FieldContainedStatus minus(FieldContainedStatus var1);

        public FieldContainedStatus max(FieldContainedStatus other) {
            return other == null || this.ordinal() < other.ordinal() ? this : other;
        }

        public FieldContainedStatus max(Supplier<FieldContainedStatus> otherFunc) {
            if (this.ordinal() == 0) {
                return this;
            }
            FieldContainedStatus other = otherFunc.get();
            return other == null || this.ordinal() < other.ordinal() ? this : other;
        }
    }
}

