/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker.installation.compose;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;

public final class DockerCertFileUtils {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    public static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    public static final String LINE_SEPERATOR = System.getProperty("line.separator");

    private DockerCertFileUtils() {
    }

    public static String formatCrtFileContents(Certificate certificate) throws CertificateEncodingException {
        return DockerCertFileUtils.encodeAndPrettify(BEGIN_CERT, certificate.getEncoded(), END_CERT);
    }

    public static String formatPrivateKeyContents(PrivateKey privateKey) {
        return DockerCertFileUtils.encodeAndPrettify(BEGIN_PRIVATE_KEY, privateKey.getEncoded(), END_PRIVATE_KEY);
    }

    public static String formatPublicKeyContents(PublicKey publicKey) {
        return DockerCertFileUtils.encodeAndPrettify(BEGIN_CERT, publicKey.getEncoded(), END_CERT);
    }

    private static String encodeAndPrettify(String header, byte[] rawCrtText, String footer) {
        Base64.Encoder encoder = Base64.getMimeEncoder(64, LINE_SEPERATOR.getBytes());
        String encodedCertText = new String(encoder.encode(rawCrtText));
        String prettified_cert = header + LINE_SEPERATOR + encodedCertText + LINE_SEPERATOR + footer;
        return prettified_cert;
    }
}

