/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.OIDCWellKnownProvider;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.FullNameMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserPropertyMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;
import org.keycloak.util.JsonSerialization;

public class ClaimsParameterTokenMapper
extends AbstractOIDCProtocolMapper
implements OIDCIDTokenMapper,
UserInfoTokenMapper {
    public static final String PROVIDER_ID = "oidc-claims-param-token-mapper";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getDisplayType() {
        return "Claims parameter Token";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Claims specified by Claims parameter are put into tokens.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        String claims = clientSessionCtx.getClientSession().getNote("claims");
        if (claims == null) {
            return;
        }
        if ("ID".equals(token.getType())) {
            this.putClaims("id_token", claims, token, mappingModel, userSession);
        } else {
            this.putClaims("userinfo", claims, token, mappingModel, userSession);
        }
    }

    private void putClaims(String tokenType, String claims, IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        JsonNode requestParams = null;
        try {
            requestParams = (JsonNode)JsonSerialization.readValue((String)claims, JsonNode.class);
        }
        catch (IOException e) {
            return;
        }
        if (!requestParams.has(tokenType)) {
            return;
        }
        JsonNode tokenNode = requestParams.findValue(tokenType);
        OIDCWellKnownProvider.DEFAULT_CLAIMS_SUPPORTED.stream().filter(i -> tokenNode.has(i)).filter(i -> tokenNode.findValue(i).has("essential")).filter(i -> tokenNode.findValue(i).findValue("essential").isBoolean()).filter(i -> tokenNode.findValue(i).findValue("essential").asBoolean()).forEach(i -> {
            if (i.equals("name")) {
                FullNameMapper fullNameMapper = new FullNameMapper();
                fullNameMapper.setClaim(token, mappingModel, userSession);
            } else if (i.equals("given_name")) {
                UserPropertyMapper userPropertyMapper = new UserPropertyMapper();
                userPropertyMapper.setClaim(token, UserPropertyMapper.createClaimMapper("requested firstName", "firstName", "given_name", "String", false, true), userSession);
            } else if (i.equals("family_name")) {
                UserPropertyMapper userPropertyMapper = new UserPropertyMapper();
                userPropertyMapper.setClaim(token, UserPropertyMapper.createClaimMapper("requested lastName", "lastName", "family_name", "String", false, true), userSession);
            } else if (i.equals("preferred_username")) {
                UserPropertyMapper userPropertyMapper = new UserPropertyMapper();
                userPropertyMapper.setClaim(token, UserPropertyMapper.createClaimMapper("requested username", "username", "preferred_username", "String", false, true), userSession);
            } else if (i.equals("email")) {
                UserPropertyMapper userPropertyMapper = new UserPropertyMapper();
                userPropertyMapper.setClaim(token, UserPropertyMapper.createClaimMapper("requested email", "email", "email", "String", false, true), userSession);
            }
        });
    }

    public static ProtocolMapperModel createMapper(String name, boolean idToken, boolean userInfo) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        if (idToken) {
            config.put("id.token.claim", "true");
        }
        if (userInfo) {
            config.put("userinfo.token.claim", "true");
        }
        mapper.setConfig(config);
        return mapper;
    }

    static {
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, ClaimsParameterTokenMapper.class);
    }
}

