"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupAlertsRoutes = setupAlertsRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupAlertsRoutes(services, router) {
  const {
    alertService
  } = services;
  router.get({
    path: _constants.API.GET_ALERTS,
    validate: {
      query: _configSchema.schema.object({
        detectorType: _configSchema.schema.maybe(_configSchema.schema.string()),
        detector_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, alertService.getAlerts);
  router.post({
    path: _constants.API.ACKNOWLEDGE_ALERTS,
    validate: {
      params: _configSchema.schema.object({
        detector_id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, alertService.acknowledgeAlerts);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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