"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FindingsService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getFindings", async (context, request, response) => {
      try {
        const {
          detectorType,
          detectorId
        } = request.query;
        let params;

        if (detectorId) {
          params = {
            detectorId
          };
        } else if (detectorType) {
          params = {
            detectorType
          };
        } else {
          throw Error(`Invalid request params: detectorId or detectorType must be specified`);
        }

        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getFindingsResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.GET_FINDINGS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFindingsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - FindingsService - getFindings:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend GET Findings API.
   */


}

exports.default = FindingsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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