/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u << 0) => 0u
 * (0u << 1) => 0u
 * (0u << 2) => 0u
 * (0u << 5) => 0u
 * (0u << 25) => 0u
 * (0u << 31) => 0u
 * (1u << 0) => 1u
 * (1u << 1) => 2u
 * (1u << 2) => 4u
 * (1u << 5) => 32u
 * (1u << 25) => 33554432u
 * (1u << 31) => 2147483648u
 * (2u << 0) => 2u
 * (2u << 1) => 4u
 * (2u << 2) => 8u
 * (2u << 5) => 64u
 * (2u << 25) => 67108864u
 * (2u << 31) => 0u
 * (5u << 0) => 5u
 * (5u << 1) => 10u
 * (5u << 2) => 20u
 * (5u << 5) => 160u
 * (5u << 25) => 167772160u
 * (5u << 31) => 2147483648u
 * (25u << 0) => 25u
 * (25u << 1) => 50u
 * (25u << 2) => 100u
 * (25u << 5) => 800u
 * (25u << 25) => 838860800u
 * (25u << 31) => 2147483648u
 * (31u << 0) => 31u
 * (31u << 1) => 62u
 * (31u << 2) => 124u
 * (31u << 5) => 992u
 * (31u << 25) => 1040187392u
 * (31u << 31) => 2147483648u
 */
#version 130

void main()
{
  float[(0u << 0) == 0u ? 1 : -1] array0;
  float[(0u << 1) == 0u ? 1 : -1] array1;
  float[(0u << 2) == 0u ? 1 : -1] array2;
  float[(0u << 5) == 0u ? 1 : -1] array3;
  float[(0u << 25) == 0u ? 1 : -1] array4;
  float[(0u << 31) == 0u ? 1 : -1] array5;
  float[(1u << 0) == 1u ? 1 : -1] array6;
  float[(1u << 1) == 2u ? 1 : -1] array7;
  float[(1u << 2) == 4u ? 1 : -1] array8;
  float[(1u << 5) == 32u ? 1 : -1] array9;
  float[(1u << 25) == 33554432u ? 1 : -1] array10;
  float[(1u << 31) == 2147483648u ? 1 : -1] array11;
  float[(2u << 0) == 2u ? 1 : -1] array12;
  float[(2u << 1) == 4u ? 1 : -1] array13;
  float[(2u << 2) == 8u ? 1 : -1] array14;
  float[(2u << 5) == 64u ? 1 : -1] array15;
  float[(2u << 25) == 67108864u ? 1 : -1] array16;
  float[(2u << 31) == 0u ? 1 : -1] array17;
  float[(5u << 0) == 5u ? 1 : -1] array18;
  float[(5u << 1) == 10u ? 1 : -1] array19;
  float[(5u << 2) == 20u ? 1 : -1] array20;
  float[(5u << 5) == 160u ? 1 : -1] array21;
  float[(5u << 25) == 167772160u ? 1 : -1] array22;
  float[(5u << 31) == 2147483648u ? 1 : -1] array23;
  float[(25u << 0) == 25u ? 1 : -1] array24;
  float[(25u << 1) == 50u ? 1 : -1] array25;
  float[(25u << 2) == 100u ? 1 : -1] array26;
  float[(25u << 5) == 800u ? 1 : -1] array27;
  float[(25u << 25) == 838860800u ? 1 : -1] array28;
  float[(25u << 31) == 2147483648u ? 1 : -1] array29;
  float[(31u << 0) == 31u ? 1 : -1] array30;
  float[(31u << 1) == 62u ? 1 : -1] array31;
  float[(31u << 2) == 124u ? 1 : -1] array32;
  float[(31u << 5) == 992u ? 1 : -1] array33;
  float[(31u << 25) == 1040187392u ? 1 : -1] array34;
  float[(31u << 31) == 2147483648u ? 1 : -1] array35;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length());
}
