/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.util.ResourceLoader;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.SafeXMLParsing;
import org.apache.solr.util.SystemIdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfigFile {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final XPathFactory xpathFactory = XPathFactory.newInstance();
    private final Document doc;
    private final String prefix;
    private final String name;
    private final SolrResourceLoader loader;
    private final Properties substituteProperties;
    private int zkVersion = -1;

    public XmlConfigFile(SolrResourceLoader loader, String name, InputSource is, String prefix, Properties substituteProps) throws IOException {
        this(loader, s -> {
            try {
                return loader.openResource((String)s);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }, name, is, prefix, substituteProps);
    }

    public XmlConfigFile(SolrResourceLoader loader, Function<String, InputStream> fileSupplier, String name, InputSource is, String prefix, Properties substituteProps) throws IOException {
        this.loader = Objects.requireNonNull(loader);
        this.substituteProperties = substituteProps;
        this.name = name;
        this.prefix = prefix != null && !prefix.endsWith("/") ? prefix + "/" : prefix;
        try {
            if (is == null && fileSupplier != null) {
                InputStream in = fileSupplier.apply(name);
                if (in instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
                    this.zkVersion = ((ZkSolrResourceLoader.ZkByteArrayInputStream)in).getStat().getVersion();
                    log.debug("loaded config {} with version {} ", (Object)name, (Object)this.zkVersion);
                }
                is = new InputSource(in);
                is.setSystemId(SystemIdResolver.createSystemIdFromResourceName(name));
            }
            this.doc = is != null ? SafeXMLParsing.parseConfigXML(log, (ResourceLoader)loader, is) : SafeXMLParsing.parseConfigXML(log, (ResourceLoader)loader, name);
        }
        catch (SAXException e) {
            SolrException.log((Logger)log, (String)("Exception during parsing file: " + name), (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        if (substituteProps != null) {
            DOMUtil.substituteProperties((Node)this.doc, (Properties)this.getSubstituteProperties());
        }
    }

    public static void assertWarnOrFail(String reason, boolean assertCondition, boolean failCondition) {
        if (assertCondition) {
            return;
        }
        if (failCondition) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, reason);
        }
        log.warn(reason);
    }

    protected Properties getSubstituteProperties() {
        return this.substituteProperties;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public String getResourceName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Document getDocument() {
        return this.doc;
    }

    public XPath getXPath() {
        return xpathFactory.newXPath();
    }

    private String normalize(String path) {
        return this.prefix == null || path.startsWith("/") ? path : this.prefix + path;
    }

    public Object evaluate(String path, QName type) {
        XPath xpath = xpathFactory.newXPath();
        try {
            String xstr = this.normalize(path);
            Object o = xpath.evaluate(xstr, this.doc, type);
            return o;
        }
        catch (XPathExpressionException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + path + " for " + this.name, (Throwable)e);
        }
    }

    public Node getNode(String path, boolean errifMissing) {
        return this.getNode(path, this.doc, errifMissing);
    }

    public Node getNode(String path, Document doc, boolean errIfMissing) {
        XPath xpath = xpathFactory.newXPath();
        String xstr = this.normalize(path);
        try {
            NodeList nodes = (NodeList)xpath.evaluate(xstr, doc, XPathConstants.NODESET);
            if (nodes == null || 0 == nodes.getLength()) {
                if (errIfMissing) {
                    throw new RuntimeException(this.name + " missing " + path);
                }
                log.trace("{} missing optional {}", (Object)this.name, (Object)path);
                return null;
            }
            if (1 < nodes.getLength()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.name + " contains more than one value for config path: " + path);
            }
            Node nd = nodes.item(0);
            log.trace("{}:{}={}", new Object[]{this.name, path, nd});
            return nd;
        }
        catch (XPathExpressionException e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e);
        }
    }

    public NodeList getNodeList(String path, boolean errIfMissing) {
        XPath xpath = xpathFactory.newXPath();
        String xstr = this.normalize(path);
        try {
            NodeList nodeList = (NodeList)xpath.evaluate(xstr, this.doc, XPathConstants.NODESET);
            if (null == nodeList) {
                if (errIfMissing) {
                    throw new RuntimeException(this.name + " missing " + path);
                }
                log.trace("{} missing optional {}", (Object)this.name, (Object)path);
                return null;
            }
            log.trace("{}:{}={}", new Object[]{this.name, path, nodeList});
            return nodeList;
        }
        catch (XPathExpressionException e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e);
        }
    }

    public Set<String> getUnknownAttributes(Element element, String ... knownAttributes) {
        HashSet<String> knownAttributeSet = new HashSet<String>(Arrays.asList(knownAttributes));
        HashSet<String> unknownAttributeSet = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.item(i).getNodeName();
            if (knownAttributeSet.contains(attributeName)) continue;
            if (null == unknownAttributeSet) {
                unknownAttributeSet = new HashSet<String>();
            }
            unknownAttributeSet.add(attributeName);
        }
        return unknownAttributeSet;
    }

    public void complainAboutUnknownAttributes(String elementXpath, String ... knownAttributes) {
        TreeMap<String, TreeSet<String>> problems = new TreeMap<String, TreeSet<String>>();
        NodeList nodeList = this.getNodeList(elementXpath, false);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Set<String> set = this.getUnknownAttributes(element, knownAttributes);
            if (null == set) continue;
            String elementName = element.getNodeName();
            TreeSet<String> allUnknownAttributes = (TreeSet<String>)problems.get(elementName);
            if (null == allUnknownAttributes) {
                allUnknownAttributes = new TreeSet<String>();
                problems.put(elementName, allUnknownAttributes);
            }
            allUnknownAttributes.addAll(set);
        }
        if (problems.size() > 0) {
            StringBuilder message = new StringBuilder();
            for (Map.Entry entry : problems.entrySet()) {
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append('<');
                message.append((String)entry.getKey());
                for (String attributeName : (SortedSet)entry.getValue()) {
                    message.append(' ');
                    message.append(attributeName);
                    message.append("=\"...\"");
                }
                message.append('>');
            }
            message.insert(0, "Unknown attribute(s) on element(s): ");
            String msg = message.toString();
            SolrException.log((Logger)log, (String)msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
    }

    public String getVal(String path, boolean errIfMissing) {
        Node nd = this.getNode(path, errIfMissing);
        if (nd == null) {
            return null;
        }
        String txt = DOMUtil.getText((Node)nd);
        log.debug("{} {}={}", new Object[]{this.name, path, txt});
        return txt;
    }

    public String get(String path) {
        return this.getVal(path, true);
    }

    public String get(String path, String def) {
        String val = this.getVal(path, false);
        if (val == null || val.length() == 0) {
            return def;
        }
        return val;
    }

    public int getInt(String path) {
        return Integer.parseInt(this.getVal(path, true));
    }

    public int getInt(String path, int def) {
        String val = this.getVal(path, false);
        return val != null ? Integer.parseInt(val) : def;
    }

    public boolean getBool(String path) {
        return Boolean.parseBoolean(this.getVal(path, true));
    }

    public boolean getBool(String path, boolean def) {
        String val = this.getVal(path, false);
        return val != null ? Boolean.parseBoolean(val) : def;
    }

    public float getFloat(String path) {
        return Float.parseFloat(this.getVal(path, true));
    }

    public float getFloat(String path, float def) {
        String val = this.getVal(path, false);
        return val != null ? Float.parseFloat(val) : def;
    }

    public double getDouble(String path) {
        return Double.parseDouble(this.getVal(path, true));
    }

    public double getDouble(String path, double def) {
        String val = this.getVal(path, false);
        return val != null ? Double.parseDouble(val) : def;
    }

    public int getZnodeVersion() {
        return this.zkVersion;
    }
}

