/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CoreAdminOperation;
import org.apache.solr.handler.admin.api.AllCoresStatusAPI;
import org.apache.solr.handler.admin.api.CreateCoreAPI;
import org.apache.solr.handler.admin.api.InvokeClassAPI;
import org.apache.solr.handler.admin.api.MergeIndexesAPI;
import org.apache.solr.handler.admin.api.OverseerOperationAPI;
import org.apache.solr.handler.admin.api.PrepareCoreRecoveryAPI;
import org.apache.solr.handler.admin.api.RejoinLeaderElectionAPI;
import org.apache.solr.handler.admin.api.ReloadCoreAPI;
import org.apache.solr.handler.admin.api.RenameCoreAPI;
import org.apache.solr.handler.admin.api.RequestApplyCoreUpdatesAPI;
import org.apache.solr.handler.admin.api.RequestBufferUpdatesAPI;
import org.apache.solr.handler.admin.api.RequestCoreCommandStatusAPI;
import org.apache.solr.handler.admin.api.RequestCoreRecoveryAPI;
import org.apache.solr.handler.admin.api.RequestSyncShardAPI;
import org.apache.solr.handler.admin.api.SingleCoreStatusAPI;
import org.apache.solr.handler.admin.api.SplitCoreAPI;
import org.apache.solr.handler.admin.api.SwapCoresAPI;
import org.apache.solr.handler.admin.api.UnloadCoreAPI;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.stats.MetricUtils;
import org.apache.solr.util.tracing.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CoreAdminHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    protected final Map<String, Map<String, TaskObject>> requestStatusMap;
    protected ExecutorService parallelExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)50, (ThreadFactory)new SolrNamedThreadFactory("parallelCoreAdminExecutor"));
    protected static int MAX_TRACKED_REQUESTS = 100;
    public static String RUNNING = "running";
    public static String COMPLETED = "completed";
    public static String FAILED = "failed";
    public static String RESPONSE_STATUS = "STATUS";
    public static String RESPONSE_MESSAGE = "msg";
    public static String OPERATION_RESPONSE = "response";
    public static ImmutableMap<String, String> paramToProp = ImmutableMap.builder().put((Object)"config", (Object)"config").put((Object)"schema", (Object)"schema").put((Object)"dataDir", (Object)"dataDir").put((Object)"ulogDir", (Object)"ulogDir").put((Object)"configSet", (Object)"configSet").put((Object)"loadOnStartup", (Object)"loadOnStartup").put((Object)"transient", (Object)"transient").put((Object)"shard", (Object)"shard").put((Object)"collection", (Object)"collection").put((Object)"roles", (Object)"roles").put((Object)"coreNodeName", (Object)"coreNodeName").put((Object)"numShards", (Object)"numShards").put((Object)"replicaType", (Object)"replicaType").build();
    private static final Map<String, CoreAdminOp> opMap = new HashMap<String, CoreAdminOp>();

    public CoreAdminHandler() {
        this.coreContainer = null;
        HashMap map = new HashMap(3, 1.0f);
        map.put(RUNNING, Collections.synchronizedMap(new LinkedHashMap()));
        map.put(COMPLETED, Collections.synchronizedMap(new LinkedHashMap()));
        map.put(FAILED, Collections.synchronizedMap(new LinkedHashMap()));
        this.requestStatusMap = Collections.unmodifiableMap(map);
    }

    public CoreAdminHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        HashMap map = new HashMap(3, 1.0f);
        map.put(RUNNING, Collections.synchronizedMap(new LinkedHashMap()));
        map.put(COMPLETED, Collections.synchronizedMap(new LinkedHashMap()));
        map.put(FAILED, Collections.synchronizedMap(new LinkedHashMap()));
        this.requestStatusMap = Collections.unmodifiableMap(map);
    }

    @Override
    public final void init(NamedList<?> args) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler should not be configured in solrconf.xml\nit is a special Handler configured directly by the RequestDispatcher");
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        super.initializeMetrics(parentContext, scope);
        this.parallelExecutor = MetricUtils.instrumentedExecutorService(this.parallelExecutor, this, this.solrMetricsContext.getMetricRegistry(), SolrMetricManager.mkName("parallelCoreAdminExecutor", this.getCategory().name(), scope, "threadPool"));
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    public final void registerCustomActions(Map<String, CoreAdminOp> customActions) {
        for (Map.Entry<String, CoreAdminOp> entry : customActions.entrySet()) {
            String action = entry.getKey().toLowerCase(Locale.ROOT);
            CoreAdminOp operation = entry.getValue();
            if (opMap.containsKey(action)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler already registered action " + action);
            }
            opMap.put(action, operation);
        }
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        block12: {
            try {
                String action;
                CoreAdminOp op;
                CoreContainer cores = this.getCoreContainer();
                if (cores == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
                }
                String taskId = req.getParams().get("async");
                TaskObject taskObject = new TaskObject(taskId);
                if (taskId != null) {
                    if (this.getRequestStatusMap(RUNNING).containsKey(taskId) || this.getRequestStatusMap(COMPLETED).containsKey(taskId) || this.getRequestStatusMap(FAILED).containsKey(taskId)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Duplicate request with the same requestid found.");
                    }
                    this.addTask(RUNNING, taskObject);
                }
                if ((op = opMap.get(action = req.getParams().get("action", CoreAdminParams.CoreAdminAction.STATUS.toString()).toLowerCase(Locale.ROOT))) == null) {
                    log.warn("action '{}' not found, calling custom action handler. If original intention was to target some custom behaviour use custom actions defined in 'solr.xml' instead", (Object)action);
                    this.handleCustomAction(req, rsp);
                    return;
                }
                CallInfo callInfo = new CallInfo(this, req, rsp, op);
                String coreName = req.getParams().get("core", req.getParams().get("name"));
                MDCLoggingContext.setCoreName(coreName);
                TraceUtils.setDbInstance(req, coreName);
                if (taskId == null) {
                    callInfo.call();
                    break block12;
                }
                try {
                    MDC.put((String)"CoreAdminHandler.asyncId", (String)taskId);
                    MDC.put((String)"CoreAdminHandler.action", (String)action);
                    this.parallelExecutor.execute(() -> {
                        boolean exceptionCaught = false;
                        try {
                            callInfo.call();
                            taskObject.setRspObject(callInfo.rsp);
                            taskObject.setOperationRspObject(callInfo.rsp);
                        }
                        catch (Exception e) {
                            exceptionCaught = true;
                            taskObject.setRspObjectFromException(e);
                        }
                        finally {
                            this.removeTask("running", taskObject.taskId);
                            if (exceptionCaught) {
                                this.addTask("failed", taskObject, true);
                            } else {
                                this.addTask("completed", taskObject, true);
                            }
                        }
                    });
                }
                finally {
                    MDC.remove((String)"CoreAdminHandler.asyncId");
                    MDC.remove((String)"CoreAdminHandler.action");
                }
            }
            finally {
                rsp.setHttpCaching(false);
            }
        }
    }

    @Deprecated
    protected void handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported operation: " + req.getParams().get("action"));
    }

    protected static Map<String, String> buildCoreParams(SolrParams params) {
        HashMap<String, String> coreParams = new HashMap<String, String>();
        for (Map.Entry entry : paramToProp.entrySet()) {
            String value = params.get((String)entry.getKey(), null);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            coreParams.put((String)entry.getValue(), value);
        }
        Iterator paramsIt = params.getParameterNamesIterator();
        while (paramsIt.hasNext()) {
            String param = (String)paramsIt.next();
            if (param.startsWith("property.")) {
                String propName = param.substring("property.".length());
                String propValue = params.get(param);
                coreParams.put(propName, propValue);
            }
            if (!param.startsWith("collection.")) continue;
            coreParams.put(param, params.get(param));
        }
        return coreParams;
    }

    protected static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        return path;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage Multiple Solr Cores";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String action = ctx.getParams().get("action");
        if (action == null) {
            return PermissionNameProvider.Name.CORE_READ_PERM;
        }
        CoreAdminParams.CoreAdminAction coreAction = CoreAdminParams.CoreAdminAction.get((String)action);
        if (coreAction == null) {
            return PermissionNameProvider.Name.CORE_READ_PERM;
        }
        return coreAction.isRead ? PermissionNameProvider.Name.CORE_READ_PERM : PermissionNameProvider.Name.CORE_EDIT_PERM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTask(String type, TaskObject o, boolean limit) {
        Map<String, TaskObject> map = this.getRequestStatusMap(type);
        synchronized (map) {
            if (limit && this.getRequestStatusMap(type).size() == MAX_TRACKED_REQUESTS) {
                String key = this.getRequestStatusMap(type).entrySet().iterator().next().getKey();
                this.getRequestStatusMap(type).remove(key);
            }
            this.addTask(type, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(String type, TaskObject o) {
        Map<String, TaskObject> map = this.getRequestStatusMap(type);
        synchronized (map) {
            this.getRequestStatusMap(type).put(o.taskId, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(String map, String taskId) {
        Map<String, TaskObject> map2 = this.getRequestStatusMap(map);
        synchronized (map2) {
            this.getRequestStatusMap(map).remove(taskId);
        }
    }

    Map<String, TaskObject> getRequestStatusMap(String key) {
        return this.requestStatusMap.get(key);
    }

    public void shutdown() {
        if (this.parallelExecutor != null) {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.parallelExecutor);
        }
    }

    @Override
    public Collection<Api> getApis() {
        ArrayList apis = Lists.newArrayList();
        apis.addAll(AnnotatedApi.getApis(new AllCoresStatusAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new SingleCoreStatusAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new CreateCoreAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new InvokeClassAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RejoinLeaderElectionAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new OverseerOperationAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new ReloadCoreAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new SwapCoresAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RenameCoreAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new UnloadCoreAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new MergeIndexesAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new SplitCoreAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestCoreCommandStatusAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestCoreRecoveryAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new PrepareCoreRecoveryAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestApplyCoreUpdatesAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestSyncShardAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestBufferUpdatesAPI(this)));
        return apis;
    }

    static {
        for (CoreAdminOperation op : CoreAdminOperation.values()) {
            opMap.put(op.action.toString().toLowerCase(Locale.ROOT), op);
        }
    }

    public static interface CoreAdminOp {
        public void execute(CallInfo var1) throws Exception;
    }

    public static interface Invocable {
        public Map<String, Object> invoke(SolrQueryRequest var1);
    }

    public static class CallInfo {
        public final CoreAdminHandler handler;
        public final SolrQueryRequest req;
        public final SolrQueryResponse rsp;
        public final CoreAdminOp op;

        CallInfo(CoreAdminHandler handler, SolrQueryRequest req, SolrQueryResponse rsp, CoreAdminOp op) {
            this.handler = handler;
            this.req = req;
            this.rsp = rsp;
            this.op = op;
        }

        void call() throws Exception {
            this.op.execute(this);
        }
    }

    static class TaskObject {
        String taskId;
        String rspInfo;
        Object operationRspInfo;

        public TaskObject(String taskId) {
            this.taskId = taskId;
        }

        public String getRspObject() {
            return this.rspInfo;
        }

        public void setRspObject(SolrQueryResponse rspObject) {
            this.rspInfo = rspObject.getToLogAsString("TaskId: " + this.taskId);
        }

        public void setRspObjectFromException(Exception e) {
            this.rspInfo = e.getMessage();
        }

        public Object getOperationRspObject() {
            return this.operationRspInfo;
        }

        public void setOperationRspObject(SolrQueryResponse rspObject) {
            this.operationRspInfo = rspObject.getResponse();
        }
    }
}

