/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.SchemaLocation;
import org.everit.json.schema.TrueSchema;
import org.everit.json.schema.loader.AdjacentSchemaExtractionState;
import org.everit.json.schema.loader.CombinedSchemaLoader;
import org.everit.json.schema.loader.ConstSchemaExtractor;
import org.everit.json.schema.loader.EnumSchemaExtractor;
import org.everit.json.schema.loader.ExtractionResult;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.KeyConsumer;
import org.everit.json.schema.loader.LoaderConfig;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.NotSchemaExtractor;
import org.everit.json.schema.loader.OrgJsonUtil;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor;
import org.everit.json.schema.loader.ReferenceKnot;
import org.everit.json.schema.loader.ReferenceSchemaExtractor;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaExtractor;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.SubschemaRegistry;
import org.everit.json.schema.loader.TypeBasedSchemaExtractor;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.everit.json.schema.loader.internal.WrappingFormatValidator;
import org.everit.json.schema.regexp.JavaUtilRegexpFactory;
import org.everit.json.schema.regexp.RegexpFactory;
import org.json.JSONObject;

public class SchemaLoader {
    private final LoaderConfig config;
    private final LoadingState ls;

    static JSONObject toOrgJSONObject(JsonObject value) {
        return new JSONObject(value.toMap());
    }

    public static SchemaLoaderBuilder builder() {
        return new SchemaLoaderBuilder();
    }

    public static Schema load(JSONObject schemaJson) {
        return SchemaLoader.load(schemaJson, new DefaultSchemaClient());
    }

    public static Schema load(JSONObject schemaJson, SchemaClient schemaClient) {
        SchemaLoader loader = SchemaLoader.builder().schemaJson(schemaJson).schemaClient(schemaClient).build();
        return loader.load().build();
    }

    public SchemaLoader(SchemaLoaderBuilder builder) {
        SpecificationVersion specVersion;
        Object effectiveRootSchemaJson = builder.rootSchemaJson == null ? builder.schemaJson : builder.rootSchemaJson;
        Optional<String> schemaKeywordValue = SchemaLoader.extractSchemaKeywordValue(effectiveRootSchemaJson);
        if (schemaKeywordValue.isPresent()) {
            try {
                specVersion = SpecificationVersion.getByMetaSchemaUrl(schemaKeywordValue.get());
            }
            catch (IllegalArgumentException e) {
                if (builder.specVersionIsExplicitlySet) {
                    specVersion = builder.specVersion;
                }
                throw new SchemaException("#", "could not determine version");
            }
        } else {
            specVersion = builder.specVersion;
        }
        this.config = new LoaderConfig(builder.schemaClient, builder.formatValidators, builder.schemasByURI, specVersion, builder.useDefaults, builder.nullableSupport, builder.regexpFactory);
        this.ls = new LoadingState(this.config, builder.pointerSchemas, effectiveRootSchemaJson, builder.schemaJson, builder.id, builder.pointerToCurrentObj, builder.subschemaRegistries);
    }

    private static Optional<String> extractSchemaKeywordValue(Object effectiveRootSchemaJson) {
        Object schemaObj;
        Object schemaValue;
        if (effectiveRootSchemaJson instanceof Map && (schemaValue = (schemaObj = (Map)effectiveRootSchemaJson).get("$schema")) != null) {
            return Optional.of((String)schemaValue);
        }
        if (effectiveRootSchemaJson instanceof JsonObject && (schemaValue = ((JsonObject)(schemaObj = (JsonObject)effectiveRootSchemaJson)).get("$schema")) != null) {
            return Optional.of((String)schemaValue);
        }
        return Optional.empty();
    }

    SchemaLoader(LoadingState ls) {
        this.ls = ls;
        this.config = ls.config;
    }

    private Schema.Builder loadSchemaBoolean(Boolean rawBoolean) {
        return rawBoolean != false ? TrueSchema.builder() : FalseSchema.builder();
    }

    private Schema.Builder loadSchemaObject(JsonObject o) {
        Schema.Builder effectiveReturnedSchema;
        AdjacentSchemaExtractionState postExtractionState = this.runSchemaExtractors(o);
        Collection<Schema.Builder<?>> extractedSchemas = postExtractionState.extractedSchemaBuilders();
        if (extractedSchemas.isEmpty()) {
            effectiveReturnedSchema = EmptySchema.builder();
        } else if (extractedSchemas.size() == 1) {
            effectiveReturnedSchema = extractedSchemas.iterator().next();
        } else {
            Collection built = extractedSchemas.stream().map(Schema.Builder::build).map(Schema.class::cast).collect(Collectors.toList());
            effectiveReturnedSchema = CombinedSchema.allOf(built).isSynthetic(true);
        }
        AdjacentSchemaExtractionState postCommonPropLoadingState = this.loadCommonSchemaProperties(effectiveReturnedSchema, postExtractionState);
        Map<String, Object> unprocessed = postCommonPropLoadingState.projectedSchemaJson().toMap();
        effectiveReturnedSchema.unprocessedProperties(unprocessed);
        return effectiveReturnedSchema;
    }

    private AdjacentSchemaExtractionState runSchemaExtractors(JsonObject o) {
        AdjacentSchemaExtractionState state = new AdjacentSchemaExtractionState(o);
        if (o.containsKey("$ref")) {
            ExtractionResult result = new ReferenceSchemaExtractor(this).extract(o);
            state = state.reduce(result);
            return state;
        }
        List<SchemaExtractor> extractors = Arrays.asList(new EnumSchemaExtractor(this), new CombinedSchemaLoader(this), new NotSchemaExtractor(this), new ConstSchemaExtractor(this), new TypeBasedSchemaExtractor(this), new PropertySnifferSchemaExtractor(this));
        for (SchemaExtractor extractor : extractors) {
            ExtractionResult result = extractor.extract(state.projectedSchemaJson());
            state = state.reduce(result);
        }
        return state;
    }

    private AdjacentSchemaExtractionState loadCommonSchemaProperties(Schema.Builder builder, AdjacentSchemaExtractionState state) {
        KeyConsumer consumedKeys = new KeyConsumer(state.projectedSchemaJson());
        consumedKeys.maybe(this.config.specVersion.idKeyword()).map(JsonValue::requireString).ifPresent(builder::id);
        consumedKeys.maybe("title").map(JsonValue::requireString).ifPresent(builder::title);
        consumedKeys.maybe("description").map(JsonValue::requireString).ifPresent(builder::description);
        if (this.ls.specVersion() == SpecificationVersion.DRAFT_7) {
            consumedKeys.maybe("readOnly").map(JsonValue::requireBoolean).ifPresent(builder::readOnly);
            consumedKeys.maybe("writeOnly").map(JsonValue::requireBoolean).ifPresent(builder::writeOnly);
        }
        if (this.config.nullableSupport) {
            builder.nullable(consumedKeys.maybe("nullable").map(JsonValue::requireBoolean).orElse(Boolean.FALSE));
        }
        if (this.config.useDefaults) {
            consumedKeys.maybe("default").map(JsonValue::deepToOrgJson).ifPresent(builder::defaultValue);
        }
        builder.schemaLocation(this.ls.pointerToCurrentObj);
        return state.reduce(new ExtractionResult(consumedKeys.collect(), Collections.emptyList()));
    }

    public Schema.Builder<?> load() {
        return this.ls.schemaJson.canBeMappedTo(Boolean.class, this::loadSchemaBoolean).orMappedTo(JsonObject.class, this::loadSchemaObject).requireAny();
    }

    Schema.Builder<?> loadChild(JsonValue childJson) {
        return new SchemaLoader(childJson.ls).load();
    }

    SpecificationVersion specVersion() {
        return this.ls.specVersion();
    }

    @Deprecated
    Optional<FormatValidator> getFormatValidator(String formatName) {
        return Optional.ofNullable(this.config.formatValidators.get(formatName));
    }

    public static class SchemaLoaderBuilder {
        SchemaClient schemaClient = new DefaultSchemaClient();
        Object schemaJson;
        Object rootSchemaJson;
        Map<String, ReferenceKnot> pointerSchemas = new HashMap<String, ReferenceKnot>();
        Map<JsonValue, SubschemaRegistry> subschemaRegistries = new HashMap<JsonValue, SubschemaRegistry>();
        URI id;
        SchemaLocation pointerToCurrentObj = SchemaLocation.empty();
        Map<String, FormatValidator> formatValidators = new HashMap<String, FormatValidator>();
        SpecificationVersion specVersion;
        private boolean specVersionIsExplicitlySet = false;
        boolean useDefaults = false;
        private boolean nullableSupport = false;
        RegexpFactory regexpFactory = new JavaUtilRegexpFactory();
        Map<URI, Object> schemasByURI = null;
        private boolean enableOverrideOfBuiltInFormatValidators;

        public SchemaLoaderBuilder() {
            this.setSpecVersion(SpecificationVersion.DRAFT_4);
        }

        public SchemaLoaderBuilder addFormatValidator(FormatValidator formatValidator) {
            this.formatValidators.put(formatValidator.formatName(), formatValidator);
            return this;
        }

        @Deprecated
        public SchemaLoaderBuilder addFormatValidator(String formatName, FormatValidator formatValidator) {
            if (!Objects.equals(formatName, formatValidator.formatName())) {
                this.formatValidators.put(formatName, new WrappingFormatValidator(formatName, formatValidator));
            } else {
                this.formatValidators.put(formatName, formatValidator);
            }
            return this;
        }

        public SchemaLoaderBuilder draftV6Support() {
            this.setSpecVersion(SpecificationVersion.DRAFT_6);
            this.specVersionIsExplicitlySet = true;
            return this;
        }

        public SchemaLoaderBuilder draftV7Support() {
            this.setSpecVersion(SpecificationVersion.DRAFT_7);
            this.specVersionIsExplicitlySet = true;
            return this;
        }

        private void setSpecVersion(SpecificationVersion specVersion) {
            this.specVersion = specVersion;
        }

        private Optional<SpecificationVersion> specVersionInSchema() {
            Optional<SpecificationVersion> specVersion = Optional.empty();
            if (this.schemaJson instanceof Map) {
                Map schemaObj = (Map)this.schemaJson;
                String metaSchemaURL = (String)schemaObj.get("$schema");
                try {
                    specVersion = Optional.ofNullable(metaSchemaURL).map(SpecificationVersion::getByMetaSchemaUrl);
                }
                catch (IllegalArgumentException e) {
                    return specVersion;
                }
            }
            return specVersion;
        }

        public SchemaLoader build() {
            this.specVersionInSchema().ifPresent(this::setSpecVersion);
            this.addBuiltInFormatValidators();
            return new SchemaLoader(this);
        }

        private void addBuiltInFormatValidators() {
            Map<String, FormatValidator> defaultFormatValidators = this.specVersion.defaultFormatValidators();
            if (this.enableOverrideOfBuiltInFormatValidators) {
                for (Map.Entry<String, FormatValidator> entry : defaultFormatValidators.entrySet()) {
                    this.formatValidators.putIfAbsent(entry.getKey(), entry.getValue());
                }
            } else {
                this.formatValidators.putAll(defaultFormatValidators);
            }
        }

        @Deprecated
        public JSONObject getRootSchemaJson() {
            return new JSONObject((Map)(this.rootSchemaJson == null ? this.schemaJson : this.rootSchemaJson));
        }

        @Deprecated
        public SchemaLoaderBuilder httpClient(SchemaClient httpClient) {
            this.schemaClient = httpClient;
            return this;
        }

        public SchemaLoaderBuilder schemaClient(SchemaClient schemaClient) {
            this.schemaClient = schemaClient;
            return this;
        }

        public SchemaLoaderBuilder resolutionScope(String id) {
            try {
                return this.resolutionScope(new URI(id));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public SchemaLoaderBuilder resolutionScope(URI id) {
            this.id = id;
            this.pointerToCurrentObj = new SchemaLocation(id, Collections.emptyList());
            return this;
        }

        SchemaLoaderBuilder pointerSchemas(Map<String, ReferenceKnot> pointerSchemas) {
            this.pointerSchemas = pointerSchemas;
            return this;
        }

        SchemaLoaderBuilder subschemaRegistries(Map<JsonValue, SubschemaRegistry> subschemaRegistries) {
            this.subschemaRegistries = subschemaRegistries;
            return this;
        }

        SchemaLoaderBuilder rootSchemaJson(Object rootSchemaJson) {
            this.rootSchemaJson = rootSchemaJson;
            return this;
        }

        public SchemaLoaderBuilder schemaJson(JSONObject schemaJson) {
            return this.schemaJson(OrgJsonUtil.toMap(schemaJson));
        }

        public SchemaLoaderBuilder schemaJson(Object schema) {
            if (schema instanceof JSONObject) {
                schema = OrgJsonUtil.toMap((JSONObject)schema);
            }
            this.schemaJson = schema;
            return this;
        }

        SchemaLoaderBuilder formatValidators(Map<String, FormatValidator> formatValidators) {
            this.formatValidators = formatValidators;
            return this;
        }

        SchemaLoaderBuilder pointerToCurrentObj(SchemaLocation pointerToCurrentObj) {
            this.pointerToCurrentObj = Objects.requireNonNull(pointerToCurrentObj);
            return this;
        }

        public SchemaLoaderBuilder useDefaults(boolean useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        public SchemaLoaderBuilder nullableSupport(boolean nullableSupport) {
            this.nullableSupport = nullableSupport;
            return this;
        }

        public SchemaLoaderBuilder regexpFactory(RegexpFactory regexpFactory) {
            this.regexpFactory = regexpFactory;
            return this;
        }

        public SchemaLoaderBuilder registerSchemaByURI(URI uri, Object schema) {
            if (this.schemasByURI == null) {
                this.schemasByURI = new HashMap<URI, Object>();
            }
            this.schemasByURI.put(uri, schema);
            return this;
        }

        public SchemaLoaderBuilder enableOverrideOfBuiltInFormatValidators() {
            this.enableOverrideOfBuiltInFormatValidators = true;
            return this;
        }
    }
}

