/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BasePipelineFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.StatisticsManager;
import org.traccar.helper.DateUtil;
import org.traccar.helper.NetworkUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.session.ConnectionManager;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
@ChannelHandler.Sharable
public class MainEventHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainEventHandler.class);
    private final Set<String> connectionlessProtocols = new HashSet<String>();
    private final Set<String> logAttributes = new LinkedHashSet<String>();
    private final CacheManager cacheManager;
    private final Storage storage;
    private final ConnectionManager connectionManager;
    private final StatisticsManager statisticsManager;

    @Inject
    public MainEventHandler(Config config, CacheManager cacheManager, Storage storage, ConnectionManager connectionManager, StatisticsManager statisticsManager) {
        this.cacheManager = cacheManager;
        this.storage = storage;
        this.connectionManager = connectionManager;
        this.statisticsManager = statisticsManager;
        String connectionlessProtocolList = config.getString(Keys.STATUS_IGNORE_OFFLINE);
        if (connectionlessProtocolList != null) {
            this.connectionlessProtocols.addAll(Arrays.asList(connectionlessProtocolList.split("[, ]")));
        }
        this.logAttributes.addAll(Arrays.asList(config.getString(Keys.LOGGER_ATTRIBUTES).split("[, ]")));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Position) {
            Position position = (Position)msg;
            Device device = this.cacheManager.getObject(Device.class, position.getDeviceId());
            try {
                if (PositionUtil.isLatest(this.cacheManager, position)) {
                    Device updatedDevice = new Device();
                    updatedDevice.setId(position.getDeviceId());
                    updatedDevice.setPositionId(position.getId());
                    this.storage.updateObject(updatedDevice, new Request((Columns)new Columns.Include("positionId"), new Condition.Equals("id", updatedDevice.getId())));
                    this.cacheManager.updatePosition(position);
                    this.connectionManager.updatePosition(true, position);
                }
            }
            catch (StorageException error) {
                LOGGER.warn("Failed to update device", (Throwable)error);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(NetworkUtil.session(ctx.channel())).append("] ");
            builder.append("id: ").append(device.getUniqueId());
            Iterator<String> iterator = this.logAttributes.iterator();
            block20: while (iterator.hasNext()) {
                String attribute;
                switch (attribute = iterator.next()) {
                    case "time": {
                        builder.append(", time: ").append(DateUtil.formatDate(position.getFixTime(), false));
                        continue block20;
                    }
                    case "position": {
                        builder.append(", lat: ").append(String.format("%.5f", position.getLatitude()));
                        builder.append(", lon: ").append(String.format("%.5f", position.getLongitude()));
                        continue block20;
                    }
                    case "speed": {
                        if (!(position.getSpeed() > 0.0)) continue block20;
                        builder.append(", speed: ").append(String.format("%.1f", position.getSpeed()));
                        continue block20;
                    }
                    case "course": {
                        builder.append(", course: ").append(String.format("%.1f", position.getCourse()));
                        continue block20;
                    }
                    case "accuracy": {
                        if (!(position.getAccuracy() > 0.0)) continue block20;
                        builder.append(", accuracy: ").append(String.format("%.1f", position.getAccuracy()));
                        continue block20;
                    }
                    case "outdated": {
                        if (!position.getOutdated()) continue block20;
                        builder.append(", outdated");
                        continue block20;
                    }
                    case "invalid": {
                        if (position.getValid()) continue block20;
                        builder.append(", invalid");
                        continue block20;
                    }
                }
                Object value = position.getAttributes().get(attribute);
                if (value == null) continue;
                builder.append(", ").append(attribute).append(": ").append(value);
            }
            LOGGER.info(builder.toString());
            this.statisticsManager.registerMessageStored(position.getDeviceId(), position.getProtocol());
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (!(ctx.channel() instanceof DatagramChannel)) {
            LOGGER.info("[{}] connected", (Object)NetworkUtil.session(ctx.channel()));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LOGGER.info("[{}] disconnected", (Object)NetworkUtil.session(ctx.channel()));
        this.closeChannel(ctx.channel());
        boolean supportsOffline = BasePipelineFactory.getHandler(ctx.pipeline(), HttpRequestDecoder.class) == null && !this.connectionlessProtocols.contains(((BaseProtocolDecoder)ctx.pipeline().get(BaseProtocolDecoder.class)).getProtocolName());
        this.connectionManager.deviceDisconnected(ctx.channel(), supportsOffline);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        while (cause.getCause() != null && cause.getCause() != cause) {
            cause = cause.getCause();
        }
        LOGGER.info("[{}] error", (Object)NetworkUtil.session(ctx.channel()), (Object)cause);
        this.closeChannel(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            LOGGER.info("[{}] timed out", (Object)NetworkUtil.session(ctx.channel()));
            this.closeChannel(ctx.channel());
        }
    }

    private void closeChannel(Channel channel) {
        if (!(channel instanceof DatagramChannel)) {
            channel.close();
        }
    }
}

