/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import com.google.inject.Provider;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.traccar.api.security.PermissionsService;
import org.traccar.database.StatisticsManager;
import org.traccar.helper.Log;
import org.traccar.model.Device;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class MediaFilter
implements Filter {
    private final Storage storage;
    private final StatisticsManager statisticsManager;
    private final Provider<PermissionsService> permissionsServiceProvider;

    @Inject
    public MediaFilter(Storage storage, StatisticsManager statisticsManager, Provider<PermissionsService> permissionsServiceProvider) {
        this.storage = storage;
        this.statisticsManager = statisticsManager;
        this.permissionsServiceProvider = permissionsServiceProvider;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            Device device;
            String[] parts;
            HttpSession session = ((HttpServletRequest)request).getSession(false);
            Long userId = null;
            if (session != null && (userId = (Long)session.getAttribute("userId")) != null) {
                this.statisticsManager.registerRequest(userId);
            }
            if (userId == null) {
                httpResponse.sendError(401);
                return;
            }
            String path = ((HttpServletRequest)request).getPathInfo();
            String[] stringArray = parts = path != null ? path.split("/") : null;
            if (parts != null && parts.length >= 2 && (device = this.storage.getObject(Device.class, new Request((Columns)new Columns.All(), new Condition.Equals("uniqueId", parts[1])))) != null) {
                ((PermissionsService)this.permissionsServiceProvider.get()).checkPermission(Device.class, userId, device.getId());
                chain.doFilter(request, response);
                return;
            }
            httpResponse.sendError(403);
        }
        catch (SecurityException | StorageException e) {
            httpResponse.setStatus(403);
            httpResponse.getWriter().println(Log.exceptionStack(e));
        }
    }

    public void destroy() {
    }
}

