/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class DmtProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_HELLO = 0;
    public static final int MSG_HELLO_RESPONSE = 1;
    public static final int MSG_DATA_RECORD = 4;
    public static final int MSG_COMMIT = 5;
    public static final int MSG_COMMIT_RESPONSE = 6;
    public static final int MSG_DATA_RECORD_64 = 16;
    public static final int MSG_CANNED_REQUEST_1 = 20;
    public static final int MSG_CANNED_RESPONSE_1 = 21;
    public static final int MSG_CANNED_REQUEST_2 = 34;
    public static final int MSG_CANNED_RESPONSE_2 = 35;

    public DmtProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int type, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(2);
            response.writeByte(85);
            response.writeByte(type);
            response.writeShortLE(content != null ? content.readableBytes() : 0);
            if (content != null) {
                response.writeBytes(content);
                content.release();
            }
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private List<Position> decodeFixed64(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        while (buf.readableBytes() >= 64) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            buf.readByte();
            position.set("index", buf.readUnsignedIntLE());
            long time = buf.readUnsignedIntLE();
            position.setTime(new DateBuilder().setYear((int)(2000L + (time & 0x3FL))).setMonth((int)(time >> 6) & 0xF).setDay((int)(time >> 10) & 0x1F).setHour((int)(time >> 15) & 0x1F).setMinute((int)(time >> 20) & 0x3F).setSecond((int)(time >> 26) & 0x3F).getDate());
            position.setLongitude((double)buf.readIntLE() * 1.0E-7);
            position.setLatitude((double)buf.readIntLE() * 1.0E-7);
            position.setSpeed(UnitsConverter.knotsFromCps(buf.readUnsignedShortLE()));
            position.setCourse(buf.readUnsignedByte() * 2);
            position.setAltitude(buf.readShortLE());
            buf.readUnsignedShortLE();
            buf.readUnsignedByte();
            position.set("event", buf.readUnsignedByte());
            position.setValid(BitUtil.check(buf.readByte(), 0));
            position.set("input", buf.readUnsignedIntLE());
            position.set("output", buf.readUnsignedShortLE());
            for (int i = 1; i <= 5; ++i) {
                position.set("adc" + i, buf.readShortLE());
            }
            position.set("deviceTemp", buf.readByte());
            buf.readShortLE();
            buf.readShortLE();
            buf.readShortLE();
            buf.skipBytes(8);
            position.set("pdop", (double)buf.readUnsignedShortLE() * 0.01);
            buf.skipBytes(2);
            buf.readUnsignedShortLE();
            positions.add(position);
        }
        return positions;
    }

    private List<Position> decodeStandard(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        while (buf.isReadable()) {
            int recordEnd = buf.readerIndex() + buf.readUnsignedShortLE();
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("index", buf.readUnsignedIntLE());
            position.setDeviceTime(new Date(1356998400000L + buf.readUnsignedIntLE() * 1000L));
            position.set("event", buf.readUnsignedByte());
            while (buf.readerIndex() < recordEnd) {
                short fieldId = buf.readUnsignedByte();
                int fieldLength = buf.readUnsignedByte();
                int fieldEnd = buf.readerIndex() + (fieldLength == 255 ? buf.readUnsignedShortLE() : fieldLength);
                if (fieldId == 0) {
                    position.setFixTime(new Date(1356998400000L + buf.readUnsignedIntLE() * 1000L));
                    position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                    position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                    position.setAltitude(buf.readShortLE());
                    position.setSpeed(UnitsConverter.knotsFromCps(buf.readUnsignedShortLE()));
                    buf.readUnsignedByte();
                    position.setCourse(buf.readUnsignedByte() * 2);
                    position.set("pdop", (double)buf.readUnsignedByte() * 0.1);
                    position.setAccuracy(buf.readUnsignedByte());
                    position.setValid(buf.readUnsignedByte() != 0);
                } else if (fieldId == 2) {
                    int input = buf.readIntLE();
                    int output = buf.readUnsignedShortLE();
                    int status = buf.readUnsignedShortLE();
                    position.set("ignition", BitUtil.check(input, 0));
                    if (!BitUtil.check(status, 1)) {
                        position.set("alarm", "lowBattery");
                    } else if (BitUtil.check(status, 6)) {
                        position.set("alarm", "tampering");
                    }
                    position.set("input", input);
                    position.set("output", output);
                    position.set("status", status);
                } else if (fieldId == 6) {
                    block9: while (buf.readerIndex() < fieldEnd) {
                        short number = buf.readUnsignedByte();
                        switch (number) {
                            case 1: {
                                position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
                                continue block9;
                            }
                            case 2: {
                                position.set("power", (double)buf.readUnsignedShortLE() * 0.01);
                                continue block9;
                            }
                            case 3: {
                                position.set("deviceTemp", (double)buf.readShortLE() * 0.01);
                                continue block9;
                            }
                            case 4: {
                                position.set("rssi", buf.readUnsignedShortLE());
                                continue block9;
                            }
                            case 5: {
                                position.set("solarPower", (double)buf.readUnsignedShortLE() * 0.001);
                                continue block9;
                            }
                        }
                        position.set("io" + number, buf.readUnsignedShortLE());
                    }
                } else if (fieldId == 26) {
                    position.set("tripOdometer", buf.readUnsignedIntLE());
                    position.set("tripHours", buf.readUnsignedIntLE() * 1000L);
                } else if (fieldId == 27) {
                    position.set("odometer", buf.readUnsignedIntLE());
                    position.set("hours", buf.readUnsignedIntLE() * 1000L);
                }
                buf.readerIndex(fieldEnd);
            }
            if (position.getFixTime() == null) {
                this.getLastLocation(position, position.getDeviceTime());
            }
            positions.add(position);
        }
        return positions;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        short type = buf.readUnsignedByte();
        int length = buf.readUnsignedShortLE();
        if (type == 0) {
            buf.readUnsignedIntLE();
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, buf.readSlice(15).toString(StandardCharsets.US_ASCII));
            ByteBuf response = Unpooled.buffer();
            if (length == 51) {
                response.writeByte(0);
                response.writeIntLE(0);
            } else {
                response.writeIntLE((int)((System.currentTimeMillis() - 1356998400000L) / 1000L));
                response.writeIntLE(deviceSession != null ? 0 : 1);
            }
            this.sendResponse(channel, 1, response);
        } else if (type == 5) {
            ByteBuf response = Unpooled.buffer((int)0);
            response.writeByte(1);
            this.sendResponse(channel, 6, response);
        } else if (type == 20) {
            ByteBuf response = Unpooled.buffer((int)0);
            response.writeBytes(new byte[12]);
            this.sendResponse(channel, 21, response);
        } else if (type == 34) {
            this.sendResponse(channel, 35, null);
        } else {
            if (type == 16) {
                return this.decodeFixed64(channel, remoteAddress, buf);
            }
            if (type == 4) {
                return this.decodeStandard(channel, remoteAddress, buf);
            }
        }
        return null;
    }
}

