/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import javax.json.Json;
import javax.json.JsonObject;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class LacakProtocolDecoder
extends BaseHttpProtocolDecoder {
    public LacakProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        JsonObject root = Json.createReader((Reader)new StringReader(request.content().toString(StandardCharsets.US_ASCII))).readObject();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, root.getString("device_id"));
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        JsonObject location = root.getJsonObject("location");
        position.setTime(DateUtil.parseDate(location.getString("timestamp")));
        if (location.containsKey((Object)"coords")) {
            JsonObject coordinates = location.getJsonObject("coords");
            position.setLatitude(coordinates.getJsonNumber("latitude").doubleValue());
            position.setLongitude(coordinates.getJsonNumber("longitude").doubleValue());
            position.setAccuracy(coordinates.getJsonNumber("accuracy").doubleValue());
            position.setSpeed(coordinates.getJsonNumber("speed").doubleValue());
            position.setCourse(coordinates.getJsonNumber("heading").doubleValue());
            position.setAltitude(coordinates.getJsonNumber("altitude").doubleValue());
        }
        if (location.containsKey((Object)"event")) {
            position.set("event", location.getString("event"));
        }
        if (location.containsKey((Object)"is_moving")) {
            position.set("motion", location.getBoolean("is_moving"));
        }
        if (location.containsKey((Object)"odometer")) {
            position.set("odometer", location.getInt("odometer"));
        }
        if (location.containsKey((Object)"mock")) {
            position.set("mock", location.getBoolean("mock"));
        }
        if (location.containsKey((Object)"activity")) {
            position.set("activity", location.getJsonObject("activity").getString("type"));
        }
        if (location.containsKey((Object)"battery")) {
            JsonObject battery = location.getJsonObject("battery");
            position.set("batteryLevel", (int)(battery.getJsonNumber("level").doubleValue() * 100.0));
            position.set("charge", battery.getBoolean("is_charging"));
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }
}

