%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/overriding-articulations-of-destinct-type.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.21.2"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
ある特定のアーティキュレーションに対してのみ変更を施したい場合があります。@c
このような場合では常に @code{\\tweak} が使用できますが、楽譜全体にわたって@c
出現箇所に @code{\\tweak} を付加するのはうんざりするものです。@c
次の例では、カスタム設定のリストによってアーティキュレーションを調整する方法を@c
示しています。これは例えばスタイルシートに使用することができます。

2.16.2 以降では、この @code{\\customScripts} 関数を @code{\\layout}
ブロックに配置することができます。
"
  doctitleja = "特定の種類のアーティキュレーションのみをオーバライドする"

%% Translation of GIT committish: fc57157ac8148a900fde059f045a1e287f1493e6
  texidocfr = "
On peut parfois vouloir modifier un seul type d'articulation. Bien que
ce soit tout à fait faisable avec un @code{\\tweak}, cela devient vite
fastidieux d'affiner chaque occurrence d'un même signe dans toute une
partition. Le code ci-dessous illustre la manière de modifier des
articulations grâce à une liste de réglages personnalisés. Ceci peut
servir à créer des feuilles de style.

La fonction @code{\\customScripts} ici proposée peut se placer, avec la
version 2.16.2, dans un bloc @code{\\layout}.

"
  doctitlefr = "Personnalisation de certains types d'articulation"

%% Translation of GIT committish: 7688936a4e598bc9919e8a9adceb3ba1c9b2c23c
  texidoces = "
A veces queremos modificar un solo timpo de articulación.  Aunque
siempre es posible usar la instrucción @code{\\tweak}, podría hacerse
tedioso hacerlo para todos y cada uno de los símbolos de una partitura
completa.  El ejemplo muestra cómo trucar articulaciones con una lista
de ajustes personalizados.  Un caso sería la creación de una hoja de
estilos.

Con 2.16.2 it es posible introducir la función propuesta,
@code{\\customScripts}, en un bloque @code{\\layout}.

"
  doctitlees = "Modificación de articulaciones de diversos tipos"

  lsrtags = "scheme-language, tweaks-and-overrides"

  texidoc = "
Sometimes you may want to affect a single articulation-type. Although
it is always possible to use @code{\\tweak}, it might become tedious to
do so for every single sign of a whole score. The following shows how
to tweak articulations with a list of custom-settings. One use-case
might be to create a style-sheet.

With 2.16.2 it is possible to put the proposed function,
@code{\\customScripts}, into a @code{\\layout}-block.

"
  doctitle = "Overriding articulations of destinct type"
} % begin verbatim

% Code by David Nalesnik and Thomas Morley

#(define (custom-script-tweaks ls)
  (lambda (grob)
    (let* ((type (ly:prob-property
                    (ly:grob-property grob 'cause)
                    'articulation-type))
           (tweaks (assoc-ref ls type)))
      (if tweaks
          (for-each
            (lambda (x) (ly:grob-set-property! grob (car x) (cdr x)))
            tweaks)))))

customScripts =
#(define-music-function (settings)(list?)
#{
  \override Script.before-line-breaking =
    #(custom-script-tweaks settings)
#})

revertCustomScripts = { \revert Script.before-line-breaking }

%%%%%%%%%%%%%
% Example:
%%%%%%%%%%%%%

% Predefine a list of desired tweaks.
#(define my-settings-1
  '(
    ("staccato" . ((color . (1 0 0))(padding . 0.5)))
    ("accent" . ((font-size . 0)(color . (1 0 0))))
    ("tenuto" . ((rotation . (45 0 0)) (padding . 2)(font-size . 10)))
    ("staccatissimo" . ((padding . 1) (color . (1 0 0))))
    ("segno" . ((font-size . 0)(color . (1 0 0))))
    ))

#(define my-settings-2
  '(
    ("staccato" . ((color . (0 1 0))))
    ("accent" . ((font-size . 4)(color . (0 1 0))(padding . 1.5)))
    ("tenuto" . ((font-size . 10)))
    ("staccatissimo" . ((padding . 2) (color . (0 1 0))))
    ("coda" . ((color . (0 1 0)) (padding . 1)))
    ))

one =
\relative c'' {
  f1--
  \customScripts #my-settings-1
  f-. f-! f-> f-- f-!\segno
  \revertCustomScripts
  f-> f-.
}

two =
\relative c' {
  f1--
  \customScripts #my-settings-2
  f-. f-! f-> f---> f-!
  f-> f-.\coda
}

\new Staff <<
   \new Voice { \voiceOne \one }
   \new Voice { \voiceTwo \two }
   >>



% ****************************************************************
% end ly snippet
% ****************************************************************
