/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] points;

    public PGpolygon(PGpoint[] points) {
        this();
        this.points = points;
    }

    public PGpolygon(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public PGpolygon() {
        this.setType("polygon");
    }

    public void setValue(String s2) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s2), ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        for (int p2 = 0; p2 < npoints; ++p2) {
            this.points[p2] = new PGpoint(t.getToken(p2));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGpolygon) {
            PGpolygon p2 = (PGpolygon)obj;
            if (p2.points.length != this.points.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (this.points[i2].equals(p2.points[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i2 = 0; i2 < this.points.length && i2 < 5; ++i2) {
            hash ^= this.points[i2].hashCode();
        }
        return hash;
    }

    public Object clone() throws CloneNotSupportedException {
        PGpolygon newPGpolygon = (PGpolygon)super.clone();
        if (newPGpolygon.points != null) {
            newPGpolygon.points = (PGpoint[])newPGpolygon.points.clone();
            for (int i2 = 0; i2 < newPGpolygon.points.length; ++i2) {
                if (newPGpolygon.points[i2] == null) continue;
                newPGpolygon.points[i2] = (PGpoint)newPGpolygon.points[i2].clone();
            }
        }
        return newPGpolygon;
    }

    public String getValue() {
        StringBuilder b2 = new StringBuilder();
        b2.append("(");
        for (int p2 = 0; p2 < this.points.length; ++p2) {
            if (p2 > 0) {
                b2.append(",");
            }
            b2.append(this.points[p2].toString());
        }
        b2.append(")");
        return b2.toString();
    }
}

