info = {
    "name": "zh",
    "date_order": "YMD",
    "january": [
        "1月",
        "一月"
    ],
    "february": [
        "2月",
        "二月"
    ],
    "march": [
        "3月",
        "三月"
    ],
    "april": [
        "4月",
        "四月"
    ],
    "may": [
        "5月",
        "五月"
    ],
    "june": [
        "6月",
        "六月"
    ],
    "july": [
        "7月",
        "七月"
    ],
    "august": [
        "8月",
        "八月"
    ],
    "september": [
        "9月",
        "九月"
    ],
    "october": [
        "10月",
        "十月"
    ],
    "november": [
        "11月",
        "十一月"
    ],
    "december": [
        "12月",
        "十二月"
    ],
    "monday": [
        "周一",
        "星期一",
        "礼拜一"
    ],
    "tuesday": [
        "周二",
        "星期二",
        "礼拜二"
    ],
    "wednesday": [
        "周三",
        "星期三",
        "礼拜三"
    ],
    "thursday": [
        "周四",
        "星期四",
        "礼拜四"
    ],
    "friday": [
        "周五",
        "星期五",
        "礼拜五"
    ],
    "saturday": [
        "周六",
        "星期六",
        "礼拜六"
    ],
    "sunday": [
        "周日",
        "星期日",
        "星期天",
        "礼拜日",
        "礼拜天"
    ],
    "am": [
        "上午"
    ],
    "pm": [
        "下午"
    ],
    "year": [
        "年"
    ],
    "month": [
        "月",
        "个月",
        "個月"
    ],
    "week": [
        "周",
        "星期"
    ],
    "day": [
        "日",
        "天"
    ],
    "hour": [
        "小时"
    ],
    "minute": [
        "分",
        "分钟"
    ],
    "second": [
        "秒"
    ],
    "relative-type": {
        "0 day ago": [
            "今天"
        ],
        "0 hour ago": [
            "这一时间 / 此时"
        ],
        "0 minute ago": [
            "此刻"
        ],
        "0 month ago": [
            "本月"
        ],
        "0 second ago": [
            "现在",
            "刚刚"
        ],
        "0 week ago": [
            "本周"
        ],
        "0 year ago": [
            "今年"
        ],
        "1 day ago": [
            "昨天"
        ],
        "1 month ago": [
            "上个月"
        ],
        "1 week ago": [
            "上周"
        ],
        "1 year ago": [
            "去年"
        ],
        "in 1 day": [
            "明天"
        ],
        "in 1 month": [
            "下个月"
        ],
        "in 1 week": [
            "下周"
        ],
        "in 1 year": [
            "明年"
        ],
        "2 day ago": [
            "前天"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*)天前"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*)小时前"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*)分钟前"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*)个月前"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*)秒前",
            "(\\d+[.,]?\\d*)秒钟前"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*)周前"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*)年前"
        ],
        "in \\1 day": [
            "(\\d+[.,]?\\d*)天后"
        ],
        "in \\1 hour": [
            "(\\d+[.,]?\\d*)小时后"
        ],
        "in \\1 minute": [
            "(\\d+[.,]?\\d*)分钟后"
        ],
        "in \\1 month": [
            "(\\d+[.,]?\\d*)个月后"
        ],
        "in \\1 second": [
            "(\\d+[.,]?\\d*)秒后",
            "(\\d+[.,]?\\d*)秒钟后"
        ],
        "in \\1 week": [
            "(\\d+[.,]?\\d*)周后"
        ],
        "in \\1 year": [
            "(\\d+[.,]?\\d*)年后"
        ]
    },
    "locale_specific": {},
    "no_word_spacing": "True",
    "sentence_splitter_group": 4,
    "skip": [
        "约",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "ago": [
        "前"
    ],
    "in": [
        "在"
    ],
    "simplifications": [
        {
            "半小时前": "30分前"
        },
        {
            "(?:中午|下午|(?:晚上?))(?:\\s*)(\\d+[.,]?\\d*)(?:\\s*):(?:\\s+|:)?(\\d+[.,]?\\d*)": "\\1:\\2 pm"
        },
        {
            "(?:上午|早上|凌晨)(?:\\s*)(\\d+[.,]?\\d*)(?:\\s*):(?:\\s+|:)?(\\d+[.,]?\\d*)": "\\1:\\2 am"
        },
        {
            "中午": "12:00"
        },
        {
            "(\\d+[.,]?\\d*)年(?:\\s+)?(\\d+[.,]?\\d*)月(?:\\s+)?(\\d+[.,]?\\d*)日(?:\\s+)?(\\d+[.,]?\\d*)时(?:\\s+)?(\\d+[.,]?\\d*)分": "\\1-\\2-\\3 \\4:\\5"
        },
        {
            "(\\d+[.,]?\\d*)年(?:\\s+)?(\\d+[.,]?\\d*)月(?:\\s+)?(\\d{1,2})(?:日)?(?:\\s+)?(\\d{1,2})(?:点|:)(\\d{1,2})": "\\1-\\2-\\3 \\4:\\5"
        },
        {
            "(\\d+[.,]?\\d*)年(?:\\s+)?(\\d+[.,]?\\d*)月(?:\\s+)?(\\d{1,2})(?:日)?": "\\1-\\2-\\3"
        },
        {
            "(\\d+[.,]?\\d*)月(?=.*[前后])": "\\1 月"
        }
    ]
}
