# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2022 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.esx.settings.clusters.configuration.
#---------------------------------------------------------------------------

"""
The ``com.vmware.esx.settings.clusters.configuration_client`` module provides
classes to manage the configuration of an ESX cluster. The
``com.vmware.esx.settings.clusters.configuration.reports_client`` module
provides classes for accessing reports regarding the configuration state of the
cluster.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata

class DocumentStructure(Enum):
    """
    The ``DocumentStructure`` class contains the possible structures of the
    configuration document. **Warning:** This enumeration is available as
    Technology Preview. These are early access APIs provided to test, automate
    and provide feedback on the feature. Since this can change based on
    feedback, VMware does not guarantee backwards compatibility and recommends
    against using them in production environments. Some Technology Preview APIs
    might only be applicable to specific environments.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    HOST_ORIENTED = None
    """
    The host-specific portions of the document are stored in the
    "host-specific" object at the top-level with entries for each host,
    organized by the host's BIOS UUID. **Warning:** This class attribute is
    available as Technology Preview. These are early access APIs provided to
    test, automate and provide feedback on the feature. Since this can change
    based on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    """
    PROFILE_ORIENTED = None
    """
    The host-specific portions of the document are distributed through the
    "profile" object hierarchy. Each property that is host-specific will be an
    object with entries for each host where the property is defined. The hosts
    in the object are organized by BIOS UUID. **Warning:** This class attribute
    is available as Technology Preview. These are early access APIs provided to
    test, automate and provide feedback on the feature. Since this can change
    based on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`DocumentStructure` instance.
        """
        Enum.__init__(string)

DocumentStructure._set_values({
    'HOST_ORIENTED': DocumentStructure('HOST_ORIENTED'),
    'PROFILE_ORIENTED': DocumentStructure('PROFILE_ORIENTED'),
})
DocumentStructure._set_binding_type(type.EnumType(
    'com.vmware.esx.settings.clusters.configuration.document_structure',
    DocumentStructure))



class ComplianceStatus(Enum):
    """
    This ``ComplianceStatus`` class represents the compliance status of desired
    configuration on the ESXi host. **Warning:** This enumeration is available
    as Technology Preview. These are early access APIs provided to test,
    automate and provide feedback on the feature. Since this can change based
    on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    COMPLIANT = None
    """
    ESXi host is in compliance with Desired configuration. **Warning:** This
    class attribute is available as Technology Preview. These are early access
    APIs provided to test, automate and provide feedback on the feature. Since
    this can change based on feedback, VMware does not guarantee backwards
    compatibility and recommends against using them in production environments.
    Some Technology Preview APIs might only be applicable to specific
    environments.

    """
    NON_COMPLIANT = None
    """
    ESXi host is not in compliance with Desired configuration. **Warning:**
    This class attribute is available as Technology Preview. These are early
    access APIs provided to test, automate and provide feedback on the feature.
    Since this can change based on feedback, VMware does not guarantee
    backwards compatibility and recommends against using them in production
    environments. Some Technology Preview APIs might only be applicable to
    specific environments.

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`ComplianceStatus` instance.
        """
        Enum.__init__(string)

ComplianceStatus._set_values({
    'COMPLIANT': ComplianceStatus('COMPLIANT'),
    'NON_COMPLIANT': ComplianceStatus('NON_COMPLIANT'),
})
ComplianceStatus._set_binding_type(type.EnumType(
    'com.vmware.esx.settings.clusters.configuration.compliance_status',
    ComplianceStatus))



class ImpactType(Enum):
    """
    The ``ImpactType`` class contains information about the impact of applying
    desired configuration on the ESXi host. **Warning:** This enumeration is
    available as Technology Preview. These are early access APIs provided to
    test, automate and provide feedback on the feature. Since this can change
    based on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    NO_IMPACT = None
    """
    Host has no impact. **Warning:** This class attribute is available as
    Technology Preview. These are early access APIs provided to test, automate
    and provide feedback on the feature. Since this can change based on
    feedback, VMware does not guarantee backwards compatibility and recommends
    against using them in production environments. Some Technology Preview APIs
    might only be applicable to specific environments.

    """
    MAINTENANCE_MODE_REQUIRED = None
    """
    Host requires maintenance mode to reach the desired state. **Warning:**
    This class attribute is available as Technology Preview. These are early
    access APIs provided to test, automate and provide feedback on the feature.
    Since this can change based on feedback, VMware does not guarantee
    backwards compatibility and recommends against using them in production
    environments. Some Technology Preview APIs might only be applicable to
    specific environments.

    """
    REBOOT_REQUIRED = None
    """
    Host requires reboot to reach the desired state. **Warning:** This class
    attribute is available as Technology Preview. These are early access APIs
    provided to test, automate and provide feedback on the feature. Since this
    can change based on feedback, VMware does not guarantee backwards
    compatibility and recommends against using them in production environments.
    Some Technology Preview APIs might only be applicable to specific
    environments.

    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`ImpactType` instance.
        """
        Enum.__init__(string)

ImpactType._set_values({
    'NO_IMPACT': ImpactType('NO_IMPACT'),
    'MAINTENANCE_MODE_REQUIRED': ImpactType('MAINTENANCE_MODE_REQUIRED'),
    'REBOOT_REQUIRED': ImpactType('REBOOT_REQUIRED'),
})
ImpactType._set_binding_type(type.EnumType(
    'com.vmware.esx.settings.clusters.configuration.impact_type',
    ImpactType))




class HostStatus(VapiStruct):
    """
    The ``HostStatus`` class contains attributes that describe the status of an
    method. **Warning:** This class is available as Technology Preview. These
    are early access APIs provided to test, automate and provide feedback on
    the feature. Since this can change based on feedback, VMware does not
    guarantee backwards compatibility and recommends against using them in
    production environments. Some Technology Preview APIs might only be
    applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 status=None,
                 attempts=None,
                 remaining_retries=None,
                 start_time=None,
                 end_time=None,
                 notifications=None,
                ):
        """
        :type  status: :class:`HostStatus.Status`
        :param status: The status of the method. **Warning:** This attribute is available
            as Technology Preview. These are early access APIs provided to
            test, automate and provide feedback on the feature. Since this can
            change based on feedback, VMware does not guarantee backwards
            compatibility and recommends against using them in production
            environments. Some Technology Preview APIs might only be applicable
            to specific environments.
        :type  attempts: :class:`long` or ``None``
        :param attempts: Number of the performed attempts of the method. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
            This field is None if it is not applicable.
        :type  remaining_retries: :class:`long` or ``None``
        :param remaining_retries: Number of the remaining attempts of the method. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
            This field is None if it is not applicable.
        :type  start_time: :class:`datetime.datetime`
        :param start_time: Time when the method started. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
        :type  end_time: :class:`datetime.datetime`
        :param end_time: Time when the method completed. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
        :type  notifications: :class:`com.vmware.esx.settings_client.Notifications`
        :param notifications: Notifications providing additional information about the status of
            the method. **Warning:** This attribute is available as Technology
            Preview. These are early access APIs provided to test, automate and
            provide feedback on the feature. Since this can change based on
            feedback, VMware does not guarantee backwards compatibility and
            recommends against using them in production environments. Some
            Technology Preview APIs might only be applicable to specific
            environments.
        """
        self.status = status
        self.attempts = attempts
        self.remaining_retries = remaining_retries
        self.start_time = start_time
        self.end_time = end_time
        self.notifications = notifications
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        The ``HostStatus.Status`` class contains the possible different status
        codes that can be returned while trying to perform an operation on the
        hosts within the cluster. **Warning:** This enumeration is available as
        Technology Preview. These are early access APIs provided to test, automate
        and provide feedback on the feature. Since this can change based on
        feedback, VMware does not guarantee backwards compatibility and recommends
        against using them in production environments. Some Technology Preview APIs
        might only be applicable to specific environments.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        OK = None
        """
        The method completed successfully. **Warning:** This class attribute is
        available as Technology Preview. These are early access APIs provided to
        test, automate and provide feedback on the feature. Since this can change
        based on feedback, VMware does not guarantee backwards compatibility and
        recommends against using them in production environments. Some Technology
        Preview APIs might only be applicable to specific environments.

        """
        PENDING = None
        """
        The method is pending. **Warning:** This class attribute is available as
        Technology Preview. These are early access APIs provided to test, automate
        and provide feedback on the feature. Since this can change based on
        feedback, VMware does not guarantee backwards compatibility and recommends
        against using them in production environments. Some Technology Preview APIs
        might only be applicable to specific environments.

        """
        RUNNING = None
        """
        The method is in progress. **Warning:** This class attribute is available
        as Technology Preview. These are early access APIs provided to test,
        automate and provide feedback on the feature. Since this can change based
        on feedback, VMware does not guarantee backwards compatibility and
        recommends against using them in production environments. Some Technology
        Preview APIs might only be applicable to specific environments.

        """
        RETRY_PENDING = None
        """
        The method is pending a retry. **Warning:** This class attribute is
        available as Technology Preview. These are early access APIs provided to
        test, automate and provide feedback on the feature. Since this can change
        based on feedback, VMware does not guarantee backwards compatibility and
        recommends against using them in production environments. Some Technology
        Preview APIs might only be applicable to specific environments.

        """
        SKIPPED = None
        """
        The method was skipped. **Warning:** This class attribute is available as
        Technology Preview. These are early access APIs provided to test, automate
        and provide feedback on the feature. Since this can change based on
        feedback, VMware does not guarantee backwards compatibility and recommends
        against using them in production environments. Some Technology Preview APIs
        might only be applicable to specific environments.

        """
        CANCELED = None
        """
        The method was canceled. **Warning:** This class attribute is available as
        Technology Preview. These are early access APIs provided to test, automate
        and provide feedback on the feature. Since this can change based on
        feedback, VMware does not guarantee backwards compatibility and recommends
        against using them in production environments. Some Technology Preview APIs
        might only be applicable to specific environments.

        """
        TIMED_OUT = None
        """
        The method timed out. **Warning:** This class attribute is available as
        Technology Preview. These are early access APIs provided to test, automate
        and provide feedback on the feature. Since this can change based on
        feedback, VMware does not guarantee backwards compatibility and recommends
        against using them in production environments. Some Technology Preview APIs
        might only be applicable to specific environments.

        """
        ERROR = None
        """
        The method encountered an unspecified error. **Warning:** This class
        attribute is available as Technology Preview. These are early access APIs
        provided to test, automate and provide feedback on the feature. Since this
        can change based on feedback, VMware does not guarantee backwards
        compatibility and recommends against using them in production environments.
        Some Technology Preview APIs might only be applicable to specific
        environments.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values({
        'OK': Status('OK'),
        'PENDING': Status('PENDING'),
        'RUNNING': Status('RUNNING'),
        'RETRY_PENDING': Status('RETRY_PENDING'),
        'SKIPPED': Status('SKIPPED'),
        'CANCELED': Status('CANCELED'),
        'TIMED_OUT': Status('TIMED_OUT'),
        'ERROR': Status('ERROR'),
    })
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.host_status.status',
        Status))

HostStatus._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_status', {
        'status': type.ReferenceType(__name__, 'HostStatus.Status'),
        'attempts': type.OptionalType(type.IntegerType()),
        'remaining_retries': type.OptionalType(type.IntegerType()),
        'start_time': type.DateTimeType(),
        'end_time': type.DateTimeType(),
        'notifications': type.ReferenceType('com.vmware.esx.settings_client', 'Notifications'),
    },
    HostStatus,
    False,
    None))



class SettingCompliance(VapiStruct):
    """
    The ``SettingCompliance`` class contains attributes that describe a drift
    in an ESXi host setting. This structure is used to describe either a change
    in configuration value(set) or addition of configuration or deletion of
    configuration. When used to describe addition or deletion of a setting,
    only the path is set. When used to describe a set operation, current and
    target values are set only if drift is in a property that is of primitive
    type. **Warning:** This class is available as Technology Preview. These are
    early access APIs provided to test, automate and provide feedback on the
    feature. Since this can change based on feedback, VMware does not guarantee
    backwards compatibility and recommends against using them in production
    environments. Some Technology Preview APIs might only be applicable to
    specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 path=None,
                 current=None,
                 target=None,
                ):
        """
        :type  path: :class:`str`
        :param path: Full path to the setting within the desired document. **Warning:**
            This attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
        :type  current: :class:`str` or ``None``
        :param current: Value of setting on the ESXi host. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            This field is None if there is no host value to report or if
            setting is of complex type.
        :type  target: :class:`str` or ``None``
        :param target: Value of setting in the desired document. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
            This field is None if there is no value in the desired document to
            report or if setting is of complex type.
        """
        self.path = path
        self.current = current
        self.target = target
        VapiStruct.__init__(self)


SettingCompliance._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.setting_compliance', {
        'path': type.StringType(),
        'current': type.OptionalType(type.StringType()),
        'target': type.OptionalType(type.StringType()),
    },
    SettingCompliance,
    False,
    None))



class ComplianceInfo(VapiStruct):
    """
    The ``ComplianceInfo`` class contains attributes that describe the
    configuration drift between the desired document and the configurations on
    the ESXi host. **Warning:** This class is available as Technology Preview.
    These are early access APIs provided to test, automate and provide feedback
    on the feature. Since this can change based on feedback, VMware does not
    guarantee backwards compatibility and recommends against using them in
    production environments. Some Technology Preview APIs might only be
    applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 sets=None,
                 adds=None,
                 deletes=None,
                ):
        """
        :type  sets: :class:`list` of :class:`SettingCompliance` or ``None``
        :param sets: List of configuration drifts represented by
            :class:`SettingCompliance`. Each describing a configuration whose
            value on ESXi host is different to that in the desired document.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
            This field is None if there are no drifts to report in this
            category.
        :type  adds: :class:`list` of :class:`SettingCompliance` or ``None``
        :param adds: List of configuration drifts represented by
            :class:`SettingCompliance`. Each describing a configuration that is
            present in the desired document but absent on the ESXi host.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
            This field is None if there are no drifts to report in this
            category.
        :type  deletes: :class:`list` of :class:`SettingCompliance` or ``None``
        :param deletes: List of configuration drifts represented by
            :class:`SettingCompliance`. Each describing a configuration that is
            present on the ESXi host but absent in the desired document.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
            This field is None if there are no drifts to report in this
            category.
        """
        self.sets = sets
        self.adds = adds
        self.deletes = deletes
        VapiStruct.__init__(self)


ComplianceInfo._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.compliance_info', {
        'sets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SettingCompliance'))),
        'adds': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SettingCompliance'))),
        'deletes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SettingCompliance'))),
    },
    ComplianceInfo,
    False,
    None))



class HostCompliance(VapiStruct):
    """
    The ``HostCompliance`` class contains attributes that describe compliance
    information for the ESXi host on which the Check Compliance operation
    completed successfully. **Warning:** This class is available as Technology
    Preview. These are early access APIs provided to test, automate and provide
    feedback on the feature. Since this can change based on feedback, VMware
    does not guarantee backwards compatibility and recommends against using
    them in production environments. Some Technology Preview APIs might only be
    applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'status',
            {
                'NON_COMPLIANT' : [('compliance_info', True)],
                'COMPLIANT' : [],
            }
        ),
    ]



    def __init__(self,
                 status=None,
                 compliance_info=None,
                ):
        """
        :type  status: :class:`ComplianceStatus`
        :param status: This field indicates whether the ESXi host is compliant with the
            desired configuration specified in
            com.vmware.esx.settings_daemon.Configuration#CheckComplianceSpec.
            If COMPLIANT, no other information is available. If NON_COMPLAINT,
            drift information can be fetched from {#ComplianceInfo}.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
        :type  compliance_info: :class:`ComplianceInfo`
        :param compliance_info: Settings compliance information generated by the CheckCompliance
            operation. **Warning:** This attribute is available as Technology
            Preview. These are early access APIs provided to test, automate and
            provide feedback on the feature. Since this can change based on
            feedback, VMware does not guarantee backwards compatibility and
            recommends against using them in production environments. Some
            Technology Preview APIs might only be applicable to specific
            environments.
            This attribute is optional and it is only relevant when the value
            of ``status`` is :attr:`ComplianceStatus.NON_COMPLIANT`.
        """
        self.status = status
        self.compliance_info = compliance_info
        VapiStruct.__init__(self)


HostCompliance._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_compliance', {
        'status': type.ReferenceType(__name__, 'ComplianceStatus'),
        'compliance_info': type.OptionalType(type.ReferenceType(__name__, 'ComplianceInfo')),
    },
    HostCompliance,
    False,
    None))



class HostResult(VapiStruct):
    """
    This ``HostResult`` class contains attributes that describe the result of
    the check compliance operation on an ESXi host. **Warning:** This class is
    available as Technology Preview. These are early access APIs provided to
    test, automate and provide feedback on the feature. Since this can change
    based on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host_status=None,
                 summary=None,
                 errors=None,
                 host_compliance=None,
                ):
        """
        :type  host_status: :class:`HostStatus`
        :param host_status: This field represents the status of the check compliance operation.
            If status is OK, the result of operation can be retrived from
            {#HostCompliance} {#Summary} field will summarize the status of the
            operation and if applicable, the specific error that occured.
            Additionally, {#ValidationError} is populated if the operation
            fails due to host validation errors in desired document.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
        :type  summary: :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param summary: Summary of check compliance operation on the host. **Warning:**
            This attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
        :type  errors: :class:`list` of :class:`ValidationError` or ``None``
        :param errors: List of validation errors returned by the host. This is only set
            for a specific HostStatus ERROR case. **Warning:** This attribute
            is available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            This field is :class:`set` only if the document fails to validate
            on the host.
        :type  host_compliance: :class:`HostCompliance` or ``None``
        :param host_compliance: This field provides compliance results for the host if the
            operation successfully completed on the host. That is, this field
            is populated only if HostStatus is OK. **Warning:** This attribute
            is available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            This field is None if check compliance could not be completed on
            the host.
        """
        self.host_status = host_status
        self.summary = summary
        self.errors = errors
        self.host_compliance = host_compliance
        VapiStruct.__init__(self)


HostResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_result', {
        'host_status': type.ReferenceType(__name__, 'HostStatus'),
        'summary': type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage'),
        'errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ValidationError'))),
        'host_compliance': type.OptionalType(type.ReferenceType(__name__, 'HostCompliance')),
    },
    HostResult,
    False,
    None))



class ClusterCompliance(VapiStruct):
    """
    This ``ClusterCompliance`` class contains attributes that describe the
    compliance result for each host in the cluster as well as overall cluster
    compliance status. **Warning:** This class is available as Technology
    Preview. These are early access APIs provided to test, automate and provide
    feedback on the feature. Since this can change based on feedback, VMware
    does not guarantee backwards compatibility and recommends against using
    them in production environments. Some Technology Preview APIs might only be
    applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 cluster_status=None,
                 commit=None,
                 software_commit=None,
                 summary=None,
                 host_info=None,
                 hosts=None,
                 compliant_hosts=None,
                 non_compliant_hosts=None,
                 failed_hosts=None,
                 skipped_hosts=None,
                 end_time=None,
                ):
        """
        :type  cluster_status: :class:`ClusterCompliance.Status`
        :param cluster_status: Consolidated status of all host compliance checks. **Warning:**
            This attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
        :type  commit: :class:`str` or ``None``
        :param commit: This identifier refers to the commit action of importing the
            desired configuration document. It will not be set for a draft
            execution of check compliance. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
        :type  software_commit: :class:`str`
        :param software_commit: The current commit ID for the software associated with the cluster.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
        :type  summary: :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param summary: Summarizing check compliance operation on the hosts in the cluster.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
        :type  host_info: :class:`dict` of :class:`str` and :class:`com.vmware.esx.settings_client.HostInfo`
        :param host_info: Map of host IDs to hostname. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        :type  hosts: :class:`dict` of :class:`str` and :class:`HostResult`
        :param hosts: Map of host IDs to their compliance results. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        :type  compliant_hosts: :class:`set` of :class:`str`
        :param compliant_hosts: Identifiers of compliant hosts. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  non_compliant_hosts: :class:`set` of :class:`str`
        :param non_compliant_hosts: Identifiers of non-compliant hosts. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  failed_hosts: :class:`set` of :class:`str`
        :param failed_hosts: Identifiers of hosts where the operation failed. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  skipped_hosts: :class:`set` of :class:`str`
        :param skipped_hosts: Identifiers of hosts where the operation was skipped. i.e
            disconnected hosts. **Warning:** This attribute is available as
            Technology Preview. These are early access APIs provided to test,
            automate and provide feedback on the feature. Since this can change
            based on feedback, VMware does not guarantee backwards
            compatibility and recommends against using them in production
            environments. Some Technology Preview APIs might only be applicable
            to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  end_time: :class:`datetime.datetime`
        :param end_time: CheckCompliance completion time. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
        """
        self.cluster_status = cluster_status
        self.commit = commit
        self.software_commit = software_commit
        self.summary = summary
        self.host_info = host_info
        self.hosts = hosts
        self.compliant_hosts = compliant_hosts
        self.non_compliant_hosts = non_compliant_hosts
        self.failed_hosts = failed_hosts
        self.skipped_hosts = skipped_hosts
        self.end_time = end_time
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        Consolidated compliance status of the cluster. **Warning:** This
        enumeration is available as Technology Preview. These are early access APIs
        provided to test, automate and provide feedback on the feature. Since this
        can change based on feedback, VMware does not guarantee backwards
        compatibility and recommends against using them in production environments.
        Some Technology Preview APIs might only be applicable to specific
        environments.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        RUNNING = None
        """
        The task is in-progress. **Warning:** This class attribute is available as
        Technology Preview. These are early access APIs provided to test, automate
        and provide feedback on the feature. Since this can change based on
        feedback, VMware does not guarantee backwards compatibility and recommends
        against using them in production environments. Some Technology Preview APIs
        might only be applicable to specific environments.

        """
        COMPLIANT = None
        """
        All hosts in the cluster are compliant. **Warning:** This class attribute
        is available as Technology Preview. These are early access APIs provided to
        test, automate and provide feedback on the feature. Since this can change
        based on feedback, VMware does not guarantee backwards compatibility and
        recommends against using them in production environments. Some Technology
        Preview APIs might only be applicable to specific environments.

        """
        NOT_COMPLIANT = None
        """


        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values({
        'RUNNING': Status('RUNNING'),
        'COMPLIANT': Status('COMPLIANT'),
        'NOT_COMPLIANT': Status('NOT_COMPLIANT'),
    })
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.cluster_compliance.status',
        Status))

ClusterCompliance._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.cluster_compliance', {
        'cluster_status': type.ReferenceType(__name__, 'ClusterCompliance.Status'),
        'commit': type.OptionalType(type.IdType()),
        'software_commit': type.IdType(resource_types='com.vmware.esx.settings.commit'),
        'summary': type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage'),
        'host_info': type.MapType(type.IdType(), type.ReferenceType('com.vmware.esx.settings_client', 'HostInfo')),
        'hosts': type.MapType(type.IdType(), type.ReferenceType(__name__, 'HostResult')),
        'compliant_hosts': type.SetType(type.IdType()),
        'non_compliant_hosts': type.SetType(type.IdType()),
        'failed_hosts': type.SetType(type.IdType()),
        'skipped_hosts': type.SetType(type.IdType()),
        'end_time': type.DateTimeType(),
    },
    ClusterCompliance,
    False,
    None))



class ValidationError(VapiStruct):
    """
    The ``ValidationError`` class contains attributes that describes a
    validation error in the configuration. **Warning:** This class is available
    as Technology Preview. These are early access APIs provided to test,
    automate and provide feedback on the feature. Since this can change based
    on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 path=None,
                 messages=None,
                ):
        """
        :type  path: :class:`str`
        :param path: Full path to the configuration or the property within the
            configuration which was found to be invalid. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
        :type  messages: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param messages: Localized error message describing the validation error.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
        """
        self.path = path
        self.messages = messages
        VapiStruct.__init__(self)


ValidationError._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.validation_error', {
        'path': type.StringType(),
        'messages': type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
    },
    ValidationError,
    False,
    None))



class ValidationResult(VapiStruct):
    """
    This ``ValidationResult`` class contains attributes that describe the
    result of validating a configuration document. **Warning:** This class is
    available as Technology Preview. These are early access APIs provided to
    test, automate and provide feedback on the feature. Since this can change
    based on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 valid=None,
                 errors=None,
                ):
        """
        :type  valid: :class:`bool`
        :param valid: This boolean flag indicates whether the configuration document
            validated successfully with no validation errors. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
        :type  errors: :class:`list` of :class:`ValidationError` or ``None``
        :param errors: Lists all validation errors identified in the configuration
            document. **Warning:** This attribute is available as Technology
            Preview. These are early access APIs provided to test, automate and
            provide feedback on the feature. Since this can change based on
            feedback, VMware does not guarantee backwards compatibility and
            recommends against using them in production environments. Some
            Technology Preview APIs might only be applicable to specific
            environments.
            This is set when :attr:`ValidationResult.valid` is false.
        """
        self.valid = valid
        self.errors = errors
        VapiStruct.__init__(self)


ValidationResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.validation_result', {
        'valid': type.BooleanType(),
        'errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ValidationError'))),
    },
    ValidationResult,
    False,
    None))



class ImpactInfo(VapiStruct):
    """
    This ``ImpactInfo`` class contains attributes that describes the Impact if
    the host is not compliant against the desired configuration. **Warning:**
    This class is available as Technology Preview. These are early access APIs
    provided to test, automate and provide feedback on the feature. Since this
    can change based on feedback, VMware does not guarantee backwards
    compatibility and recommends against using them in production environments.
    Some Technology Preview APIs might only be applicable to specific
    environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 impact=None,
                 info=None,
                ):
        """
        :type  impact: :class:`ImpactType`
        :param impact: This field indicates the ESXi host impact on applying the desired
            configuration. **Warning:** This attribute is available as
            Technology Preview. These are early access APIs provided to test,
            automate and provide feedback on the feature. Since this can change
            based on feedback, VMware does not guarantee backwards
            compatibility and recommends against using them in production
            environments. Some Technology Preview APIs might only be applicable
            to specific environments.
        :type  info: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param info: This field represents the list of impact information describing the
            configuration changes needed on the host to reach the desired
            state. **Warning:** This attribute is available as Technology
            Preview. These are early access APIs provided to test, automate and
            provide feedback on the feature. Since this can change based on
            feedback, VMware does not guarantee backwards compatibility and
            recommends against using them in production environments. Some
            Technology Preview APIs might only be applicable to specific
            environments.
        """
        self.impact = impact
        self.info = info
        VapiStruct.__init__(self)


ImpactInfo._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.impact_info', {
        'impact': type.ReferenceType(__name__, 'ImpactType'),
        'info': type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
    },
    ImpactInfo,
    False,
    None))



class HostPrecheckResult(VapiStruct):
    """
    This ``HostPrecheckResult`` class contains attributes that describes the
    Precheck API result on a host. **Warning:** This class is available as
    Technology Preview. These are early access APIs provided to test, automate
    and provide feedback on the feature. Since this can change based on
    feedback, VMware does not guarantee backwards compatibility and recommends
    against using them in production environments. Some Technology Preview APIs
    might only be applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 status=None,
                 summary=None,
                 validation_errors=None,
                 impact=None,
                 precheck_result=None,
                ):
        """
        :type  status: :class:`HostStatus`
        :param status: This field represents the status of the precheck request for this
            host. {link HostStatus#status} is ERROR or SKIPPED, if precheck was
            not completed on the host due to some error or if health checks
            failed. If precheck failed due to host validation errors, details
            are specified in :attr:`HostPrecheckResult.validation_errors`. If
            precheck failed due to generic error, details are specified in the
            :attr:`HostPrecheckResult.summary`. Health check result is
            specified in :attr:`HostPrecheckResult.precheck_result`.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
        :type  summary: :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param summary: Summarizing precheck operation on the host. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
        :type  validation_errors: :class:`list` of :class:`ValidationError` or ``None``
        :param validation_errors: This field represents the validation errors if the desired
            configuration specified is not valid. **Warning:** This attribute
            is available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            This field is :class:`set` if #HostStatus#status is ERROR due to
            host returning validation errors.
        :type  impact: :class:`ImpactInfo` or ``None``
        :param impact: This field represents the impact on the host to reach the desired
            configuration state. **Warning:** This attribute is available as
            Technology Preview. These are early access APIs provided to test,
            automate and provide feedback on the feature. Since this can change
            based on feedback, VMware does not guarantee backwards
            compatibility and recommends against using them in production
            environments. Some Technology Preview APIs might only be applicable
            to specific environments.
            This field is :class:`set` if there are no validation errors on the
            host. The :attr:`HostStatus.status` may be OK or ERROR.
        :type  precheck_result: :class:`com.vmware.esx.settings_client.StatusInfo` or ``None``
        :param precheck_result: This field represents the health check results from the host, if
            the host needs to be put in maintenance mode or to be rebooted.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
            This field is :class:`set` if there are not validation errors and
            health checks are run on the host. The :attr:`HostStatus.status`
            may be OK or ERROR.
        """
        self.status = status
        self.summary = summary
        self.validation_errors = validation_errors
        self.impact = impact
        self.precheck_result = precheck_result
        VapiStruct.__init__(self)


HostPrecheckResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.host_precheck_result', {
        'status': type.ReferenceType(__name__, 'HostStatus'),
        'summary': type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage'),
        'validation_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ValidationError'))),
        'impact': type.OptionalType(type.ReferenceType(__name__, 'ImpactInfo')),
        'precheck_result': type.OptionalType(type.ReferenceType('com.vmware.esx.settings_client', 'StatusInfo')),
    },
    HostPrecheckResult,
    False,
    None))



class ClusterPrecheckResult(VapiStruct):
    """
    The ``PrecheckResult`` class contains attributes that describe precheck
    status of applying the desired document to a group of hosts. **Warning:**
    This class is available as Technology Preview. These are early access APIs
    provided to test, automate and provide feedback on the feature. Since this
    can change based on feedback, VMware does not guarantee backwards
    compatibility and recommends against using them in production environments.
    Some Technology Preview APIs might only be applicable to specific
    environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 status=None,
                 commit=None,
                 software_commit=None,
                 end_time=None,
                 summary=None,
                 remediation_summary=None,
                 remediation_notes=None,
                 host_info=None,
                 host_precheck=None,
                 precheck_result=None,
                 successful_hosts=None,
                 failed_hosts=None,
                 skipped_hosts=None,
                ):
        """
        :type  status: :class:`ClusterPrecheckResult.Status`
        :param status: Overall status of precheck on the cluster. Operation is sucessfull
            when precheck is run on all hosts successfully and no validation or
            precheck errors are detected. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
        :type  commit: :class:`str` or ``None``
        :param commit: This identifier refers to the commit action of importing the
            desired configuration document. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
            This field is s not set for a precheck of a draft configuration.
        :type  software_commit: :class:`str`
        :param software_commit: The current commit ID for the software associated with the cluster.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
        :type  end_time: :class:`datetime.datetime`
        :param end_time: Precheck completion time. **Warning:** This attribute is available
            as Technology Preview. These are early access APIs provided to
            test, automate and provide feedback on the feature. Since this can
            change based on feedback, VMware does not guarantee backwards
            compatibility and recommends against using them in production
            environments. Some Technology Preview APIs might only be applicable
            to specific environments.
        :type  summary: :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param summary: Summarizing precheck operation on the host and cluster.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
        :type  remediation_summary: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param remediation_summary: Summarizing remediation stating number of hosts needing reboot and
            maintenance mode during remediation and number of precheck errors
            on host and cluster. **Warning:** This attribute is available as
            Technology Preview. These are early access APIs provided to test,
            automate and provide feedback on the feature. Since this can change
            based on feedback, VMware does not guarantee backwards
            compatibility and recommends against using them in production
            environments. Some Technology Preview APIs might only be applicable
            to specific environments.
        :type  remediation_notes: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param remediation_notes: Static notes to the user describing steps that will be taken during
            remediation. **Warning:** This attribute is available as Technology
            Preview. These are early access APIs provided to test, automate and
            provide feedback on the feature. Since this can change based on
            feedback, VMware does not guarantee backwards compatibility and
            recommends against using them in production environments. Some
            Technology Preview APIs might only be applicable to specific
            environments.
        :type  host_info: :class:`dict` of :class:`str` and :class:`com.vmware.esx.settings_client.HostInfo`
        :param host_info: Map of host IDs to hostname. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        :type  host_precheck: :class:`dict` of :class:`str` and :class:`HostPrecheckResult`
        :param host_precheck: Map of host IDs to their precheck results. If
            :attr:`ClusterPrecheckResult.status` is ERROR, This field will
            contain Validation errors or Host Impact and Health Check errors.
            If :attr:`ClusterPrecheckResult.status` is OK, This field will
            contain Impact and Health Check information. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
            When clients pass a value of this class as a parameter, the key in
            the attribute :class:`dict` must be an identifier for the resource
            type: ``HostSystem``. When methods return a value of this class as
            a return value, the key in the attribute :class:`dict` will be an
            identifier for the resource type: ``HostSystem``.
        :type  precheck_result: :class:`com.vmware.esx.settings_client.StatusInfo` or ``None``
        :param precheck_result: This field represents the precheck results on the cluster, if any
            one host in the cluster needs to be put in maintenance mode or to
            be rebooted. **Warning:** This attribute is available as Technology
            Preview. These are early access APIs provided to test, automate and
            provide feedback on the feature. Since this can change based on
            feedback, VMware does not guarantee backwards compatibility and
            recommends against using them in production environments. Some
            Technology Preview APIs might only be applicable to specific
            environments.
            This field is set if cluster prechecks are invoked.
        :type  successful_hosts: :class:`set` of :class:`str`
        :param successful_hosts: Hosts in this cluster where the precheck was sucessfully run.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  failed_hosts: :class:`set` of :class:`str`
        :param failed_hosts: Hosts in this cluster where the precheck failed to run.
            **Warning:** This attribute is available as Technology Preview.
            These are early access APIs provided to test, automate and provide
            feedback on the feature. Since this can change based on feedback,
            VMware does not guarantee backwards compatibility and recommends
            against using them in production environments. Some Technology
            Preview APIs might only be applicable to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        :type  skipped_hosts: :class:`set` of :class:`str`
        :param skipped_hosts: Hosts in this cluster where the precheck was not tried because the
            host was disconnected. **Warning:** This attribute is available as
            Technology Preview. These are early access APIs provided to test,
            automate and provide feedback on the feature. Since this can change
            based on feedback, VMware does not guarantee backwards
            compatibility and recommends against using them in production
            environments. Some Technology Preview APIs might only be applicable
            to specific environments.
            When clients pass a value of this class as a parameter, the
            attribute must contain identifiers for the resource type:
            ``HostSystem``. When methods return a value of this class as a
            return value, the attribute will contain identifiers for the
            resource type: ``HostSystem``.
        """
        self.status = status
        self.commit = commit
        self.software_commit = software_commit
        self.end_time = end_time
        self.summary = summary
        self.remediation_summary = remediation_summary
        self.remediation_notes = remediation_notes
        self.host_info = host_info
        self.host_precheck = host_precheck
        self.precheck_result = precheck_result
        self.successful_hosts = successful_hosts
        self.failed_hosts = failed_hosts
        self.skipped_hosts = skipped_hosts
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        The ``ClusterPrecheckResult.Status`` class contains the possible statuses
        of the Precheck API on the cluster. **Warning:** This enumeration is
        available as Technology Preview. These are early access APIs provided to
        test, automate and provide feedback on the feature. Since this can change
        based on feedback, VMware does not guarantee backwards compatibility and
        recommends against using them in production environments. Some Technology
        Preview APIs might only be applicable to specific environments.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        RUNNING = None
        """
        The task is in-progress. **Warning:** This class attribute is available as
        Technology Preview. These are early access APIs provided to test, automate
        and provide feedback on the feature. Since this can change based on
        feedback, VMware does not guarantee backwards compatibility and recommends
        against using them in production environments. Some Technology Preview APIs
        might only be applicable to specific environments.

        """
        OK = None
        """
        The operation completed successfully. **Warning:** This class attribute is
        available as Technology Preview. These are early access APIs provided to
        test, automate and provide feedback on the feature. Since this can change
        based on feedback, VMware does not guarantee backwards compatibility and
        recommends against using them in production environments. Some Technology
        Preview APIs might only be applicable to specific environments.

        """
        ERROR = None
        """
        The operation failed with errors. **Warning:** This class attribute is
        available as Technology Preview. These are early access APIs provided to
        test, automate and provide feedback on the feature. Since this can change
        based on feedback, VMware does not guarantee backwards compatibility and
        recommends against using them in production environments. Some Technology
        Preview APIs might only be applicable to specific environments.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values({
        'RUNNING': Status('RUNNING'),
        'OK': Status('OK'),
        'ERROR': Status('ERROR'),
    })
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.cluster_precheck_result.status',
        Status))

ClusterPrecheckResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.cluster_precheck_result', {
        'status': type.ReferenceType(__name__, 'ClusterPrecheckResult.Status'),
        'commit': type.OptionalType(type.IdType()),
        'software_commit': type.IdType(resource_types='com.vmware.esx.settings.commit'),
        'end_time': type.DateTimeType(),
        'summary': type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage'),
        'remediation_summary': type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
        'remediation_notes': type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
        'host_info': type.MapType(type.IdType(), type.ReferenceType('com.vmware.esx.settings_client', 'HostInfo')),
        'host_precheck': type.MapType(type.IdType(), type.ReferenceType(__name__, 'HostPrecheckResult')),
        'precheck_result': type.OptionalType(type.ReferenceType('com.vmware.esx.settings_client', 'StatusInfo')),
        'successful_hosts': type.SetType(type.IdType()),
        'failed_hosts': type.SetType(type.IdType()),
        'skipped_hosts': type.SetType(type.IdType()),
    },
    ClusterPrecheckResult,
    False,
    None))



class ImportResult(VapiStruct):
    """
    This ``ImportResult`` class contains attributes that describe the result of
    importing a configuration document in the cluster. **Warning:** This class
    is available as Technology Preview. These are early access APIs provided to
    test, automate and provide feedback on the feature. Since this can change
    based on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'status',
            {
                'OK' : [('commit', True)],
                'ERROR' : [('errors', True)],
                'RUNNING' : [],
                'CANCELED' : [],
            }
        ),
    ]



    def __init__(self,
                 status=None,
                 commit=None,
                 errors=None,
                ):
        """
        :type  status: :class:`ImportResult.Status`
        :param status: 
        :type  commit: :class:`str`
        :param commit: This identifier refers to the commit action of importing the
            desired configuration document. This identifier can be used in the
            apply API. **Warning:** This attribute is available as Technology
            Preview. These are early access APIs provided to test, automate and
            provide feedback on the feature. Since this can change based on
            feedback, VMware does not guarantee backwards compatibility and
            recommends against using them in production environments. Some
            Technology Preview APIs might only be applicable to specific
            environments.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.commit``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.commit``.
            This attribute is optional and it is only relevant when the value
            of ``status`` is :attr:`ImportResult.Status.OK`.
        :type  errors: :class:`list` of :class:`ValidationError`
        :param errors: Lists all validation errors identified in the configuration
            document. **Warning:** This attribute is available as Technology
            Preview. These are early access APIs provided to test, automate and
            provide feedback on the feature. Since this can change based on
            feedback, VMware does not guarantee backwards compatibility and
            recommends against using them in production environments. Some
            Technology Preview APIs might only be applicable to specific
            environments.
            This is set when #success is false.
        """
        self.status = status
        self.commit = commit
        self.errors = errors
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        This enum indicates whether the configuration document was imported
        successfully in the cluster. **Warning:** This enumeration is available as
        Technology Preview. These are early access APIs provided to test, automate
        and provide feedback on the feature. Since this can change based on
        feedback, VMware does not guarantee backwards compatibility and recommends
        against using them in production environments. Some Technology Preview APIs
        might only be applicable to specific environments.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        RUNNING = None
        """
        The task is in-progress. **Warning:** This class attribute is available as
        Technology Preview. These are early access APIs provided to test, automate
        and provide feedback on the feature. Since this can change based on
        feedback, VMware does not guarantee backwards compatibility and recommends
        against using them in production environments. Some Technology Preview APIs
        might only be applicable to specific environments.

        """
        OK = None
        """


        """
        ERROR = None
        """


        """
        CANCELED = None
        """


        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values({
        'RUNNING': Status('RUNNING'),
        'OK': Status('OK'),
        'ERROR': Status('ERROR'),
        'CANCELED': Status('CANCELED'),
    })
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.import_result.status',
        Status))

ImportResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.import_result', {
        'status': type.ReferenceType(__name__, 'ImportResult.Status'),
        'commit': type.OptionalType(type.IdType()),
        'errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ValidationError'))),
    },
    ImportResult,
    False,
    None))



class DraftImportResult(VapiStruct):
    """
    The ``DraftImportResult`` class contains attributes that describe the
    result of importing the desired configuration for a cluster into a draft.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'status',
            {
                'OK' : [('draft', True)],
                'ERROR' : [('error', True)],
                'RUNNING' : [],
                'CANCELED' : [],
            }
        ),
    ]



    def __init__(self,
                 status=None,
                 draft=None,
                 error=None,
                 warnings=None,
                ):
        """
        :type  status: :class:`DraftImportResult.Status`
        :param status: Status of importing desired configuration.
        :type  draft: :class:`str`
        :param draft: This identifier refers to the commit action of importing the
            desired configuration document. This identifier can be used in the
            apply API.
            When clients pass a value of this class as a parameter, the
            attribute must be an identifier for the resource type:
            ``com.vmware.esx.settings.draft``. When methods return a value of
            this class as a return value, the attribute will be an identifier
            for the resource type: ``com.vmware.esx.settings.draft``.
            This attribute is optional and it is only relevant when the value
            of ``status`` is :attr:`DraftImportResult.Status.OK`.
        :type  error: :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param error: Localized message describing the error encountered while importing
            desired configuration. The import operation will fail if the
            configuration document is an invalid JSON.
            This attribute is optional and it is only relevant when the value
            of ``status`` is :attr:`DraftImportResult.Status.ERROR`.
        :type  warnings: :class:`list` of :class:`com.vmware.vapi.std_client.LocalizableMessage` or ``None``
        :param warnings: Any issues found during the import are reported in this list.
        """
        self.status = status
        self.draft = draft
        self.error = error
        self.warnings = warnings
        VapiStruct.__init__(self)


    class Status(Enum):
        """
        The ``DraftImportResult.Status`` class contains the possible status codes
        describing the result of importing desired configuration for a cluster.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        RUNNING = None
        """
        The task is in-progress.

        """
        OK = None
        """
        Desired configuration imported successfully.

        """
        ERROR = None
        """
        Desired configuration import failed with error.

        """
        CANCELED = None
        """


        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Status` instance.
            """
            Enum.__init__(string)

    Status._set_values({
        'RUNNING': Status('RUNNING'),
        'OK': Status('OK'),
        'ERROR': Status('ERROR'),
        'CANCELED': Status('CANCELED'),
    })
    Status._set_binding_type(type.EnumType(
        'com.vmware.esx.settings.clusters.configuration.draft_import_result.status',
        Status))

DraftImportResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.draft_import_result', {
        'status': type.ReferenceType(__name__, 'DraftImportResult.Status'),
        'draft': type.OptionalType(type.IdType()),
        'error': type.OptionalType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
        'warnings': type.OptionalType(type.ListType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage'))),
    },
    DraftImportResult,
    False,
    None))



class ExportResult(VapiStruct):
    """
    This ``ExportResult`` class contains attributes that describe the result of
    exporting configuration from the cluster. **Warning:** This class is
    available as Technology Preview. These are early access APIs provided to
    test, automate and provide feedback on the feature. Since this can change
    based on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 config=None,
                ):
        """
        :type  config: :class:`str`
        :param config: Configuration of the cluster encoded as JSON. **Warning:** This
            attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
        """
        self.config = config
        VapiStruct.__init__(self)


ExportResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.export_result', {
        'config': type.StringType(),
    },
    ExportResult,
    False,
    None))



class ConfigurationSpec(VapiStruct):
    """
    The ``ConfigurationSpec`` class contains attributes that describe the
    desired configuration that is associated with a cluster. **Warning:** This
    class is available as Technology Preview. These are early access APIs
    provided to test, automate and provide feedback on the feature. Since this
    can change based on feedback, VMware does not guarantee backwards
    compatibility and recommends against using them in production environments.
    Some Technology Preview APIs might only be applicable to specific
    environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 spec=None,
                ):
        """
        :type  spec: :class:`str`
        :param spec: Desired configuration document. **Warning:** This attribute is
            available as Technology Preview. These are early access APIs
            provided to test, automate and provide feedback on the feature.
            Since this can change based on feedback, VMware does not guarantee
            backwards compatibility and recommends against using them in
            production environments. Some Technology Preview APIs might only be
            applicable to specific environments.
        """
        self.spec = spec
        VapiStruct.__init__(self)


ConfigurationSpec._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.configuration_spec', {
        'spec': type.StringType(),
    },
    ConfigurationSpec,
    False,
    None))



class SchemaResult(VapiStruct):
    """
    The ``SchemaResult`` class contains attributes that describe the
    configuration schema associated with the cluster. **Warning:** This class
    is available as Technology Preview. These are early access APIs provided to
    test, automate and provide feedback on the feature. Since this can change
    based on feedback, VMware does not guarantee backwards compatibility and
    recommends against using them in production environments. Some Technology
    Preview APIs might only be applicable to specific environments.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 schema=None,
                ):
        """
        :type  schema: :class:`str`
        :param schema: The configuration schema associated with the cluster. **Warning:**
            This attribute is available as Technology Preview. These are early
            access APIs provided to test, automate and provide feedback on the
            feature. Since this can change based on feedback, VMware does not
            guarantee backwards compatibility and recommends against using them
            in production environments. Some Technology Preview APIs might only
            be applicable to specific environments.
        """
        self.schema = schema
        VapiStruct.__init__(self)


SchemaResult._set_binding_type(type.StructType(
    'com.vmware.esx.settings.clusters.configuration.schema_result', {
        'schema': type.StringType(),
    },
    SchemaResult,
    False,
    None))



class Schema(VapiInterface):
    """
    The ``Schema`` class provides methods to manage the desired configuration
    schema of an ESX cluster. **Warning:** This class is available as
    Technology Preview. These are early access APIs provided to test, automate
    and provide feedback on the feature. Since this can change based on
    feedback, VMware does not guarantee backwards compatibility and recommends
    against using them in production environments. Some Technology Preview APIs
    might only be applicable to specific environments.
    """

    _VAPI_SERVICE_ID = 'com.vmware.esx.settings.clusters.configuration.schema'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SchemaStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            cluster,
            ):
        """
        Returns the configuration schema associated with the cluster.
        **Warning:** This method is available as Technology Preview. These are
        early access APIs provided to test, automate and provide feedback on
        the feature. Since this can change based on feedback, VMware does not
        guarantee backwards compatibility and recommends against using them in
        production environments. Some Technology Preview APIs might only be
        applicable to specific environments.

        :type  cluster: :class:`str`
        :param cluster: Identifier of the cluster.
            The parameter must be an identifier for the resource type:
            ``ClusterComputeResource``.
        :rtype: :class:`SchemaResult`
        :return: The schema associated with the ``cluster``
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            In case of an unknown internal error.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            If the ``cluster`` is invalid
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            If the schema associated with the ``cluster`` is not found
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            If the service is unavailable.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            If the session is unauthenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized`
            if you do not have all of the privileges described as follows: 
            
            * Method execution requires
              ``VcIntegrity.ClusterConfiguration.View``.
            * The resource ``ClusterComputeResource`` referenced by the
              parameter ``cluster`` requires
              ``VcIntegrity.ClusterConfiguration.View``.
        """
        return self._invoke('get',
                            {
                            'cluster': cluster,
                            })
class _SchemaStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'cluster': type.IdType(resource_types='ClusterComputeResource'),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/esx/settings/clusters/{cluster}/configuration/schema',
            path_variables={
                'cluster': 'cluster',
            },
            query_parameters={
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType(__name__, 'SchemaResult'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.esx.settings.clusters.configuration.schema',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=True)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Schema': Schema,
        'reports': 'com.vmware.esx.settings.clusters.configuration.reports_client.StubFactory',
    }

