# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2022 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.orgs.projects.infra.settings.firewall.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Security(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.infra.settings.firewall.security'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SecurityStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org_id,
            project_id,
            ):
        """
        Get the current dfw firewall configurations.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DfwFirewallConfiguration`
        :return: com.vmware.nsx_policy.model.DfwFirewallConfiguration
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            })

    def patch(self,
              org_id,
              project_id,
              dfw_firewall_configuration,
              ):
        """
        Update dfw firewall related configurations.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  dfw_firewall_configuration: :class:`com.vmware.nsx_policy.model_client.DfwFirewallConfiguration`
        :param dfw_firewall_configuration: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'dfw_firewall_configuration': dfw_firewall_configuration,
                            })

    def update(self,
               org_id,
               project_id,
               dfw_firewall_configuration,
               ):
        """
        Update dfw firewall related configurations.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  dfw_firewall_configuration: :class:`com.vmware.nsx_policy.model_client.DfwFirewallConfiguration`
        :param dfw_firewall_configuration: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DfwFirewallConfiguration`
        :return: com.vmware.nsx_policy.model.DfwFirewallConfiguration
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'dfw_firewall_configuration': dfw_firewall_configuration,
                            })
class Stats(VapiInterface):
    """
    
    """
    RESET_CATEGORY_DFW = "DFW"
    """
    Possible value for ``category`` of method :func:`Stats.reset`.

    """
    RESET_CATEGORY_EDGE = "EDGE"
    """
    Possible value for ``category`` of method :func:`Stats.reset`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.infra.settings.firewall.stats'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatsStub)
        self._VAPI_OPERATION_IDS = {}


    def reset(self,
              org_id,
              project_id,
              category,
              container_cluster_path=None,
              enforcement_point_path=None,
              ):
        """
        Sets firewall rule statistics counter to zero. This operation is
        supported for given category, for example: DFW i.e. for all layer3
        firewall (transport nodes only) rules or EDGE i.e. for all layer3 edge
        firewall (edge nodes only) rules. - no enforcement point path
        specified: On global manager, it is mandatory to give an enforcement
        point path. On local manager, reset of stats will be executed for each
        enforcement point. - {enforcement_point_path}: Reset of stats will be
        executed only for the given enforcement point.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  category: :class:`str`
        :param category: Aggregation statistic category (required)
        :type  container_cluster_path: :class:`str` or ``None``
        :param container_cluster_path: String Path of the Container Cluster entity (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('reset',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'category': category,
                            'container_cluster_path': container_cluster_path,
                            'enforcement_point_path': enforcement_point_path,
                            })
class _SecurityStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/settings/firewall/security',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'dfw_firewall_configuration': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DfwFirewallConfiguration'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/settings/firewall/security',
            request_body_parameter='dfw_firewall_configuration',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'dfw_firewall_configuration': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DfwFirewallConfiguration'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/settings/firewall/security',
            request_body_parameter='dfw_firewall_configuration',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DfwFirewallConfiguration'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DfwFirewallConfiguration'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.infra.settings.firewall.security',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for reset operation
        reset_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'category': type.StringType(),
            'container_cluster_path': type.OptionalType(type.StringType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        reset_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        reset_input_value_validator_list = [
        ]
        reset_output_validator_list = [
        ]
        reset_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/settings/firewall/stats?action=reset',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                       },
            query_parameters={
                'category': 'category',
                'container_cluster_path': 'container_cluster_path',
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'reset': {
                'input_type': reset_input_type,
                'output_type': type.VoidType(),
                'errors': reset_error_dict,
                'input_value_validator_list': reset_input_value_validator_list,
                'output_validator_list': reset_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'reset': reset_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.infra.settings.firewall.stats',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Security': Security,
        'Stats': Stats,
        'security': 'com.vmware.nsx_policy.orgs.projects.infra.settings.firewall.security_client.StubFactory',
    }

