/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.model.internal.manage.schema.extract.DefaultModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.type.ModelType;

@Contextual
public class InvalidManagedModelElementTypeException
extends RuntimeException {
    private static void createPathString(DefaultModelSchemaExtractionContext<?> extractionContext, StringBuilder out) {
        StringBuilder prefix = new StringBuilder("  ");
        LinkedList descriptions = Lists.newLinkedList();
        for (DefaultModelSchemaExtractionContext<?> current = extractionContext; current != null; current = current.getParent()) {
            descriptions.push(current.getDescription());
        }
        out.append((String)descriptions.pop());
        out.append('\n');
        while (!descriptions.isEmpty()) {
            out.append((CharSequence)prefix);
            out.append("\\--- ");
            out.append((String)descriptions.pop());
            if (descriptions.isEmpty()) continue;
            out.append('\n');
            prefix.append("  ");
        }
    }

    private static String getMessage(DefaultModelSchemaExtractionContext<?> extractionContext, String message) {
        ModelType<?> type = extractionContext.getType();
        StringBuilder out = new StringBuilder();
        out.append("Invalid managed model type ").append(type).append(": ").append(message);
        if (extractionContext.getParent() != null) {
            out.append('\n');
            out.append("The type was analyzed due to the following dependencies:\n");
            InvalidManagedModelElementTypeException.createPathString(extractionContext, out);
        }
        return out.toString();
    }

    private static String getMessage(DefaultModelSchemaExtractionContext<?> extractionContext) {
        StringBuilder out = new StringBuilder();
        out.append(extractionContext.getProblems().format());
        if (extractionContext.getParent() != null) {
            out.append("\n\n");
            out.append("The type was analyzed due to the following dependencies:\n");
            InvalidManagedModelElementTypeException.createPathString(extractionContext, out);
        }
        return out.toString();
    }

    public InvalidManagedModelElementTypeException(ModelSchemaExtractionContext<?> extractionContext) {
        super(InvalidManagedModelElementTypeException.getMessage((DefaultModelSchemaExtractionContext)extractionContext), null);
    }

    public InvalidManagedModelElementTypeException(ModelSchemaExtractionContext<?> extractionContext, String message) {
        this(extractionContext, message, null);
    }

    public InvalidManagedModelElementTypeException(ModelSchemaExtractionContext<?> extractionContext, String message, Throwable throwable) {
        super(InvalidManagedModelElementTypeException.getMessage((DefaultModelSchemaExtractionContext)extractionContext, message), throwable);
    }
}

